/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.rest.validation;

import com.browserup.bup.rest.validation.util.MessageSanitizer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={LongPositiveValidator.class})
public @interface LongPositiveConstraint {
    public String message() default "";

    public String paramName() default "";

    public Class<?>[] groups() default {};

    public int value();

    public Class<? extends Payload>[] payload() default {};

    public static class LongPositiveValidator
    implements ConstraintValidator<LongPositiveConstraint, String> {
        private static final Logger LOG = LoggerFactory.getLogger(LongPositiveValidator.class);

        public void initialize(LongPositiveConstraint constraintAnnotation) {
        }

        public boolean isValid(String value, ConstraintValidatorContext context) {
            long longValue = 0L;
            boolean failed = false;
            String errorMessage = "";
            try {
                longValue = Long.parseLong(value);
            }
            catch (NumberFormatException ex) {
                failed = true;
                String escapedValue = MessageSanitizer.escape(value);
                errorMessage = String.format("Invalid integer value: '%s'", escapedValue);
            }
            if (!failed && longValue < 0L) {
                failed = true;
                String escapedValue = MessageSanitizer.escape(value);
                errorMessage = String.format("Expected positive integer value, got: '%s'", escapedValue);
            }
            if (!failed) {
                return true;
            }
            LOG.warn(errorMessage);
            context.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
            return false;
        }
    }
}

