/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.rest.validation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={HttpStatusCodeValidator.class})
public @interface HttpStatusCodeConstraint {
    public String message() default "";

    public String paramName() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class HttpStatusCodeValidator
    implements ConstraintValidator<HttpStatusCodeConstraint, String> {
        private static final Logger LOG = LoggerFactory.getLogger(HttpStatusCodeValidator.class);

        public void initialize(HttpStatusCodeConstraint constraintAnnotation) {
        }

        public boolean isValid(String value, ConstraintValidatorContext context) {
            String errorMessage = "";
            boolean failed = false;
            if (StringUtils.isEmpty((CharSequence)value)) {
                errorMessage = "Expected not empty value";
                failed = true;
            }
            int status = 0;
            if (!failed) {
                try {
                    status = Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    errorMessage = "Expected integer value";
                    failed = true;
                }
            }
            if (!(failed || status >= 100 && status <= 599)) {
                errorMessage = "Expected valid HTTP status code";
                failed = true;
            }
            if (!failed) {
                return true;
            }
            LOG.warn(errorMessage);
            context.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
            return false;
        }
    }
}

