/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.rest.resource.mostrecent;

import com.browserup.bup.BrowserUpProxyServer;
import com.browserup.bup.assertion.model.AssertionResult;
import com.browserup.bup.proxy.ProxyManager;
import com.browserup.bup.rest.validation.HttpStatusCodeConstraint;
import com.browserup.bup.rest.validation.LongPositiveConstraint;
import com.browserup.bup.rest.validation.NotBlankConstraint;
import com.browserup.bup.rest.validation.NotNullConstraint;
import com.browserup.bup.rest.validation.PatternConstraint;
import com.browserup.bup.rest.validation.PortWithExistingProxyConstraint;
import com.browserup.bup.util.HttpStatusClass;
import com.browserup.harreader.model.HarEntry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.regex.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;

@Path(value="/proxy/{port}/har/mostRecentEntry")
public class MostRecentEntryProxyResource {
    private static final String URL_PATTERN = "urlPattern";
    private static final String PORT = "port";
    private static final String CONTENT_TEXT = "contentText";
    private static final String CONTENT_PATTERN = "contentPattern";
    private static final String LENGTH = "length";
    private static final String MILLISECONDS = "milliseconds";
    private static final String HEADER_NAME = "headerName";
    private static final String HEADER_VALUE = "headerValue";
    private static final String HEADER_NAME_PATTERN = "headerNamePattern";
    private static final String HEADER_VALUE_PATTERN = "headerValuePattern";
    private static final String STATUS = "status";
    private final ProxyManager proxyManager;

    public MostRecentEntryProxyResource(@Context ProxyManager proxyManager) {
        this.proxyManager = proxyManager;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(description="Search the entire log for the most recent entry whose request URL matches the given url.", responses={@ApiResponse(description="Har Entry", content={@Content(mediaType="application/json", schema=@Schema(implementation=HarEntry.class))})})
    public HarEntry mostRecentEntry(@PathParam(value="port") @NotNullConstraint(paramName="port") @PortWithExistingProxyConstraint @Parameter(required=true, in=ParameterIn.PATH, description="Proxy port, use /proxy endpoint to get available proxy ports.") int port, @QueryParam(value="urlPattern") @NotBlankConstraint(paramName="urlPattern") @PatternConstraint(paramName="urlPattern") @Parameter(required=true, description="Regular expression match of URL to find.\nURLs are formatted as: scheme://host:port/path?querystring.\nPort is not included in the URL if it is the standard port for the scheme.\nFragments (example.com/#fragment) should not be included in the URL.\nIf more than one URL found, use the most recently requested URL.\nPattern examples:\n- Match a URL with \"http\" or \"https\" protocol, \"example.com\" domain, and \"/index.html\" exact file path, with no query parameters:\n  \"^(http|https)://example\\\\.com/index\\\\.html$\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/customer\" exact path, followed by any query string:\n  \"^http://example\\\\.com/customer\\\\?.*\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/products\" path, and exactly 1 UUID query parameter named \"id\":\n  \"^http://example\\\\.com/products\\\\?id=[0-9a-fA-F]{8}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{12}$\"\n") String urlPattern) {
        return this.proxyManager.get(port).findMostRecentEntry(Pattern.compile(urlPattern)).orElse(new HarEntry());
    }

    @GET
    @Path(value="/assertContentContains")
    @Produces(value={"application/json"})
    @Operation(description="Assert that response content for the most recent request found by a given URL pattern contains specified value.", responses={@ApiResponse(description="Assertion result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AssertionResult.class))})})
    public AssertionResult contentContains(@PathParam(value="port") @NotNullConstraint(paramName="port") @PortWithExistingProxyConstraint @Parameter(required=true, in=ParameterIn.PATH, description="Proxy port, use /proxy endpoint to get available proxy ports.") int port, @QueryParam(value="urlPattern") @NotBlankConstraint(paramName="urlPattern") @PatternConstraint(paramName="urlPattern") @Parameter(required=true, description="Regular expression match of URL to find.\nURLs are formatted as: scheme://host:port/path?querystring.\nPort is not included in the URL if it is the standard port for the scheme.\nFragments (example.com/#fragment) should not be included in the URL.\nIf more than one URL found, use the most recently requested URL.\nPattern examples:\n- Match a URL with \"http\" or \"https\" protocol, \"example.com\" domain, and \"/index.html\" exact file path, with no query parameters:\n  \"^(http|https)://example\\\\.com/index\\\\.html$\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/customer\" exact path, followed by any query string:\n  \"^http://example\\\\.com/customer\\\\?.*\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/products\" path, and exactly 1 UUID query parameter named \"id\":\n  \"^http://example\\\\.com/products\\\\?id=[0-9a-fA-F]{8}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{12}$\"\n") String urlPattern, @QueryParam(value="contentText") @NotBlankConstraint(paramName="contentText") @Parameter(required=true, description="String to search in the content.") String contentText) {
        return this.proxyManager.get(port).assertMostRecentResponseContentContains(Pattern.compile(urlPattern), contentText);
    }

    @GET
    @Path(value="/assertContentDoesNotContain")
    @Produces(value={"application/json"})
    @Operation(description="Assert that response content for the most recent request found by a given URL pattern doesn't contain specified value.", responses={@ApiResponse(description="Assertion result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AssertionResult.class))})})
    public AssertionResult contentDoesNotContain(@PathParam(value="port") @NotNullConstraint(paramName="port") @PortWithExistingProxyConstraint @Parameter(required=true, in=ParameterIn.PATH, description="Proxy port, use /proxy endpoint to get available proxy ports.") int port, @QueryParam(value="urlPattern") @NotBlankConstraint(paramName="urlPattern") @PatternConstraint(paramName="urlPattern") @Parameter(required=true, description="Regular expression match of URL to find.\nURLs are formatted as: scheme://host:port/path?querystring.\nPort is not included in the URL if it is the standard port for the scheme.\nFragments (example.com/#fragment) should not be included in the URL.\nIf more than one URL found, use the most recently requested URL.\nPattern examples:\n- Match a URL with \"http\" or \"https\" protocol, \"example.com\" domain, and \"/index.html\" exact file path, with no query parameters:\n  \"^(http|https)://example\\\\.com/index\\\\.html$\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/customer\" exact path, followed by any query string:\n  \"^http://example\\\\.com/customer\\\\?.*\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/products\" path, and exactly 1 UUID query parameter named \"id\":\n  \"^http://example\\\\.com/products\\\\?id=[0-9a-fA-F]{8}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{12}$\"\n") String urlPattern, @QueryParam(value="contentText") @NotBlankConstraint(paramName="contentText") @Parameter(required=true, description="String to search in the content.") String contentText) {
        return this.proxyManager.get(port).assertMostRecentResponseContentDoesNotContain(Pattern.compile(urlPattern), contentText);
    }

    @GET
    @Path(value="/assertContentMatches")
    @Produces(value={"application/json"})
    @Operation(description="Assert that response content for the most recent request found by a given URL pattern matches content pattern.", responses={@ApiResponse(description="Assertion result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AssertionResult.class))})})
    public AssertionResult contentMatches(@PathParam(value="port") @NotNullConstraint(paramName="port") @PortWithExistingProxyConstraint @Parameter(required=true, in=ParameterIn.PATH, description="Proxy port, use /proxy endpoint to get available proxy ports.") int port, @QueryParam(value="urlPattern") @NotBlankConstraint(paramName="urlPattern") @PatternConstraint(paramName="urlPattern") @Parameter(required=true, description="Regular expression match of URL to find.\nURLs are formatted as: scheme://host:port/path?querystring.\nPort is not included in the URL if it is the standard port for the scheme.\nFragments (example.com/#fragment) should not be included in the URL.\nIf more than one URL found, use the most recently requested URL.\nPattern examples:\n- Match a URL with \"http\" or \"https\" protocol, \"example.com\" domain, and \"/index.html\" exact file path, with no query parameters:\n  \"^(http|https)://example\\\\.com/index\\\\.html$\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/customer\" exact path, followed by any query string:\n  \"^http://example\\\\.com/customer\\\\?.*\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/products\" path, and exactly 1 UUID query parameter named \"id\":\n  \"^http://example\\\\.com/products\\\\?id=[0-9a-fA-F]{8}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{12}$\"\n") String urlPattern, @QueryParam(value="contentPattern") @NotBlankConstraint(paramName="contentPattern") @PatternConstraint(paramName="contentPattern") @Parameter(required=true, description="Regular expression match of content to find.") String contentPattern) {
        return this.proxyManager.get(port).assertMostRecentResponseContentMatches(Pattern.compile(urlPattern), Pattern.compile(contentPattern));
    }

    @GET
    @Path(value="/assertContentLengthLessThanOrEqual")
    @Produces(value={"application/json"})
    @Operation(description="Assert that content length of the most recent response found by url pattern does not exceed max value.", responses={@ApiResponse(description="Assertion result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AssertionResult.class))})})
    public AssertionResult contentLengthLessThanOrEqual(@PathParam(value="port") @NotNullConstraint(paramName="port") @PortWithExistingProxyConstraint @Parameter(required=true, in=ParameterIn.PATH, description="Proxy port, use /proxy endpoint to get available proxy ports.") int port, @QueryParam(value="urlPattern") @NotBlankConstraint(paramName="urlPattern") @PatternConstraint(paramName="urlPattern") @Parameter(required=true, description="Regular expression match of URL to find.\nURLs are formatted as: scheme://host:port/path?querystring.\nPort is not included in the URL if it is the standard port for the scheme.\nFragments (example.com/#fragment) should not be included in the URL.\nIf more than one URL found, use the most recently requested URL.\nPattern examples:\n- Match a URL with \"http\" or \"https\" protocol, \"example.com\" domain, and \"/index.html\" exact file path, with no query parameters:\n  \"^(http|https)://example\\\\.com/index\\\\.html$\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/customer\" exact path, followed by any query string:\n  \"^http://example\\\\.com/customer\\\\?.*\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/products\" path, and exactly 1 UUID query parameter named \"id\":\n  \"^http://example\\\\.com/products\\\\?id=[0-9a-fA-F]{8}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{12}$\"\n") String urlPattern, @QueryParam(value="length") @NotNullConstraint(paramName="length") @LongPositiveConstraint(value=0, paramName="length") @Parameter(required=true, description="Max length of content, inclusive.") String length) {
        return this.proxyManager.get(port).assertMostRecentResponseContentLengthLessThanOrEqual(Pattern.compile(urlPattern), Long.valueOf(Long.parseLong(length)));
    }

    @GET
    @Path(value="/assertResponseTimeLessThanOrEqual")
    @Produces(value={"application/json"})
    @Operation(description="Assert that the response time for the most recent request found by a given URL pattern is less than or equal to a given number of milliseconds.", responses={@ApiResponse(description="Assertion result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AssertionResult.class))})})
    public AssertionResult responseTimeLessThanOrEqual(@PathParam(value="port") @NotNullConstraint(paramName="port") @PortWithExistingProxyConstraint @Parameter(required=true, in=ParameterIn.PATH, description="Proxy port, use /proxy endpoint to get available proxy ports.") int port, @QueryParam(value="urlPattern") @NotBlankConstraint(paramName="urlPattern") @PatternConstraint(paramName="urlPattern") @Parameter(required=true, description="Regular expression match of URL to find.\nURLs are formatted as: scheme://host:port/path?querystring.\nPort is not included in the URL if it is the standard port for the scheme.\nFragments (example.com/#fragment) should not be included in the URL.\nIf more than one URL found, use the most recently requested URL.\nPattern examples:\n- Match a URL with \"http\" or \"https\" protocol, \"example.com\" domain, and \"/index.html\" exact file path, with no query parameters:\n  \"^(http|https)://example\\\\.com/index\\\\.html$\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/customer\" exact path, followed by any query string:\n  \"^http://example\\\\.com/customer\\\\?.*\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/products\" path, and exactly 1 UUID query parameter named \"id\":\n  \"^http://example\\\\.com/products\\\\?id=[0-9a-fA-F]{8}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{12}$\"\n") String urlPattern, @QueryParam(value="milliseconds") @LongPositiveConstraint(value=0, paramName="milliseconds") @Parameter(required=true, description="Maximum time in milliseconds, inclusive.") String milliseconds) {
        return this.proxyManager.get(port).assertMostRecentResponseTimeLessThanOrEqual(Pattern.compile(urlPattern), Long.parseLong(milliseconds));
    }

    @GET
    @Path(value="/assertResponseHeaderContains")
    @Produces(value={"application/json"})
    @Operation(description="Assert that if the most recent response found by url pattern has header with specified name - it's value must contain specified text.", responses={@ApiResponse(description="Assertion result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AssertionResult.class))})})
    public AssertionResult responseHeaderContains(@PathParam(value="port") @NotNullConstraint(paramName="port") @PortWithExistingProxyConstraint @Parameter(required=true, in=ParameterIn.PATH, description="Proxy port, use /proxy endpoint to get available proxy ports.") int port, @QueryParam(value="urlPattern") @NotBlankConstraint(paramName="urlPattern") @PatternConstraint(paramName="urlPattern") @Parameter(required=true, description="Regular expression match of URL to find.\nURLs are formatted as: scheme://host:port/path?querystring.\nPort is not included in the URL if it is the standard port for the scheme.\nFragments (example.com/#fragment) should not be included in the URL.\nIf more than one URL found, use the most recently requested URL.\nPattern examples:\n- Match a URL with \"http\" or \"https\" protocol, \"example.com\" domain, and \"/index.html\" exact file path, with no query parameters:\n  \"^(http|https)://example\\\\.com/index\\\\.html$\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/customer\" exact path, followed by any query string:\n  \"^http://example\\\\.com/customer\\\\?.*\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/products\" path, and exactly 1 UUID query parameter named \"id\":\n  \"^http://example\\\\.com/products\\\\?id=[0-9a-fA-F]{8}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{12}$\"\n") String urlPattern, @QueryParam(value="headerName") @Parameter(description="Header name") String headerName, @QueryParam(value="headerValue") @NotBlankConstraint(paramName="headerValue") @Parameter(required=true, description="Header value") String headerValue) {
        return this.proxyManager.get(port).assertMostRecentResponseHeaderContains(Pattern.compile(urlPattern), headerName, headerValue);
    }

    @GET
    @Path(value="/assertResponseHeaderDoesNotContain")
    @Produces(value={"application/json"})
    @Operation(description="Assert that if the most recent response found by url pattern has header with specified name- it's value must not contain specified text.", responses={@ApiResponse(description="Assertion result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AssertionResult.class))})})
    public AssertionResult responseHeaderDoesNotContain(@PathParam(value="port") @NotNullConstraint(paramName="port") @PortWithExistingProxyConstraint @Parameter(required=true, in=ParameterIn.PATH, description="Proxy port, use /proxy endpoint to get available proxy ports.") int port, @QueryParam(value="urlPattern") @NotBlankConstraint(paramName="urlPattern") @PatternConstraint(paramName="urlPattern") @Parameter(required=true, description="Regular expression match of URL to find.\nURLs are formatted as: scheme://host:port/path?querystring.\nPort is not included in the URL if it is the standard port for the scheme.\nFragments (example.com/#fragment) should not be included in the URL.\nIf more than one URL found, use the most recently requested URL.\nPattern examples:\n- Match a URL with \"http\" or \"https\" protocol, \"example.com\" domain, and \"/index.html\" exact file path, with no query parameters:\n  \"^(http|https)://example\\\\.com/index\\\\.html$\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/customer\" exact path, followed by any query string:\n  \"^http://example\\\\.com/customer\\\\?.*\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/products\" path, and exactly 1 UUID query parameter named \"id\":\n  \"^http://example\\\\.com/products\\\\?id=[0-9a-fA-F]{8}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{12}$\"\n") String urlPattern, @QueryParam(value="headerName") @Parameter(description="Header name") String headerName, @QueryParam(value="headerValue") @NotBlankConstraint(paramName="headerValue") @Parameter(required=true, description="Header value") String headerValue) {
        return this.proxyManager.get(port).assertMostRecentResponseHeaderDoesNotContain(Pattern.compile(urlPattern), headerName, headerValue);
    }

    @GET
    @Path(value="/assertResponseHeaderMatches")
    @Produces(value={"application/json"})
    @Operation(description="Assert that if the most recent response found by url pattern has header with name found by name pattern - it's value should match value pattern.", responses={@ApiResponse(description="Assertion result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AssertionResult.class))})})
    public AssertionResult responseHeaderMatches(@PathParam(value="port") @NotNullConstraint(paramName="port") @PortWithExistingProxyConstraint @Parameter(required=true, in=ParameterIn.PATH, description="Proxy port, use /proxy endpoint to get available proxy ports.") int port, @QueryParam(value="urlPattern") @NotBlankConstraint(paramName="urlPattern") @PatternConstraint(paramName="urlPattern") @Parameter(required=true, description="Regular expression match of URL to find.\nURLs are formatted as: scheme://host:port/path?querystring.\nPort is not included in the URL if it is the standard port for the scheme.\nFragments (example.com/#fragment) should not be included in the URL.\nIf more than one URL found, use the most recently requested URL.\nPattern examples:\n- Match a URL with \"http\" or \"https\" protocol, \"example.com\" domain, and \"/index.html\" exact file path, with no query parameters:\n  \"^(http|https)://example\\\\.com/index\\\\.html$\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/customer\" exact path, followed by any query string:\n  \"^http://example\\\\.com/customer\\\\?.*\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/products\" path, and exactly 1 UUID query parameter named \"id\":\n  \"^http://example\\\\.com/products\\\\?id=[0-9a-fA-F]{8}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{12}$\"\n") String urlPattern, @QueryParam(value="headerNamePattern") @PatternConstraint(paramName="headerNamePattern") @Parameter(required=true, description="Regular expression match of header name to find.") String headerNamePattern, @QueryParam(value="headerValuePattern") @NotBlankConstraint(paramName="headerValuePattern") @PatternConstraint(paramName="headerValuePattern") @Parameter(required=true, description="Regular expression match of header value.") String headerValuePattern) {
        return this.proxyManager.get(port).assertMostRecentResponseHeaderMatches(Pattern.compile(urlPattern), headerNamePattern != null ? Pattern.compile(headerNamePattern) : null, Pattern.compile(headerValuePattern));
    }

    @GET
    @Path(value="/assertStatusEquals")
    @Produces(value={"application/json"})
    @Operation(description="In case url patter is provided assert that the most recent response found by url pattern has specified status, otherwise assert that the most recent response has specified status.", responses={@ApiResponse(description="Assertion result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AssertionResult.class))})})
    public AssertionResult statusEquals(@PathParam(value="port") @NotNullConstraint(paramName="port") @PortWithExistingProxyConstraint @Parameter(required=true, in=ParameterIn.PATH, description="Proxy port, use /proxy endpoint to get available proxy ports.") int port, @QueryParam(value="urlPattern") @NotBlankConstraint(paramName="urlPattern") @PatternConstraint(paramName="urlPattern") @Parameter(description="Regular expression match of URL to find.\nURLs are formatted as: scheme://host:port/path?querystring.\nPort is not included in the URL if it is the standard port for the scheme.\nFragments (example.com/#fragment) should not be included in the URL.\nIf more than one URL found, use the most recently requested URL.\nPattern examples:\n- Match a URL with \"http\" or \"https\" protocol, \"example.com\" domain, and \"/index.html\" exact file path, with no query parameters:\n  \"^(http|https)://example\\\\.com/index\\\\.html$\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/customer\" exact path, followed by any query string:\n  \"^http://example\\\\.com/customer\\\\?.*\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/products\" path, and exactly 1 UUID query parameter named \"id\":\n  \"^http://example\\\\.com/products\\\\?id=[0-9a-fA-F]{8}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{12}$\"\n") String urlPattern, @QueryParam(value="status") @NotNullConstraint(paramName="status") @HttpStatusCodeConstraint(paramName="status") @Parameter(required=true, description="Http status.") String status) {
        BrowserUpProxyServer proxyServer = this.proxyManager.get(port);
        int intStatus = Integer.parseInt(status);
        return urlPattern.isEmpty() ? proxyServer.assertMostRecentResponseStatusCode(Integer.valueOf(intStatus)) : proxyServer.assertMostRecentResponseStatusCode(Pattern.compile(urlPattern), Integer.valueOf(intStatus));
    }

    @GET
    @Path(value="/assertStatusInformational")
    @Produces(value={"application/json"})
    @Operation(description="In case url pattern is provided assert that the most recent response found by url pattern has status belonging to INFORMATIONAL class (1xx), otherwise assert that the most recent response has status belonging to INFORMATIONAL class (1xx).", responses={@ApiResponse(description="Assertion result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AssertionResult.class))})})
    public AssertionResult statusInformational(@PathParam(value="port") @NotNullConstraint(paramName="port") @PortWithExistingProxyConstraint @Parameter(required=true, in=ParameterIn.PATH, description="Proxy port, use /proxy endpoint to get available proxy ports.") int port, @QueryParam(value="urlPattern") @NotBlankConstraint(paramName="urlPattern") @PatternConstraint(paramName="urlPattern") @Parameter(description="Regular expression match of URL to find.\nURLs are formatted as: scheme://host:port/path?querystring.\nPort is not included in the URL if it is the standard port for the scheme.\nFragments (example.com/#fragment) should not be included in the URL.\nIf more than one URL found, use the most recently requested URL.\nPattern examples:\n- Match a URL with \"http\" or \"https\" protocol, \"example.com\" domain, and \"/index.html\" exact file path, with no query parameters:\n  \"^(http|https)://example\\\\.com/index\\\\.html$\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/customer\" exact path, followed by any query string:\n  \"^http://example\\\\.com/customer\\\\?.*\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/products\" path, and exactly 1 UUID query parameter named \"id\":\n  \"^http://example\\\\.com/products\\\\?id=[0-9a-fA-F]{8}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{12}$\"\n") String urlPattern) {
        BrowserUpProxyServer proxyServer = this.proxyManager.get(port);
        return urlPattern.isEmpty() ? proxyServer.assertMostRecentResponseStatusCode(HttpStatusClass.INFORMATIONAL) : proxyServer.assertMostRecentResponseStatusCode(Pattern.compile(urlPattern), HttpStatusClass.INFORMATIONAL);
    }

    @GET
    @Path(value="/assertStatusSuccess")
    @Produces(value={"application/json"})
    @Operation(description="In case url pattern is provided assert that the most recent response found by url pattern has status belonging to SUCCESS class (2xx), otherwise assert that the most recent response has status belonging to SUCCESS class (2xx).", responses={@ApiResponse(description="Assertion result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AssertionResult.class))})})
    public AssertionResult statusSuccess(@PathParam(value="port") @NotNullConstraint(paramName="port") @PortWithExistingProxyConstraint @Parameter(required=true, in=ParameterIn.PATH, description="Proxy port, use /proxy endpoint to get available proxy ports.") int port, @QueryParam(value="urlPattern") @NotBlankConstraint(paramName="urlPattern") @PatternConstraint(paramName="urlPattern") @Parameter(description="Regular expression match of URL to find.\nURLs are formatted as: scheme://host:port/path?querystring.\nPort is not included in the URL if it is the standard port for the scheme.\nFragments (example.com/#fragment) should not be included in the URL.\nIf more than one URL found, use the most recently requested URL.\nPattern examples:\n- Match a URL with \"http\" or \"https\" protocol, \"example.com\" domain, and \"/index.html\" exact file path, with no query parameters:\n  \"^(http|https)://example\\\\.com/index\\\\.html$\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/customer\" exact path, followed by any query string:\n  \"^http://example\\\\.com/customer\\\\?.*\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/products\" path, and exactly 1 UUID query parameter named \"id\":\n  \"^http://example\\\\.com/products\\\\?id=[0-9a-fA-F]{8}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{12}$\"\n") String urlPattern) {
        BrowserUpProxyServer proxyServer = this.proxyManager.get(port);
        return urlPattern.isEmpty() ? proxyServer.assertMostRecentResponseStatusCode(HttpStatusClass.SUCCESS) : proxyServer.assertMostRecentResponseStatusCode(Pattern.compile(urlPattern), HttpStatusClass.SUCCESS);
    }

    @GET
    @Path(value="/assertStatusRedirection")
    @Produces(value={"application/json"})
    @Operation(description="In case url pattern is provided assert that the most recent response found by url pattern has status belonging to REDIRECTION class (3xx), otherwise assert that the most recent response has status belonging to REDIRECTION class (3xx).", responses={@ApiResponse(description="Assertion result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AssertionResult.class))})})
    public AssertionResult statusRedirection(@PathParam(value="port") @NotNullConstraint(paramName="port") @PortWithExistingProxyConstraint @Parameter(required=true, in=ParameterIn.PATH, description="Proxy port, use /proxy endpoint to get available proxy ports.") int port, @QueryParam(value="urlPattern") @NotBlankConstraint(paramName="urlPattern") @PatternConstraint(paramName="urlPattern") @Parameter(description="Regular expression match of URL to find.\nURLs are formatted as: scheme://host:port/path?querystring.\nPort is not included in the URL if it is the standard port for the scheme.\nFragments (example.com/#fragment) should not be included in the URL.\nIf more than one URL found, use the most recently requested URL.\nPattern examples:\n- Match a URL with \"http\" or \"https\" protocol, \"example.com\" domain, and \"/index.html\" exact file path, with no query parameters:\n  \"^(http|https)://example\\\\.com/index\\\\.html$\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/customer\" exact path, followed by any query string:\n  \"^http://example\\\\.com/customer\\\\?.*\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/products\" path, and exactly 1 UUID query parameter named \"id\":\n  \"^http://example\\\\.com/products\\\\?id=[0-9a-fA-F]{8}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{12}$\"\n") String urlPattern) {
        BrowserUpProxyServer proxyServer = this.proxyManager.get(port);
        return urlPattern.isEmpty() ? proxyServer.assertMostRecentResponseStatusCode(HttpStatusClass.REDIRECTION) : proxyServer.assertMostRecentResponseStatusCode(Pattern.compile(urlPattern), HttpStatusClass.REDIRECTION);
    }

    @GET
    @Path(value="/assertStatusClientError")
    @Produces(value={"application/json"})
    @Operation(description="In case url pattern is provided assert that the most recent response found by url pattern has status belonging to CLIENT ERROR class (4xx), otherwise assert that the most recent response has status belonging to CLIENT ERROR class (4xx).", responses={@ApiResponse(description="Assertion result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AssertionResult.class))})})
    public AssertionResult statusClientError(@PathParam(value="port") @NotNullConstraint(paramName="port") @PortWithExistingProxyConstraint @Parameter(required=true, in=ParameterIn.PATH, description="Proxy port, use /proxy endpoint to get available proxy ports.") int port, @QueryParam(value="urlPattern") @NotBlankConstraint(paramName="urlPattern") @PatternConstraint(paramName="urlPattern") @Parameter(description="Regular expression match of URL to find.\nURLs are formatted as: scheme://host:port/path?querystring.\nPort is not included in the URL if it is the standard port for the scheme.\nFragments (example.com/#fragment) should not be included in the URL.\nIf more than one URL found, use the most recently requested URL.\nPattern examples:\n- Match a URL with \"http\" or \"https\" protocol, \"example.com\" domain, and \"/index.html\" exact file path, with no query parameters:\n  \"^(http|https)://example\\\\.com/index\\\\.html$\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/customer\" exact path, followed by any query string:\n  \"^http://example\\\\.com/customer\\\\?.*\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/products\" path, and exactly 1 UUID query parameter named \"id\":\n  \"^http://example\\\\.com/products\\\\?id=[0-9a-fA-F]{8}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{12}$\"\n") String urlPattern) {
        BrowserUpProxyServer proxyServer = this.proxyManager.get(port);
        return urlPattern.isEmpty() ? proxyServer.assertMostRecentResponseStatusCode(HttpStatusClass.CLIENT_ERROR) : proxyServer.assertMostRecentResponseStatusCode(Pattern.compile(urlPattern), HttpStatusClass.CLIENT_ERROR);
    }

    @GET
    @Path(value="/assertStatusServerError")
    @Produces(value={"application/json"})
    @Operation(description="In case url pattern is provided assert that the most recent response found by url pattern has status belonging to SERVER ERROR class (5xx), otherwise assert that the most recent response has status belonging to SERVER ERROR class (5xx).", responses={@ApiResponse(description="Assertion result", content={@Content(mediaType="application/json", schema=@Schema(implementation=AssertionResult.class))})})
    public AssertionResult statusServerError(@PathParam(value="port") @NotNullConstraint(paramName="port") @PortWithExistingProxyConstraint @Parameter(required=true, in=ParameterIn.PATH, description="Proxy port, use /proxy endpoint to get available proxy ports.") int port, @QueryParam(value="urlPattern") @NotBlankConstraint(paramName="urlPattern") @PatternConstraint(paramName="urlPattern") @Parameter(description="Regular expression match of URL to find.\nURLs are formatted as: scheme://host:port/path?querystring.\nPort is not included in the URL if it is the standard port for the scheme.\nFragments (example.com/#fragment) should not be included in the URL.\nIf more than one URL found, use the most recently requested URL.\nPattern examples:\n- Match a URL with \"http\" or \"https\" protocol, \"example.com\" domain, and \"/index.html\" exact file path, with no query parameters:\n  \"^(http|https)://example\\\\.com/index\\\\.html$\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/customer\" exact path, followed by any query string:\n  \"^http://example\\\\.com/customer\\\\?.*\"\n- Match a URL with \"http\" protocol, \"example.com\" domain, \"/products\" path, and exactly 1 UUID query parameter named \"id\":\n  \"^http://example\\\\.com/products\\\\?id=[0-9a-fA-F]{8}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{4}\\\\-[0-9a-fA-F]{12}$\"\n") String urlPattern) {
        BrowserUpProxyServer proxyServer = this.proxyManager.get(port);
        return urlPattern.isEmpty() ? proxyServer.assertMostRecentResponseStatusCode(HttpStatusClass.SERVER_ERROR) : proxyServer.assertMostRecentResponseStatusCode(Pattern.compile(urlPattern), HttpStatusClass.SERVER_ERROR);
    }
}

