/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.proxy.guice;

import com.browserup.bup.proxy.ProxyManager;
import com.browserup.bup.rest.filter.LoggingFilter;
import com.browserup.bup.rest.validation.mapper.ConstraintViolationExceptionMapper;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.google.inject.servlet.GuiceFilter;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class JettyServerProvider
implements Provider<Server> {
    public static final String SWAGGER_CONFIG_NAME = "swagger-config.yaml";
    public static final String SWAGGER_PACKAGE = "com.browserup.bup.rest.resource";
    private Server server;

    @Inject
    public JettyServerProvider(@Named(value="port") int port, @Named(value="address") String address, ProxyManager proxyManager) throws UnknownHostException {
        OpenApiResource openApiResource = new OpenApiResource();
        openApiResource.setConfigLocation(SWAGGER_CONFIG_NAME);
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.packages(new String[]{SWAGGER_PACKAGE});
        resourceConfig.register((Object)openApiResource);
        resourceConfig.register((Object)this.proxyManagerToHkBinder(proxyManager));
        resourceConfig.register(JacksonFeature.class);
        resourceConfig.register(ConstraintViolationExceptionMapper.class);
        resourceConfig.registerClasses(new Class[]{LoggingFilter.class});
        resourceConfig.property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", (Object)true);
        resourceConfig.property("jersey.config.server.wadl.disableWadl", (Object)true);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.addFilter(GuiceFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        context.addServlet(DefaultServlet.class, "/");
        context.addServlet(new ServletHolder((Servlet)new ServletContainer(resourceConfig)), "/*");
        this.server = new Server(new InetSocketAddress(InetAddress.getByName(address), port));
        this.server.setHandler((Handler)context);
    }

    private AbstractBinder proxyManagerToHkBinder(final ProxyManager proxyManager) {
        Factory<ProxyManager> proxyManagerFactory = new Factory<ProxyManager>(){

            public ProxyManager provide() {
                return proxyManager;
            }

            public void dispose(ProxyManager instance) {
            }
        };
        return new AbstractBinder((Factory)proxyManagerFactory){
            final /* synthetic */ Factory val$proxyManagerFactory;
            {
                this.val$proxyManagerFactory = factory;
            }

            protected void configure() {
                this.bindFactory(this.val$proxyManagerFactory).to(ProxyManager.class);
            }
        };
    }

    public Server get() {
        return this.server;
    }
}

