/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.proxy.bricks;

import com.browserup.bup.BrowserUpProxyServer;
import com.browserup.bup.exception.ProxyExistsException;
import com.browserup.bup.exception.ProxyPortsExhaustedException;
import com.browserup.bup.filters.JavascriptRequestResponseFilter;
import com.browserup.bup.filters.RequestFilter;
import com.browserup.bup.filters.ResponseFilter;
import com.browserup.bup.proxy.CaptureType;
import com.browserup.bup.proxy.ProxyManager;
import com.browserup.bup.proxy.auth.AuthType;
import com.browserup.bup.util.BrowserUpHttpUtil;
import com.browserup.harreader.model.Har;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.sitebricks.At;
import com.google.sitebricks.client.transport.Json;
import com.google.sitebricks.client.transport.Text;
import com.google.sitebricks.headless.Reply;
import com.google.sitebricks.headless.Request;
import com.google.sitebricks.headless.Service;
import com.google.sitebricks.http.Delete;
import com.google.sitebricks.http.Get;
import com.google.sitebricks.http.Post;
import com.google.sitebricks.http.Put;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@At(value="/proxy")
@Service
public class ProxyResource {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyResource.class);
    private final ProxyManager proxyManager;

    @Inject
    public ProxyResource(ProxyManager proxyManager) {
        this.proxyManager = proxyManager;
    }

    @Get
    public Reply<?> getProxies() {
        LOG.info("GET /");
        Collection proxyList = this.proxyManager.get().stream().map(proxy -> new ProxyDescriptor(proxy.getPort())).collect(Collectors.toList());
        return Reply.with((Object)new ProxyListDescriptor(proxyList)).as(Json.class);
    }

    @Post
    public Reply<?> newProxy(Request request) {
        BrowserUpProxyServer proxy;
        LOG.info("POST /");
        LOG.info(request.params().toString());
        String systemProxyHost = System.getProperty("http.proxyHost");
        String systemProxyPort = System.getProperty("http.proxyPort");
        String systemNonProxyHosts = System.getProperty("http.nonProxyHosts");
        String httpProxy = request.param("httpProxy");
        String httpNonProxyHosts = request.param("httpNonProxyHosts");
        String proxyUsername = request.param("proxyUsername");
        String proxyPassword = request.param("proxyPassword");
        boolean upstreamProxyHttps = "true".equals(request.param("proxyHTTPS"));
        Hashtable options = new Hashtable();
        String upstreamHttpProxy = null;
        if (httpProxy != null) {
            upstreamHttpProxy = httpProxy;
        } else if (systemProxyHost != null && systemProxyPort != null) {
            upstreamHttpProxy = String.format("%s:%s", systemProxyHost, systemProxyPort);
        }
        List<String> upstreamNonProxyHosts = null;
        if (upstreamHttpProxy != null) {
            if (httpNonProxyHosts != null) {
                upstreamNonProxyHosts = Arrays.asList(httpNonProxyHosts.split("\\|"));
            } else if (systemNonProxyHosts != null) {
                upstreamNonProxyHosts = Arrays.asList(systemNonProxyHosts.split("\\|"));
            }
        }
        String paramBindAddr = request.param("bindAddress");
        String paramServerBindAddr = request.param("serverBindAddress");
        Integer paramPort = request.param("port") == null ? null : Integer.valueOf(Integer.parseInt(request.param("port")));
        String useEccString = request.param("useEcc");
        boolean useEcc = Boolean.parseBoolean(useEccString);
        String trustAllServersString = request.param("trustAllServers");
        boolean trustAllServers = Boolean.parseBoolean(trustAllServersString);
        LOG.debug("POST proxy instance on bindAddress `{}` & port `{}` & serverBindAddress `{}`", new Object[]{paramBindAddr, paramPort, paramServerBindAddr});
        try {
            proxy = this.proxyManager.create(upstreamHttpProxy, upstreamProxyHttps, upstreamNonProxyHosts, proxyUsername, proxyPassword, paramPort, paramBindAddr, paramServerBindAddr, useEcc, trustAllServers);
        }
        catch (ProxyExistsException ex) {
            return Reply.with((Object)new ProxyDescriptor(ex.getPort())).status(455).as(Json.class);
        }
        catch (ProxyPortsExhaustedException ex) {
            return Reply.saying().status(456);
        }
        catch (Exception ex) {
            StringWriter s = new StringWriter();
            ex.printStackTrace(new PrintWriter(s));
            return Reply.with((Object)s).as(Text.class).status(550);
        }
        return Reply.with((Object)new ProxyDescriptor(proxy.getPort())).as(Json.class);
    }

    @Get
    @At(value="/:port/har")
    public Reply<?> getHar(@Named(value="port") int port, Request request) {
        LOG.info("GET /" + port + "/har");
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        Boolean cleanHar = "true".equals(request.param("cleanHar"));
        Har har = proxy.getHar(cleanHar.booleanValue());
        return Reply.with((Object)har).as(Json.class);
    }

    @Put
    @At(value="/:port/har")
    public Reply<?> newHar(@Named(value="port") int port, Request request) {
        LOG.info("PUT /" + port + "/har");
        LOG.info(request.params().toString());
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String initialPageRef = request.param("initialPageRef");
        String initialPageTitle = request.param("initialPageTitle");
        Har oldHar = proxy.newHar(initialPageRef, initialPageTitle);
        String captureHeaders = request.param("captureHeaders");
        String captureContent = request.param("captureContent");
        String captureBinaryContent = request.param("captureBinaryContent");
        HashSet captureTypes = new HashSet();
        if (Boolean.parseBoolean(captureHeaders)) {
            captureTypes.addAll(CaptureType.getHeaderCaptureTypes());
        }
        if (Boolean.parseBoolean(captureContent)) {
            captureTypes.addAll(CaptureType.getAllContentCaptureTypes());
        }
        if (Boolean.parseBoolean(captureBinaryContent)) {
            captureTypes.addAll(CaptureType.getBinaryContentCaptureTypes());
        }
        proxy.setHarCaptureTypes(captureTypes);
        String captureCookies = request.param("captureCookies");
        if (proxy instanceof BrowserUpProxyServer && Boolean.parseBoolean(captureCookies)) {
            BrowserUpProxyServer BrowserUpProxyServer2 = proxy;
            BrowserUpProxyServer2.enableHarCaptureTypes((Set)CaptureType.getCookieCaptureTypes());
        }
        if (oldHar != null) {
            return Reply.with((Object)oldHar).as(Json.class);
        }
        return Reply.saying().noContent();
    }

    @Put
    @At(value="/:port/har/pageRef")
    public Reply<?> setPage(@Named(value="port") int port, Request request) {
        LOG.info("PUT /" + port + "/har/pageRef");
        LOG.info(request.params().toString());
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String pageRef = request.param("pageRef");
        String pageTitle = request.param("pageTitle");
        proxy.newPage(pageRef, pageTitle);
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/har/commands/endPage")
    public Reply<?> endPage(@Named(value="port") int port, Request request) {
        LOG.info("POST /" + port + "/commands/endPage");
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        proxy.endPage();
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/har/commands/endHar")
    public Reply<?> endHar(@Named(value="port") int port, Request request) {
        LOG.info("POST /" + port + "/commands/endHar");
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        proxy.endHar();
        return Reply.saying().ok();
    }

    @Get
    @At(value="/:port/blacklist")
    public Reply<?> getBlacklist(@Named(value="port") int port, Request request) {
        LOG.info("GET /" + port + "/blacklist");
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        return Reply.with((Object)proxy.getBlacklist()).as(Json.class);
    }

    @Put
    @At(value="/:port/blacklist")
    public Reply<?> blacklist(@Named(value="port") int port, Request request) {
        LOG.info("PUT /" + port + "/blacklist");
        LOG.info(request.params().toString());
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String blacklist = request.param("regex");
        int responseCode = this.parseResponseCode(request.param("status"));
        String method = request.param("method");
        proxy.blacklistRequests(blacklist, responseCode, method);
        return Reply.saying().ok();
    }

    @Delete
    @At(value="/:port/blacklist")
    public Reply<?> clearBlacklist(@Named(value="port") int port, Request request) {
        LOG.info("DELETE /" + port + "/blacklist");
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        proxy.clearBlacklist();
        return Reply.saying().ok();
    }

    @Get
    @At(value="/:port/whitelist")
    public Reply<?> getWhitelist(@Named(value="port") int port, Request request) {
        LOG.info("GET /" + port + "/whitelist");
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        return Reply.with((Object)proxy.getWhitelistUrls()).as(Json.class);
    }

    @Put
    @At(value="/:port/whitelist")
    public Reply<?> whitelist(@Named(value="port") int port, Request request) {
        LOG.info("PUT /" + port + "/whitelist");
        LOG.info(request.params().toString());
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String regex = request.param("regex");
        int responseCode = this.parseResponseCode(request.param("status"));
        proxy.whitelistRequests(regex.split(","), responseCode);
        return Reply.saying().ok();
    }

    @Delete
    @At(value="/:port/whitelist")
    public Reply<?> clearWhitelist(@Named(value="port") int port, Request request) {
        LOG.info("DELETE /" + port + "/whitelist");
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        proxy.disableWhitelist();
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/auth/basic/:domain")
    public Reply<?> autoBasicAuth(@Named(value="port") int port, @Named(value="domain") String domain, Request request) {
        LOG.info("POST /" + port + "/auth/basic/" + domain);
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        Map credentials = (Map)request.read(HashMap.class).as(Json.class);
        proxy.autoAuthorization(domain, (String)credentials.get("username"), (String)credentials.get("password"), AuthType.BASIC);
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/headers")
    public Reply<?> updateHeaders(@Named(value="port") int port, Request request) {
        LOG.info("POST /" + port + "/headers");
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        Map headers = (Map)request.read(Map.class).as(Json.class);
        headers.forEach((arg_0, arg_1) -> ((BrowserUpProxyServer)proxy).addHeader(arg_0, arg_1));
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/filter/request")
    public Reply<?> addRequestFilter(@Named(value="port") int port, Request request) throws IOException, ScriptException {
        LOG.info("POST /" + port + "/filter/request");
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        JavascriptRequestResponseFilter requestResponseFilter = new JavascriptRequestResponseFilter();
        String script = this.getEntityBodyFromRequest(request);
        requestResponseFilter.setRequestFilterScript(script);
        proxy.addRequestFilter((RequestFilter)requestResponseFilter);
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/filter/response")
    public Reply<?> addResponseFilter(@Named(value="port") int port, Request request) throws IOException, ScriptException {
        LOG.info("POST /" + port + "/filter/response");
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        JavascriptRequestResponseFilter requestResponseFilter = new JavascriptRequestResponseFilter();
        String script = this.getEntityBodyFromRequest(request);
        requestResponseFilter.setResponseFilterScript(script);
        proxy.addResponseFilter((ResponseFilter)requestResponseFilter);
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/limit")
    public Reply<?> limit(@Named(value="port") int port, Request request) {
        String latency;
        String downstreamBps;
        String downstreamKbps;
        String upstreamBps;
        LOG.info("PUT /" + port + "/limit");
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String upstreamKbps = request.param("upstreamKbps");
        if (upstreamKbps != null) {
            try {
                long upstreamBytesPerSecond = Integer.parseInt(upstreamKbps) * 1024;
                proxy.setWriteBandwidthLimit(upstreamBytesPerSecond);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid upstreamKbps value");
                return Reply.saying().badRequest();
            }
        }
        if ((upstreamBps = request.param("upstreamBps")) != null) {
            try {
                proxy.setWriteBandwidthLimit((long)Integer.parseInt(upstreamBps));
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid upstreamBps value");
                return Reply.saying().badRequest();
            }
        }
        if ((downstreamKbps = request.param("downstreamKbps")) != null) {
            try {
                long downstreamBytesPerSecond = Integer.parseInt(downstreamKbps) * 1024;
                proxy.setReadBandwidthLimit(downstreamBytesPerSecond);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid downstreamKbps value");
                return Reply.saying().badRequest();
            }
        }
        if ((downstreamBps = request.param("downstreamBps")) != null) {
            try {
                proxy.setReadBandwidthLimit((long)Integer.parseInt(downstreamBps));
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid downstreamBps value");
                return Reply.saying().badRequest();
            }
        }
        if ((latency = request.param("latency")) != null) {
            try {
                proxy.setLatency(Long.parseLong(latency), TimeUnit.MILLISECONDS);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid latency value");
                return Reply.saying().badRequest();
            }
        }
        if (request.param("upstreamMaxKB") != null) {
            LOG.warn("upstreamMaxKB no longer supported");
            return Reply.saying().badRequest();
        }
        if (request.param("downstreamMaxKB") != null) {
            LOG.warn("downstreamMaxKB no longer supported");
            return Reply.saying().badRequest();
        }
        if (request.param("payloadPercentage") != null) {
            LOG.warn("payloadPercentage no longer supported");
            return Reply.saying().badRequest();
        }
        if (request.param("maxBitsPerSecond") != null) {
            LOG.warn("maxBitsPerSecond no longer supported");
            return Reply.saying().badRequest();
        }
        if (request.param("enable") != null) {
            LOG.warn("enable no longer supported. Limits, if set, will always be enabled.");
            return Reply.saying().badRequest();
        }
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/timeout")
    public Reply<?> timeout(@Named(value="port") int port, Request request) {
        String dnsCacheTimeout;
        String connectionTimeout;
        String readTimeout;
        LOG.info("PUT /" + port + "/timeout");
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String requestTimeout = request.param("requestTimeout");
        if (requestTimeout != null) {
            try {
                proxy.setRequestTimeout(Integer.parseInt(requestTimeout), TimeUnit.MILLISECONDS);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid requestTimeout value");
                return Reply.saying().badRequest();
            }
        }
        if ((readTimeout = request.param("readTimeout")) != null) {
            try {
                proxy.setIdleConnectionTimeout(Integer.parseInt(readTimeout), TimeUnit.MILLISECONDS);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid readTimeout value");
                return Reply.saying().badRequest();
            }
        }
        if ((connectionTimeout = request.param("connectionTimeout")) != null) {
            try {
                proxy.setConnectTimeout(Integer.parseInt(connectionTimeout), TimeUnit.MILLISECONDS);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid connectionTimeout value");
                return Reply.saying().badRequest();
            }
        }
        if ((dnsCacheTimeout = request.param("dnsCacheTimeout")) != null) {
            try {
                proxy.getHostNameResolver().setPositiveDNSCacheTimeout(Integer.parseInt(dnsCacheTimeout), TimeUnit.SECONDS);
                proxy.getHostNameResolver().setNegativeDNSCacheTimeout(Integer.parseInt(dnsCacheTimeout), TimeUnit.SECONDS);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid dnsCacheTimeout value");
                return Reply.saying().badRequest();
            }
        }
        return Reply.saying().ok();
    }

    @Delete
    @At(value="/:port")
    public Reply<?> delete(@Named(value="port") int port) {
        LOG.info("DELETE /" + port);
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        this.proxyManager.delete(port);
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/hosts")
    public Reply<?> remapHosts(@Named(value="port") int port, Request request) {
        LOG.info("POST /" + port + "/hosts");
        LOG.info(request.params().toString());
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        Map headers = (Map)request.read(Map.class).as(Json.class);
        headers.forEach((key, value) -> {
            proxy.getHostNameResolver().remapHost(key, value);
            proxy.getHostNameResolver().setNegativeDNSCacheTimeout(0, TimeUnit.SECONDS);
            proxy.getHostNameResolver().setPositiveDNSCacheTimeout(0, TimeUnit.SECONDS);
            proxy.getHostNameResolver().clearDNSCache();
        });
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/wait")
    public Reply<?> wait(@Named(value="port") int port, Request request) {
        LOG.info("PUT /" + port + "/wait");
        LOG.info(request.params().toString());
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String quietPeriodInMs = request.param("quietPeriodInMs");
        String timeoutInMs = request.param("timeoutInMs");
        proxy.waitForQuiescence(Long.parseLong(quietPeriodInMs), Long.parseLong(timeoutInMs), TimeUnit.MILLISECONDS);
        return Reply.saying().ok();
    }

    @Delete
    @At(value="/:port/dns/cache")
    public Reply<?> clearDnsCache(@Named(value="port") int port) {
        LOG.info("DELETE /" + port + "/dns/cache");
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        proxy.getHostNameResolver().clearDNSCache();
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/rewrite")
    public Reply<?> rewriteUrl(@Named(value="port") int port, Request request) {
        LOG.info("PUT /" + port + "/rewrite");
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        String match = request.param("matchRegex");
        String replace = request.param("replace");
        proxy.rewriteUrl(match, replace);
        return Reply.saying().ok();
    }

    @Delete
    @At(value="/:port/rewrite")
    public Reply<?> clearRewriteRules(@Named(value="port") int port, Request request) {
        LOG.info("DELETE /" + port + "/rewrite");
        BrowserUpProxyServer proxy = this.proxyManager.get(port);
        if (proxy == null) {
            return Reply.saying().notFound();
        }
        proxy.clearRewriteRules();
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/retry")
    public Reply<?> retryCount(@Named(value="port") int port, Request request) {
        LOG.warn("/port/retry API is no longer supported");
        return Reply.saying().badRequest();
    }

    private int parseResponseCode(String response) {
        int responseCode = 200;
        if (response != null) {
            try {
                responseCode = Integer.parseInt(response);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return responseCode;
    }

    private String getEntityBodyFromRequest(Request request) throws IOException {
        String contentTypeHeader = request.header("Content-Type");
        Charset charset = null;
        try {
            charset = BrowserUpHttpUtil.readCharsetInContentTypeHeader((String)contentTypeHeader);
        }
        catch (com.browserup.bup.exception.UnsupportedCharsetException e) {
            UnsupportedCharsetException cause = e.getUnsupportedCharsetExceptionCause();
            LOG.error("Character set declared in Content-Type header is not supported. Content-Type header: {}", (Object)contentTypeHeader, (Object)cause);
            throw cause;
        }
        if (charset == null) {
            charset = BrowserUpHttpUtil.DEFAULT_HTTP_CHARSET;
        }
        ByteArrayOutputStream entityBodyBytes = new ByteArrayOutputStream();
        request.readTo((OutputStream)entityBodyBytes);
        return new String(entityBodyBytes.toByteArray(), charset);
    }

    private Optional<Long> getAssertionTimeFromRequest(Request request) {
        Long time;
        String timeParam = request.param("milliseconds");
        if (StringUtils.isEmpty((CharSequence)timeParam)) {
            LOG.warn("Time parameter not present");
            return Optional.empty();
        }
        try {
            time = Long.valueOf(timeParam);
        }
        catch (Exception ex) {
            LOG.warn("Time parameter not valid", (Throwable)ex);
            return Optional.empty();
        }
        return Optional.of(time);
    }

    public static class ProxyListDescriptor {
        private Collection<ProxyDescriptor> proxyList;

        public ProxyListDescriptor() {
        }

        public ProxyListDescriptor(Collection<ProxyDescriptor> proxyList) {
            this.proxyList = proxyList;
        }

        public Collection<ProxyDescriptor> getProxyList() {
            return this.proxyList;
        }

        public void setProxyList(Collection<ProxyDescriptor> proxyList) {
            this.proxyList = proxyList;
        }
    }

    public static class ProxyDescriptor {
        private int port;

        public ProxyDescriptor() {
        }

        public ProxyDescriptor(int port) {
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }
}

