/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.filters;

import com.browserup.bup.exception.JavascriptCompilationException;
import com.browserup.bup.filters.RequestFilter;
import com.browserup.bup.filters.ResponseFilter;
import com.browserup.bup.util.HttpMessageContents;
import com.browserup.bup.util.HttpMessageInfo;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavascriptRequestResponseFilter
implements RequestFilter,
ResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(JavascriptRequestResponseFilter.class);
    private static final ScriptEngine JAVASCRIPT_ENGINE = new ScriptEngineManager().getEngineByName("JavaScript");
    private CompiledScript compiledRequestFilterScript;
    private CompiledScript compiledResponseFilterScript;

    public void setRequestFilterScript(String script) {
        Compilable compilable = (Compilable)((Object)JAVASCRIPT_ENGINE);
        try {
            this.compiledRequestFilterScript = compilable.compile(script);
        }
        catch (ScriptException e) {
            throw new JavascriptCompilationException("Unable to compile javascript. Script in error:\n" + script, e);
        }
    }

    public void setResponseFilterScript(String script) {
        Compilable compilable = (Compilable)((Object)JAVASCRIPT_ENGINE);
        try {
            this.compiledResponseFilterScript = compilable.compile(script);
        }
        catch (ScriptException e) {
            throw new JavascriptCompilationException("Unable to compile javascript. Script in error:\n" + script, e);
        }
    }

    public HttpResponse filterRequest(HttpRequest request, HttpMessageContents contents, HttpMessageInfo messageInfo) {
        if (this.compiledRequestFilterScript == null) {
            return null;
        }
        Bindings bindings = JAVASCRIPT_ENGINE.createBindings();
        bindings.put("request", (Object)request);
        bindings.put("contents", (Object)contents);
        bindings.put("messageInfo", (Object)messageInfo);
        bindings.put("log", (Object)log);
        try {
            Object retVal = this.compiledRequestFilterScript.eval(bindings);
            if (retVal instanceof HttpResponse) {
                return (HttpResponse)retVal;
            }
            return null;
        }
        catch (ScriptException e) {
            log.error("Could not invoke filterRequest using supplied javascript", (Throwable)e);
            return null;
        }
    }

    public void filterResponse(HttpResponse response, HttpMessageContents contents, HttpMessageInfo messageInfo) {
        if (this.compiledResponseFilterScript == null) {
            return;
        }
        Bindings bindings = JAVASCRIPT_ENGINE.createBindings();
        bindings.put("response", (Object)response);
        bindings.put("contents", (Object)contents);
        bindings.put("messageInfo", (Object)messageInfo);
        bindings.put("log", (Object)log);
        try {
            this.compiledResponseFilterScript.eval(bindings);
        }
        catch (ScriptException e) {
            log.error("Could not invoke filterResponse using supplied javascript", (Throwable)e);
        }
    }
}

