/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.PaymentMethod;
import com.braintreegateway.SepaDirectDebitAccountDetails;
import com.braintreegateway.Subscription;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class SepaDirectDebitAccount
implements PaymentMethod {
    private Calendar createdAt;
    private Calendar updatedAt;
    private List<Subscription> subscriptions;
    private SepaDirectDebitAccountDetails.MandateType mandateType;
    private String bankReferenceToken;
    private String customerGlobalId;
    private String customerId;
    private String globalId;
    private String imageUrl;
    private String last4;
    private String merchantAccountId;
    private String merchantOrPartnerCustomerId;
    private String token;
    private String viewMandateUrl;
    private boolean isDefault;

    public SepaDirectDebitAccount(NodeWrapper node) {
        this.bankReferenceToken = node.findString("bank-reference-token");
        this.createdAt = node.findDateTime("created-at");
        this.customerGlobalId = node.findString("customer-global-id");
        this.customerId = node.findString("customer-id");
        this.merchantOrPartnerCustomerId = node.findString("merchant-or-partner-customer-id");
        this.globalId = node.findString("global-id");
        this.last4 = node.findString("last-4");
        this.imageUrl = node.findString("image-url");
        this.isDefault = node.findBoolean("default");
        this.mandateType = EnumUtils.findByName(SepaDirectDebitAccountDetails.MandateType.class, node.findString("mandate-type"), SepaDirectDebitAccountDetails.MandateType.ONE_OFF);
        this.merchantAccountId = node.findString("merchant-account-id");
        this.subscriptions = new ArrayList<Subscription>();
        for (NodeWrapper subscriptionResponse : node.findAll("subscriptions/subscription")) {
            this.subscriptions.add(new Subscription(subscriptionResponse));
        }
        this.token = node.findString("token");
        this.updatedAt = node.findDateTime("updated-at");
        this.viewMandateUrl = node.findString("view-mandate-url");
    }

    public SepaDirectDebitAccountDetails.MandateType getMandateType() {
        return this.mandateType;
    }

    public String getBankReferenceToken() {
        return this.bankReferenceToken;
    }

    public String getMerchantOrPartnerCustomerId() {
        return this.merchantOrPartnerCustomerId;
    }

    @Override
    public String getCustomerId() {
        return this.customerId;
    }

    public String getCustomerGlobalId() {
        return this.customerGlobalId;
    }

    public String getGlobalId() {
        return this.globalId;
    }

    public String getLast4() {
        return this.last4;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getViewMandateUrl() {
        return this.viewMandateUrl;
    }

    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }
}

