/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Address;
import com.braintreegateway.AmexExpressCheckoutCard;
import com.braintreegateway.AndroidPayCard;
import com.braintreegateway.ApplePayCard;
import com.braintreegateway.CreditCard;
import com.braintreegateway.CustomActionsPaymentMethod;
import com.braintreegateway.MasterpassCard;
import com.braintreegateway.PayPalAccount;
import com.braintreegateway.PaymentMethod;
import com.braintreegateway.SamsungPayCard;
import com.braintreegateway.SepaDirectDebitAccount;
import com.braintreegateway.UsBankAccount;
import com.braintreegateway.VenmoAccount;
import com.braintreegateway.VisaCheckoutCard;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Customer {
    private Calendar createdAt;
    private Calendar updatedAt;
    private String company;
    private String email;
    private String fax;
    private String firstName;
    private String graphqlId;
    private String id;
    private String lastName;
    private String phone;
    private String website;
    private List<Address> addresses;
    private List<AmexExpressCheckoutCard> amexExpressCheckoutCards;
    private List<AndroidPayCard> androidPayCards;
    private List<ApplePayCard> applePayCards;
    private List<CreditCard> creditCards;
    private List<CustomActionsPaymentMethod> customActionsPaymentMethods;
    private List<MasterpassCard> masterpassCards;
    private List<PayPalAccount> paypalAccounts;
    private List<SamsungPayCard> samsungPayCards;
    private List<SepaDirectDebitAccount> sepaDirectDebitAccounts;
    private List<UsBankAccount> usBankAccounts;
    private List<VenmoAccount> venmoAccounts;
    private List<VisaCheckoutCard> visaCheckoutCards;
    private Map<String, String> customFields;

    public Customer(NodeWrapper node) {
        this.company = node.findString("company");
        this.createdAt = node.findDateTime("created-at");
        this.customFields = node.findMap("custom-fields/*");
        this.email = node.findString("email");
        this.fax = node.findString("fax");
        this.firstName = node.findString("first-name");
        this.graphqlId = node.findString("global-id");
        this.id = node.findString("id");
        this.lastName = node.findString("last-name");
        this.phone = node.findString("phone");
        this.updatedAt = node.findDateTime("updated-at");
        this.website = node.findString("website");
        this.creditCards = new ArrayList<CreditCard>();
        for (NodeWrapper creditCardResponse : node.findAll("credit-cards/credit-card")) {
            this.creditCards.add(new CreditCard(creditCardResponse));
        }
        this.paypalAccounts = new ArrayList<PayPalAccount>();
        for (NodeWrapper paypalResponse : node.findAll("paypal-accounts/paypal-account")) {
            this.paypalAccounts.add(new PayPalAccount(paypalResponse));
        }
        this.applePayCards = new ArrayList<ApplePayCard>();
        for (NodeWrapper applePayCardResponse : node.findAll("apple-pay-cards/apple-pay-card")) {
            this.applePayCards.add(new ApplePayCard(applePayCardResponse));
        }
        this.androidPayCards = new ArrayList<AndroidPayCard>();
        for (NodeWrapper androidPayCardResponse : node.findAll("android-pay-cards/android-pay-card")) {
            this.androidPayCards.add(new AndroidPayCard(androidPayCardResponse));
        }
        this.amexExpressCheckoutCards = new ArrayList<AmexExpressCheckoutCard>();
        for (NodeWrapper amexExpressCheckoutCardResponse : node.findAll("amex-express-checkout-cards/amex-express-checkout-card")) {
            this.amexExpressCheckoutCards.add(new AmexExpressCheckoutCard(amexExpressCheckoutCardResponse));
        }
        this.venmoAccounts = new ArrayList<VenmoAccount>();
        for (NodeWrapper venmoAccountResponse : node.findAll("venmo-accounts/venmo-account")) {
            this.venmoAccounts.add(new VenmoAccount(venmoAccountResponse));
        }
        this.visaCheckoutCards = new ArrayList<VisaCheckoutCard>();
        for (NodeWrapper visaCheckoutCardResponse : node.findAll("visa-checkout-cards/visa-checkout-card")) {
            this.visaCheckoutCards.add(new VisaCheckoutCard(visaCheckoutCardResponse));
        }
        this.masterpassCards = new ArrayList<MasterpassCard>();
        for (NodeWrapper masterpassCardResponse : node.findAll("masterpass-cards/masterpass-card")) {
            this.masterpassCards.add(new MasterpassCard(masterpassCardResponse));
        }
        this.usBankAccounts = new ArrayList<UsBankAccount>();
        for (NodeWrapper usBankAccountResponse : node.findAll("us-bank-accounts/us-bank-account")) {
            this.usBankAccounts.add(new UsBankAccount(usBankAccountResponse));
        }
        this.sepaDirectDebitAccounts = new ArrayList<SepaDirectDebitAccount>();
        for (NodeWrapper sepaDirectDebitAccountResponse : node.findAll("sepa-debit-accounts/sepa-debit-account")) {
            this.sepaDirectDebitAccounts.add(new SepaDirectDebitAccount(sepaDirectDebitAccountResponse));
        }
        this.samsungPayCards = new ArrayList<SamsungPayCard>();
        for (NodeWrapper samsungPayCardResponse : node.findAll("samsung-pay-cards/samsung-pay-card")) {
            this.samsungPayCards.add(new SamsungPayCard(samsungPayCardResponse));
        }
        this.customActionsPaymentMethods = new ArrayList<CustomActionsPaymentMethod>();
        for (NodeWrapper customActionsPaymentMethodResponse : node.findAll("custom-actions-payment-methods/custom-actions-payment-method")) {
            this.customActionsPaymentMethods.add(new CustomActionsPaymentMethod(customActionsPaymentMethodResponse));
        }
        this.addresses = new ArrayList<Address>();
        for (NodeWrapper addressResponse : node.findAll("addresses/address")) {
            this.addresses.add(new Address(addressResponse));
        }
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    public String getId() {
        return this.id;
    }

    public String getGraphQLId() {
        return this.graphqlId;
    }

    public String getCompany() {
        return this.company;
    }

    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFax() {
        return this.fax;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getWebsite() {
        return this.website;
    }

    public List<Address> getAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }

    public List<CreditCard> getCreditCards() {
        return Collections.unmodifiableList(this.creditCards);
    }

    public List<PayPalAccount> getPayPalAccounts() {
        return Collections.unmodifiableList(this.paypalAccounts);
    }

    public List<ApplePayCard> getApplePayCards() {
        return Collections.unmodifiableList(this.applePayCards);
    }

    public List<AndroidPayCard> getAndroidPayCards() {
        return Collections.unmodifiableList(this.androidPayCards);
    }

    @Deprecated
    public List<AmexExpressCheckoutCard> getAmexExpressCheckoutCards() {
        return Collections.unmodifiableList(this.amexExpressCheckoutCards);
    }

    public List<VenmoAccount> getVenmoAccounts() {
        return Collections.unmodifiableList(this.venmoAccounts);
    }

    public List<VisaCheckoutCard> getVisaCheckoutCards() {
        return Collections.unmodifiableList(this.visaCheckoutCards);
    }

    @Deprecated
    public List<MasterpassCard> getMasterpassCards() {
        return Collections.unmodifiableList(this.masterpassCards);
    }

    public List<UsBankAccount> getUsBankAccounts() {
        return Collections.unmodifiableList(this.usBankAccounts);
    }

    public List<SepaDirectDebitAccount> getSepaDirectDebitAccounts() {
        return Collections.unmodifiableList(this.sepaDirectDebitAccounts);
    }

    public List<SamsungPayCard> getSamsungPayCards() {
        return Collections.unmodifiableList(this.samsungPayCards);
    }

    public List<CustomActionsPaymentMethod> getCustomActionsPaymentMethods() {
        return Collections.unmodifiableList(this.customActionsPaymentMethods);
    }

    public List<? extends PaymentMethod> getPaymentMethods() {
        ArrayList<PaymentMethod> paymentMethods = new ArrayList<PaymentMethod>();
        paymentMethods.addAll(this.getCreditCards());
        paymentMethods.addAll(this.getPayPalAccounts());
        paymentMethods.addAll(this.getApplePayCards());
        paymentMethods.addAll(this.getAndroidPayCards());
        paymentMethods.addAll(this.getAmexExpressCheckoutCards());
        paymentMethods.addAll(this.getVenmoAccounts());
        paymentMethods.addAll(this.getVisaCheckoutCards());
        paymentMethods.addAll(this.getMasterpassCards());
        paymentMethods.addAll(this.getSamsungPayCards());
        paymentMethods.addAll(this.getSepaDirectDebitAccounts());
        paymentMethods.addAll(this.getCustomActionsPaymentMethods());
        return Collections.unmodifiableList(paymentMethods);
    }

    public PaymentMethod getDefaultPaymentMethod() {
        for (PaymentMethod paymentMethod : this.getPaymentMethods()) {
            if (!paymentMethod.isDefault()) continue;
            return paymentMethod;
        }
        return null;
    }
}

