/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.Calendar;

public class Adjustment {
    private Calendar projectedDisbursementDate;
    private Calendar actualDisbursementDate;
    private BigDecimal amount;
    private KIND kind;

    public Adjustment(NodeWrapper node) {
        this.amount = node.findBigDecimal("amount");
        this.projectedDisbursementDate = node.findDateTime("projected_disbursement_date");
        this.actualDisbursementDate = node.findDateTime("actual_disbursement_date");
        this.kind = EnumUtils.findByName(KIND.class, node.findString("kind"), KIND.UNRECOGNIZED);
    }

    public Calendar getProjectedDisbursementDate() {
        return this.projectedDisbursementDate;
    }

    public Calendar getActualDisbursementDate() {
        return this.actualDisbursementDate;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public KIND getKind() {
        return this.kind;
    }

    public static enum KIND {
        REFUND,
        DISPUTE,
        UNRECOGNIZED;

    }
}

