/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.dropin.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.braintreepayments.api.dropin.R;
import com.braintreepayments.api.dropin.utils.PaymentMethodType;
import com.braintreepayments.api.models.CardNonce;
import com.braintreepayments.api.models.PaymentMethodNonce;

public class PaymentMethodItemView
extends LinearLayout {
    private ImageView mIcon;
    private TextView mTitle;
    private TextView mDescription;
    private View mDeleteIcon;
    private PaymentMethodNonce mPaymentMethodNonce;
    private View mDivider;

    public PaymentMethodItemView(Context context) {
        super(context);
        this.init();
    }

    public PaymentMethodItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PaymentMethodItemView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    @TargetApi(value=21)
    public PaymentMethodItemView(Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        super(context, attrs, defStyle, defStyleRes);
        this.init();
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.setOrientation(1);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.bt_vault_manager_list_item, (ViewGroup)this);
        this.mIcon = (ImageView)this.findViewById(R.id.bt_payment_method_icon);
        this.mTitle = (TextView)this.findViewById(R.id.bt_payment_method_title);
        this.mDescription = (TextView)this.findViewById(R.id.bt_payment_method_description);
        this.mDeleteIcon = this.findViewById(R.id.bt_payment_method_delete_icon);
        this.mDivider = this.findViewById(R.id.bt_payment_method_divider);
    }

    public void setPaymentMethod(PaymentMethodNonce paymentMethodNonce, boolean usedInList) {
        this.mPaymentMethodNonce = paymentMethodNonce;
        PaymentMethodType paymentMethodType = PaymentMethodType.forType(paymentMethodNonce);
        if (usedInList) {
            this.mIcon.setImageResource(paymentMethodType.getDrawable());
            this.mDeleteIcon.setVisibility(0);
            this.mDivider.setVisibility(0);
        } else {
            this.mIcon.setImageResource(paymentMethodType.getVaultedDrawable());
            this.mDeleteIcon.setVisibility(8);
            this.mDivider.setVisibility(8);
        }
        this.mTitle.setText(paymentMethodType.getLocalizedName());
        if (paymentMethodNonce instanceof CardNonce) {
            this.mDescription.setText((CharSequence)("\u2022\u2022\u2022 \u2022\u2022" + ((CardNonce)paymentMethodNonce).getLastTwo()));
        } else {
            this.mDescription.setText((CharSequence)paymentMethodNonce.getDescription());
        }
    }

    public void setOnDeleteIconClick(View.OnClickListener clickListener) {
        this.mDeleteIcon.setOnClickListener(clickListener);
    }

    public PaymentMethodNonce getPaymentMethodNonce() {
        return this.mPaymentMethodNonce;
    }
}

