/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.dropin.view;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.braintreepayments.api.dropin.R;
import com.braintreepayments.api.dropin.interfaces.AddPaymentUpdateListener;
import com.braintreepayments.api.dropin.view.AnimatedButtonView;
import com.braintreepayments.api.exceptions.BraintreeError;
import com.braintreepayments.api.exceptions.ErrorWithResponse;
import com.braintreepayments.cardform.utils.ViewUtils;
import com.braintreepayments.cardform.view.ErrorEditText;

public class EnrollmentCardView
extends LinearLayout
implements View.OnClickListener,
TextView.OnEditorActionListener {
    private ErrorEditText mSmsCode;
    private TextView mSmsSentTextView;
    private AnimatedButtonView mAnimatedButtonView;
    private Button mSmsHelpButton;
    private boolean mEnrollmentFailed;
    private AddPaymentUpdateListener mListener;

    public EnrollmentCardView(Context context) {
        super(context);
        this.init();
    }

    public EnrollmentCardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public EnrollmentCardView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public EnrollmentCardView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.setOrientation(1);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.bt_enrollment_card, (ViewGroup)this, true);
        this.mSmsCode = (ErrorEditText)this.findViewById(R.id.bt_sms_code);
        this.mSmsCode.setImeOptions(2);
        this.mSmsCode.setImeActionLabel((CharSequence)this.getContext().getString(R.string.bt_confirm), 2);
        this.mSmsCode.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mSmsSentTextView = (TextView)this.findViewById(R.id.bt_sms_sent_text);
        this.mSmsHelpButton = (Button)this.findViewById(R.id.bt_sms_help_button);
        this.mAnimatedButtonView = (AnimatedButtonView)this.findViewById(R.id.bt_animated_button_view);
        this.mAnimatedButtonView.setClickListener(this);
        this.mSmsHelpButton.setOnClickListener((View.OnClickListener)this);
    }

    public void setup(Activity activity) {
        boolean isDarkBackground = ViewUtils.isDarkBackground((Activity)activity);
        ((ImageView)this.findViewById(R.id.bt_sms_code_icon)).setImageResource(isDarkBackground ? R.drawable.bt_ic_sms_code_dark : R.drawable.bt_ic_sms_code);
    }

    public void setAddPaymentUpdatedListener(AddPaymentUpdateListener listener) {
        this.mListener = listener;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.mSmsSentTextView.setText((CharSequence)this.getContext().getString(R.string.bt_sms_code_sent_to, new Object[]{phoneNumber}));
    }

    public String getSmsCode() {
        return this.mSmsCode.getText().toString();
    }

    public boolean onEditorAction(TextView textView, int i, KeyEvent keyEvent) {
        this.mAnimatedButtonView.showLoading();
        this.onClick((View)this.mAnimatedButtonView);
        return true;
    }

    public boolean hasFailedEnrollment() {
        return this.mEnrollmentFailed;
    }

    public boolean isEnrollmentError(ErrorWithResponse error) {
        BraintreeError enrollmentError;
        return error != null && (enrollmentError = error.errorFor("unionPayEnrollment")) != null && enrollmentError.errorFor("base") != null;
    }

    public void setErrors(ErrorWithResponse errors) {
        if (errors.errorFor("unionPayEnrollment") != null) {
            this.mSmsCode.setError(this.getContext().getString(R.string.bt_unionpay_sms_code_invalid));
            this.mEnrollmentFailed = true;
        }
        this.mAnimatedButtonView.showButton();
    }

    public void onClick(View view) {
        if (view == this.mAnimatedButtonView && TextUtils.isEmpty((CharSequence)this.mSmsCode.getText())) {
            this.mAnimatedButtonView.showButton();
            this.mSmsCode.setError(this.getContext().getString(R.string.bt_sms_code_required));
        } else {
            if (this.mListener == null) {
                return;
            }
            if (view == this.mAnimatedButtonView) {
                this.mListener.onPaymentUpdated((View)this);
            } else if (view == this.mSmsHelpButton) {
                this.mListener.onBackRequested((View)this);
            }
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.mAnimatedButtonView.showButton();
        this.mEnrollmentFailed = false;
        if (visibility == 0) {
            this.mSmsCode.requestFocus();
        }
    }
}

