/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.dropin.view;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.braintreepayments.api.dropin.DropInRequest;
import com.braintreepayments.api.dropin.R;
import com.braintreepayments.api.dropin.interfaces.AddPaymentUpdateListener;
import com.braintreepayments.api.dropin.view.AnimatedButtonView;
import com.braintreepayments.api.exceptions.BraintreeError;
import com.braintreepayments.api.exceptions.ErrorWithResponse;
import com.braintreepayments.api.models.Configuration;
import com.braintreepayments.cardform.OnCardFormFieldFocusedListener;
import com.braintreepayments.cardform.OnCardFormSubmitListener;
import com.braintreepayments.cardform.view.CardEditText;
import com.braintreepayments.cardform.view.CardForm;

public class EditCardView
extends LinearLayout
implements OnCardFormFieldFocusedListener,
View.OnClickListener,
OnCardFormSubmitListener {
    private CardForm mCardForm;
    private AnimatedButtonView mAnimatedButtonView;
    private Configuration mConfiguration;
    private AddPaymentUpdateListener mListener;

    public EditCardView(Context context) {
        super(context);
        this.init();
    }

    public EditCardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public EditCardView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    @TargetApi(value=21)
    public EditCardView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.setOrientation(1);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.bt_edit_card, (ViewGroup)this);
        this.mCardForm = (CardForm)this.findViewById(R.id.bt_card_form);
        this.mAnimatedButtonView = (AnimatedButtonView)this.findViewById(R.id.bt_animated_button_view);
    }

    @Deprecated
    public void setup(Activity activity, Configuration configuration) {
        this.setup(activity, configuration, new DropInRequest());
    }

    public void setup(Activity activity, Configuration configuration, DropInRequest dropInRequest) {
        this.mConfiguration = configuration;
        this.mCardForm.cardRequired(true).expirationRequired(true).cvvRequired(configuration.isCvvChallengePresent()).postalCodeRequired(configuration.isPostalCodeChallengePresent()).cardholderName(dropInRequest.getCardholderNameStatus()).setup(activity);
        this.mCardForm.setOnCardFormSubmitListener((OnCardFormSubmitListener)this);
        this.mAnimatedButtonView.setClickListener(this);
    }

    public void setAddPaymentUpdatedListener(AddPaymentUpdateListener listener) {
        this.mListener = listener;
    }

    public CardForm getCardForm() {
        return this.mCardForm;
    }

    public void setCardNumber(String cardNumber) {
        this.mCardForm.getCardEditText().setText((CharSequence)cardNumber);
    }

    public void setMaskCardNumber(boolean mask) {
        this.mCardForm.maskCardNumber(mask);
    }

    public void setMaskCvv(boolean mask) {
        this.mCardForm.maskCvv(mask);
    }

    public void setErrors(ErrorWithResponse errors) {
        BraintreeError formErrors = errors.errorFor("unionPayEnrollment");
        if (formErrors == null) {
            formErrors = errors.errorFor("creditCard");
        }
        if (formErrors != null) {
            if (formErrors.errorFor("expirationYear") != null || formErrors.errorFor("expirationMonth") != null || formErrors.errorFor("expirationDate") != null) {
                this.mCardForm.setExpirationError(this.getContext().getString(R.string.bt_expiration_invalid));
            }
            if (formErrors.errorFor("cvv") != null) {
                this.mCardForm.setCvvError(this.getContext().getString(R.string.bt_cvv_invalid, new Object[]{this.getContext().getString(this.mCardForm.getCardEditText().getCardType().getSecurityCodeName())}));
            }
            if (formErrors.errorFor("billingAddress") != null) {
                this.mCardForm.setPostalCodeError(this.getContext().getString(R.string.bt_postal_code_invalid));
            }
            if (formErrors.errorFor("mobileCountryCode") != null) {
                this.mCardForm.setCountryCodeError(this.getContext().getString(R.string.bt_country_code_invalid));
            }
            if (formErrors.errorFor("mobileNumber") != null) {
                this.mCardForm.setMobileNumberError(this.getContext().getString(R.string.bt_mobile_number_invalid));
            }
        }
        this.mAnimatedButtonView.showButton();
    }

    public void useUnionPay(Activity activity, boolean useUnionPay, boolean debitCard) {
        this.mCardForm.getExpirationDateEditText().setOptional(false);
        this.mCardForm.getCvvEditText().setOptional(false);
        if (useUnionPay) {
            if (debitCard) {
                this.mCardForm.getExpirationDateEditText().setOptional(true);
                this.mCardForm.getCvvEditText().setOptional(true);
            }
            this.mCardForm.cardRequired(true).expirationRequired(true).cvvRequired(true).postalCodeRequired(this.mConfiguration.isPostalCodeChallengePresent()).mobileNumberRequired(true).mobileNumberExplanation(this.getContext().getString(R.string.bt_unionpay_mobile_number_explanation)).setup(activity);
        }
    }

    public void onCardFormSubmit() {
        if (this.mCardForm.isValid()) {
            this.mAnimatedButtonView.showLoading();
            if (this.mListener != null) {
                this.mListener.onPaymentUpdated((View)this);
            }
        } else {
            this.mAnimatedButtonView.showButton();
            this.mCardForm.validate();
        }
    }

    public void onClick(View view) {
        this.onCardFormSubmit();
    }

    public void onCardFormFieldFocused(View field) {
        if (field instanceof CardEditText && this.mListener != null) {
            this.mListener.onBackRequested((View)this);
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.mAnimatedButtonView.showButton();
        if (visibility == 0) {
            if (!this.mCardForm.getExpirationDateEditText().isValid() || TextUtils.isEmpty((CharSequence)this.mCardForm.getExpirationDateEditText().getText())) {
                this.mCardForm.getExpirationDateEditText().requestFocus();
            } else if (this.mCardForm.getCvvEditText().getVisibility() == 0 && (!this.mCardForm.getCvvEditText().isValid() || TextUtils.isEmpty((CharSequence)this.mCardForm.getCvvEditText().getText()))) {
                this.mCardForm.getCvvEditText().requestFocus();
            } else if (this.mCardForm.getPostalCodeEditText().getVisibility() == 0 && !this.mCardForm.getPostalCodeEditText().isValid()) {
                this.mCardForm.getPostalCodeEditText().requestFocus();
            } else if (this.mCardForm.getCountryCodeEditText().getVisibility() == 0 && !this.mCardForm.getCountryCodeEditText().isValid()) {
                this.mCardForm.getCountryCodeEditText().requestFocus();
            } else if (this.mCardForm.getMobileNumberEditText().getVisibility() == 0 && !this.mCardForm.getMobileNumberEditText().isValid()) {
                this.mCardForm.getMobileNumberEditText().requestFocus();
            } else {
                this.mAnimatedButtonView.requestButtonFocus();
                this.mCardForm.closeSoftKeyboard();
            }
            this.mCardForm.setOnFormFieldFocusedListener((OnCardFormFieldFocusedListener)this);
        } else {
            this.mCardForm.setOnFormFieldFocusedListener(null);
        }
    }
}

