/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.dropin.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.ViewAnimator;
import com.braintreepayments.api.dropin.R;

public class AnimatedButtonView
extends RelativeLayout
implements View.OnClickListener {
    private ViewAnimator mViewAnimator;
    private Button mButton;
    private View.OnClickListener mOnClickListener;

    public AnimatedButtonView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public AnimatedButtonView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public AnimatedButtonView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.bt_animated_button_view, (ViewGroup)this);
        this.mViewAnimator = (ViewAnimator)this.findViewById(R.id.bt_view_animator);
        this.mButton = (Button)this.findViewById(R.id.bt_button);
        this.mButton.setOnClickListener((View.OnClickListener)this);
        this.mViewAnimator.setInAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0000));
        this.mViewAnimator.setOutAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0001));
        TypedArray attributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.bt_AnimatedButtonAttributes);
        this.mButton.setText((CharSequence)attributes.getString(R.styleable.bt_AnimatedButtonAttributes_bt_buttonText));
        attributes.recycle();
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
    }

    public void onClick(View view) {
        this.showLoading();
        if (this.mOnClickListener != null) {
            this.mOnClickListener.onClick((View)this);
        }
    }

    public void showButton() {
        if (this.mViewAnimator.getDisplayedChild() == 1) {
            this.mViewAnimator.showPrevious();
        }
    }

    public void showLoading() {
        if (this.mViewAnimator.getDisplayedChild() == 0) {
            this.mViewAnimator.showNext();
        }
    }

    public void requestButtonFocus() {
        this.requestFocus();
    }

    public void setClickListener(View.OnClickListener onClickListener) {
        this.mOnClickListener = onClickListener;
    }
}

