/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.dropin.view;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.braintreepayments.api.dropin.R;
import com.braintreepayments.api.dropin.interfaces.AddPaymentUpdateListener;
import com.braintreepayments.api.dropin.utils.PaymentMethodType;
import com.braintreepayments.api.dropin.view.AnimatedButtonView;
import com.braintreepayments.api.exceptions.BraintreeError;
import com.braintreepayments.api.exceptions.ErrorWithResponse;
import com.braintreepayments.api.models.Configuration;
import com.braintreepayments.cardform.OnCardFormSubmitListener;
import com.braintreepayments.cardform.OnCardFormValidListener;
import com.braintreepayments.cardform.utils.CardType;
import com.braintreepayments.cardform.view.CardEditText;
import com.braintreepayments.cardform.view.CardForm;
import com.braintreepayments.cardform.view.SupportedCardTypesView;
import java.util.Arrays;
import java.util.HashSet;

public class AddCardView
extends LinearLayout
implements OnCardFormSubmitListener,
OnCardFormValidListener,
View.OnClickListener,
CardEditText.OnCardTypeChangedListener {
    private static final String PARENT_STATE = "com.braintreepayments.api.dropin.view.PARENT_STATE";
    private static final String CARD_NUMBER = "com.braintreepayments.api.dropin.view.CARD_NUMBER";
    private CardType[] mSupportedCardTypes;
    private CardForm mCardForm;
    private SupportedCardTypesView mSupportedCardTypesView;
    private AnimatedButtonView mAnimatedButtonView;
    private AddPaymentUpdateListener mListener;
    private String mCardNumber;

    public AddCardView(Context context) {
        super(context);
        this.init();
    }

    public AddCardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AddCardView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    @TargetApi(value=21)
    public AddCardView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.setOrientation(1);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.bt_add_card, (ViewGroup)this, true);
        this.mCardForm = (CardForm)this.findViewById(R.id.bt_card_form);
        this.mSupportedCardTypesView = (SupportedCardTypesView)this.findViewById(R.id.bt_supported_card_types);
        this.mAnimatedButtonView = (AnimatedButtonView)this.findViewById(R.id.bt_animated_button_view);
    }

    public void setup(Activity activity, Configuration configuration, boolean unionpaySupported) {
        this.mCardForm.getCardEditText().displayCardTypeIcon(false);
        this.mCardForm.cardRequired(true).setup(activity);
        this.mCardForm.setOnCardTypeChangedListener((CardEditText.OnCardTypeChangedListener)this);
        this.mCardForm.setOnCardFormValidListener((OnCardFormValidListener)this);
        this.mCardForm.setOnCardFormSubmitListener((OnCardFormSubmitListener)this);
        HashSet<String> cardTypes = new HashSet<String>(configuration.getCardConfiguration().getSupportedCardTypes());
        if (!unionpaySupported) {
            cardTypes.remove(PaymentMethodType.UNIONPAY.getCanonicalName());
        }
        this.mSupportedCardTypes = PaymentMethodType.getCardsTypes(cardTypes);
        this.mSupportedCardTypesView.setSupportedCardTypes(this.mSupportedCardTypes);
        this.mAnimatedButtonView.setVisibility(configuration.getUnionPay().isEnabled() ? 0 : 8);
        this.mAnimatedButtonView.setClickListener(this);
        if (this.mCardNumber != null) {
            this.mCardForm.getCardEditText().setText((CharSequence)this.mCardNumber);
            this.mCardNumber = null;
        }
    }

    public void setAddPaymentUpdatedListener(AddPaymentUpdateListener listener) {
        this.mListener = listener;
    }

    public CardForm getCardForm() {
        return this.mCardForm;
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.mAnimatedButtonView.showButton();
        if (visibility == 0) {
            this.mCardForm.getCardEditText().requestFocus();
        }
    }

    public void showCardNotSupportedError() {
        this.mCardForm.getCardEditText().setError(this.getContext().getString(R.string.bt_card_not_accepted));
        this.mAnimatedButtonView.showButton();
    }

    public boolean isCardNumberError(ErrorWithResponse errors) {
        BraintreeError formErrors = errors.errorFor("creditCard");
        return formErrors != null && formErrors.errorFor("number") != null;
    }

    public void setErrors(ErrorWithResponse errors) {
        BraintreeError formErrors = errors.errorFor("creditCard");
        if (formErrors != null && formErrors.errorFor("number") != null) {
            this.mCardForm.setCardNumberError(this.getContext().getString(R.string.bt_card_number_invalid));
        }
        this.mAnimatedButtonView.showButton();
    }

    public void onCardTypeChanged(CardType cardType) {
        if (cardType == CardType.EMPTY) {
            this.mSupportedCardTypesView.setSupportedCardTypes(this.mSupportedCardTypes);
        } else {
            this.mSupportedCardTypesView.setSelected(new CardType[]{cardType});
        }
    }

    public void onClick(View view) {
        if (this.isValid()) {
            this.callAddPaymentUpdateListener();
        } else {
            this.mAnimatedButtonView.showButton();
            if (!this.mCardForm.isValid()) {
                this.mCardForm.validate();
            } else if (!this.isCardTypeValid()) {
                this.showCardNotSupportedError();
            }
        }
    }

    public void onCardFormSubmit() {
        if (this.isValid()) {
            this.mAnimatedButtonView.showLoading();
            this.callAddPaymentUpdateListener();
        } else if (!this.mCardForm.isValid()) {
            this.mCardForm.validate();
        } else if (!this.isCardTypeValid()) {
            this.showCardNotSupportedError();
        }
    }

    public void onCardFormValid(boolean valid) {
        if (this.isValid()) {
            this.mAnimatedButtonView.showLoading();
            this.callAddPaymentUpdateListener();
        }
    }

    private boolean isValid() {
        return this.mCardForm.isValid() && this.isCardTypeValid();
    }

    private boolean isCardTypeValid() {
        return Arrays.asList(this.mSupportedCardTypes).contains(this.mCardForm.getCardEditText().getCardType());
    }

    private void callAddPaymentUpdateListener() {
        if (this.mListener != null) {
            this.mListener.onPaymentUpdated((View)this);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(PARENT_STATE, super.onSaveInstanceState());
        bundle.putString(CARD_NUMBER, this.mCardForm.getCardNumber());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            this.mCardNumber = ((Bundle)state).getString(CARD_NUMBER);
            state = ((Bundle)state).getParcelable(PARENT_STATE);
        }
        super.onRestoreInstanceState(state);
    }
}

