/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.dropin.adapters;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.braintreepayments.api.dropin.R;
import com.braintreepayments.api.dropin.utils.PaymentMethodType;
import com.braintreepayments.api.interfaces.PaymentMethodNonceCreatedListener;
import com.braintreepayments.api.models.CardNonce;
import com.braintreepayments.api.models.PaymentMethodNonce;
import java.util.List;

public class VaultedPaymentMethodsAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private PaymentMethodNonceCreatedListener mSelectedListener;
    private List<PaymentMethodNonce> mPaymentMethodNonces;

    public VaultedPaymentMethodsAdapter(PaymentMethodNonceCreatedListener listener, List<PaymentMethodNonce> paymentMethodNonces) {
        this.mSelectedListener = listener;
        this.mPaymentMethodNonces = paymentMethodNonces;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bt_vaulted_payment_method_card, parent, false));
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        final PaymentMethodNonce paymentMethodNonce = this.mPaymentMethodNonces.get(position);
        PaymentMethodType paymentMethodType = PaymentMethodType.forType(paymentMethodNonce);
        holder.icon.setImageResource(paymentMethodType.getVaultedDrawable());
        holder.title.setText(paymentMethodType.getLocalizedName());
        if (paymentMethodNonce instanceof CardNonce) {
            holder.description.setText((CharSequence)("\u2022\u2022\u2022 \u2022\u2022" + ((CardNonce)paymentMethodNonce).getLastTwo()));
        } else {
            holder.description.setText((CharSequence)paymentMethodNonce.getDescription());
        }
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VaultedPaymentMethodsAdapter.this.mSelectedListener.onPaymentMethodNonceCreated(paymentMethodNonce);
            }
        });
    }

    public int getItemCount() {
        return this.mPaymentMethodNonces.size();
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        public ImageView icon;
        public TextView title;
        public TextView description;

        ViewHolder(View view) {
            super(view);
            this.icon = (ImageView)view.findViewById(R.id.bt_payment_method_icon);
            this.title = (TextView)view.findViewById(R.id.bt_payment_method_title);
            this.description = (TextView)view.findViewById(R.id.bt_payment_method_description);
        }
    }
}

