/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.dropin.adapters;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.braintreepayments.api.dropin.view.PaymentMethodItemView;
import com.braintreepayments.api.models.PaymentMethodNonce;
import java.util.ArrayList;
import java.util.List;

public class VaultManagerPaymentMethodsAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final List<PaymentMethodNonce> mPaymentMethodNonces = new ArrayList<PaymentMethodNonce>();
    private View.OnClickListener mClickListener;

    public VaultManagerPaymentMethodsAdapter(View.OnClickListener clickListener) {
        this.mClickListener = clickListener;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder((View)new PaymentMethodItemView(parent.getContext()));
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        PaymentMethodNonce paymentMethodNonce = this.mPaymentMethodNonces.get(position);
        final PaymentMethodItemView paymentMethodItemView = (PaymentMethodItemView)holder.itemView;
        paymentMethodItemView.setPaymentMethod(paymentMethodNonce, true);
        paymentMethodItemView.setOnDeleteIconClick(new View.OnClickListener(){

            public void onClick(View v) {
                if (VaultManagerPaymentMethodsAdapter.this.mClickListener != null) {
                    VaultManagerPaymentMethodsAdapter.this.mClickListener.onClick((View)paymentMethodItemView);
                }
            }
        });
    }

    public PaymentMethodNonce getPaymentMethodNonce(int index) {
        return this.mPaymentMethodNonces.get(index);
    }

    public void paymentMethodDeleted(PaymentMethodNonce paymentMethodNonce) {
        int index = this.mPaymentMethodNonces.indexOf(paymentMethodNonce);
        this.mPaymentMethodNonces.remove(index);
        this.notifyItemRemoved(index);
    }

    public int getItemCount() {
        return this.mPaymentMethodNonces.size();
    }

    public void setPaymentMethodNonces(List<PaymentMethodNonce> paymentMethodNonces) {
        this.mPaymentMethodNonces.clear();
        this.mPaymentMethodNonces.addAll(paymentMethodNonces);
    }

    public ArrayList<PaymentMethodNonce> getPaymentMethodNonces() {
        return new ArrayList<PaymentMethodNonce>(this.mPaymentMethodNonces);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        ViewHolder(View view) {
            super(view);
        }
    }
}

