/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.dropin.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.braintreepayments.api.dropin.DropInRequest;
import com.braintreepayments.api.dropin.R;
import com.braintreepayments.api.dropin.utils.PaymentMethodType;
import com.braintreepayments.api.models.Configuration;
import java.util.ArrayList;
import java.util.HashSet;

public class SupportedPaymentMethodsAdapter
extends BaseAdapter {
    private Context mContext;
    private ArrayList<PaymentMethodType> mAvailablePaymentMethods;
    private PaymentMethodSelectedListener mPaymentMethodSelectedListener;

    public SupportedPaymentMethodsAdapter(Context context, PaymentMethodSelectedListener paymentMethodSelectedListener) {
        this.mContext = context;
        this.mPaymentMethodSelectedListener = paymentMethodSelectedListener;
        this.mAvailablePaymentMethods = new ArrayList();
    }

    public void setup(Configuration configuration, DropInRequest dropInRequest, boolean androidPayEnabled, boolean unionpaySupported) {
        if (dropInRequest.isPayPalEnabled() && configuration.isPayPalEnabled()) {
            this.mAvailablePaymentMethods.add(PaymentMethodType.PAYPAL);
        }
        if (dropInRequest.isVenmoEnabled() && configuration.getPayWithVenmo().isEnabled(this.mContext)) {
            this.mAvailablePaymentMethods.add(PaymentMethodType.PAY_WITH_VENMO);
        }
        HashSet supportedCardTypes = new HashSet(configuration.getCardConfiguration().getSupportedCardTypes());
        if (!unionpaySupported) {
            supportedCardTypes.remove(PaymentMethodType.UNIONPAY.getCanonicalName());
        }
        if (supportedCardTypes.size() > 0) {
            this.mAvailablePaymentMethods.add(PaymentMethodType.UNKNOWN);
        }
        if (androidPayEnabled) {
            if (dropInRequest.isGooglePaymentEnabled()) {
                this.mAvailablePaymentMethods.add(PaymentMethodType.GOOGLE_PAYMENT);
            } else if (dropInRequest.isAndroidPayEnabled()) {
                this.mAvailablePaymentMethods.add(PaymentMethodType.ANDROID_PAY);
            }
        }
    }

    public int getCount() {
        return this.mAvailablePaymentMethods.size();
    }

    public Object getItem(int position) {
        return this.mAvailablePaymentMethods.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.bt_payment_method_list_item, parent, false);
        }
        final PaymentMethodType type = this.mAvailablePaymentMethods.get(position);
        ImageView icon = (ImageView)convertView.findViewById(R.id.bt_payment_method_icon);
        icon.setImageResource(type.getDrawable());
        ((TextView)convertView.findViewById(R.id.bt_payment_method_type)).setText((CharSequence)this.mContext.getString(type.getLocalizedName()));
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SupportedPaymentMethodsAdapter.this.mPaymentMethodSelectedListener.onPaymentMethodSelected(type);
            }
        });
        return convertView;
    }

    public static interface PaymentMethodSelectedListener {
        public void onPaymentMethodSelected(PaymentMethodType var1);
    }
}

