/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.dropin;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.design.widget.Snackbar;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.Window;
import android.widget.ViewSwitcher;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.PaymentMethod;
import com.braintreepayments.api.dropin.BaseActivity;
import com.braintreepayments.api.dropin.R;
import com.braintreepayments.api.dropin.adapters.VaultManagerPaymentMethodsAdapter;
import com.braintreepayments.api.dropin.view.PaymentMethodItemView;
import com.braintreepayments.api.exceptions.InvalidArgumentException;
import com.braintreepayments.api.exceptions.PaymentMethodDeleteException;
import com.braintreepayments.api.interfaces.BraintreeErrorListener;
import com.braintreepayments.api.interfaces.PaymentMethodNonceDeletedListener;
import com.braintreepayments.api.models.PaymentMethodNonce;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class VaultManagerActivity
extends BaseActivity
implements PaymentMethodNonceDeletedListener,
BraintreeErrorListener,
View.OnClickListener {
    @VisibleForTesting
    protected VaultManagerPaymentMethodsAdapter mAdapter = new VaultManagerPaymentMethodsAdapter(this);
    private ViewSwitcher mLoadingViewSwitcher;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.bt_vault_management_activity);
        this.mLoadingViewSwitcher = (ViewSwitcher)this.findViewById(R.id.bt_loading_view_switcher);
        RecyclerView vaultManagerView = (RecyclerView)this.findViewById(R.id.bt_vault_manager_list);
        View closeButton = this.findViewById(R.id.bt_vault_manager_close);
        closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VaultManagerActivity.this.finish();
            }
        });
        try {
            this.mBraintreeFragment = this.getBraintreeFragment();
        }
        catch (InvalidArgumentException e) {
            this.finish((Exception)((Object)e));
        }
        ArrayList nonces = savedInstanceState == null ? this.getIntent().getParcelableArrayListExtra("com.braintreepayments.api.EXTRA_PAYMENT_METHOD_NONCES") : savedInstanceState.getParcelableArrayList("com.braintreepayments.api.EXTRA_PAYMENT_METHOD_NONCES");
        this.mAdapter.setPaymentMethodNonces(nonces);
        vaultManagerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
        vaultManagerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.clearFlags(0x4000000);
            window.setStatusBarColor(0);
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelableArrayList("com.braintreepayments.api.EXTRA_PAYMENT_METHOD_NONCES", this.mAdapter.getPaymentMethodNonces());
    }

    public void onPaymentMethodNonceDeleted(PaymentMethodNonce paymentMethodNonce) {
        this.mAdapter.paymentMethodDeleted(paymentMethodNonce);
        this.mBraintreeFragment.sendAnalyticsEvent("manager.delete.succeeded");
        this.setResult(-1, new Intent().putExtra("com.braintreepayments.api.EXTRA_PAYMENT_METHOD_NONCES", this.mAdapter.getPaymentMethodNonces()));
        this.mLoadingViewSwitcher.setDisplayedChild(0);
    }

    public void onError(Exception error) {
        if (error instanceof PaymentMethodDeleteException) {
            PaymentMethodDeleteException exception = (PaymentMethodDeleteException)error;
            Snackbar.make((View)this.findViewById(R.id.bt_base_view), (int)R.string.bt_vault_manager_delete_failure, (int)0).show();
            this.mBraintreeFragment.sendAnalyticsEvent("manager.delete.failed");
            this.mLoadingViewSwitcher.setDisplayedChild(0);
        } else {
            this.mBraintreeFragment.sendAnalyticsEvent("manager.unknown.failed");
            this.finish(error);
        }
    }

    public void onClick(View v) {
        if (v instanceof PaymentMethodItemView) {
            final AtomicBoolean positiveSelected = new AtomicBoolean(false);
            PaymentMethodItemView paymentMethodItemView = (PaymentMethodItemView)v;
            final PaymentMethodNonce paymentMethodNonceToDelete = paymentMethodItemView.getPaymentMethodNonce();
            PaymentMethodItemView dialogView = new PaymentMethodItemView((Context)this);
            dialogView.setPaymentMethod(paymentMethodNonceToDelete, false);
            new AlertDialog.Builder((Context)this, R.style.Theme_AppCompat_Light_Dialog_Alert).setTitle(R.string.bt_delete_confirmation_title).setMessage(R.string.bt_delete_confirmation_description).setView((View)dialogView).setPositiveButton(R.string.bt_delete, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    positiveSelected.set(true);
                    VaultManagerActivity.this.mBraintreeFragment.sendAnalyticsEvent("manager.delete.confirmation.positive");
                    PaymentMethod.deletePaymentMethod((BraintreeFragment)VaultManagerActivity.this.mBraintreeFragment, (PaymentMethodNonce)paymentMethodNonceToDelete);
                    VaultManagerActivity.this.mLoadingViewSwitcher.setDisplayedChild(1);
                }
            }).setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    if (!positiveSelected.get()) {
                        VaultManagerActivity.this.mBraintreeFragment.sendAnalyticsEvent("manager.delete.confirmation.negative");
                    }
                }
            }).setNegativeButton(R.string.bt_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create().show();
        }
    }

    public void onBackPressed() {
        if (this.mLoadingViewSwitcher.getDisplayedChild() == 0) {
            super.onBackPressed();
        }
    }
}

