/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.dropin;

import android.app.Activity;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.braintreepayments.api.AndroidPay;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.GooglePayment;
import com.braintreepayments.api.PaymentMethod;
import com.braintreepayments.api.dropin.utils.PaymentMethodType;
import com.braintreepayments.api.exceptions.InvalidArgumentException;
import com.braintreepayments.api.interfaces.BraintreeErrorListener;
import com.braintreepayments.api.interfaces.BraintreeListener;
import com.braintreepayments.api.interfaces.BraintreeResponseListener;
import com.braintreepayments.api.interfaces.PaymentMethodNoncesUpdatedListener;
import com.braintreepayments.api.internal.BraintreeSharedPreferences;
import com.braintreepayments.api.models.Authorization;
import com.braintreepayments.api.models.ClientToken;
import com.braintreepayments.api.models.PaymentMethodNonce;
import java.util.ArrayList;
import java.util.List;

public class DropInResult
implements Parcelable {
    public static final String EXTRA_DROP_IN_RESULT = "com.braintreepayments.api.dropin.EXTRA_DROP_IN_RESULT";
    static final String LAST_USED_PAYMENT_METHOD_TYPE = "com.braintreepayments.api.dropin.LAST_USED_PAYMENT_METHOD_TYPE";
    private PaymentMethodType mPaymentMethodType;
    private PaymentMethodNonce mPaymentMethodNonce;
    private String mDeviceData;
    public static final Parcelable.Creator<DropInResult> CREATOR = new Parcelable.Creator<DropInResult>(){

        public DropInResult createFromParcel(Parcel source) {
            return new DropInResult(source);
        }

        public DropInResult[] newArray(int size) {
            return new DropInResult[size];
        }
    };

    public DropInResult() {
    }

    DropInResult paymentMethodNonce(@Nullable PaymentMethodNonce paymentMethodNonce) {
        if (paymentMethodNonce != null) {
            this.mPaymentMethodType = PaymentMethodType.forType(paymentMethodNonce.getTypeLabel());
        }
        this.mPaymentMethodNonce = paymentMethodNonce;
        return this;
    }

    DropInResult deviceData(@Nullable String deviceData) {
        this.mDeviceData = deviceData;
        return this;
    }

    @Nullable
    public PaymentMethodType getPaymentMethodType() {
        return this.mPaymentMethodType;
    }

    @Nullable
    public PaymentMethodNonce getPaymentMethodNonce() {
        return this.mPaymentMethodNonce;
    }

    @Nullable
    public String getDeviceData() {
        return this.mDeviceData;
    }

    public static void fetchDropInResult(Activity activity, String clientToken, final @NonNull DropInResultListener listener) {
        BraintreeFragment fragment;
        try {
            if (!(Authorization.fromString((String)clientToken) instanceof ClientToken)) {
                listener.onError((Exception)((Object)new InvalidArgumentException("DropInResult#fetchDropInResult must be called with a client token")));
                return;
            }
        }
        catch (InvalidArgumentException e) {
            listener.onError((Exception)((Object)e));
            return;
        }
        try {
            fragment = BraintreeFragment.newInstance((Activity)activity, (String)clientToken);
        }
        catch (InvalidArgumentException e) {
            listener.onError((Exception)((Object)e));
            return;
        }
        final List previousListeners = fragment.getListeners();
        final ListenerHolder listenerHolder = new ListenerHolder();
        BraintreeErrorListener errorListener = new BraintreeErrorListener(){

            public void onError(Exception error) {
                DropInResult.resetListeners(fragment, listenerHolder, previousListeners);
                listener.onError(error);
            }
        };
        listenerHolder.listeners.add((BraintreeListener)errorListener);
        PaymentMethodNoncesUpdatedListener paymentMethodsListener = new PaymentMethodNoncesUpdatedListener(){

            public void onPaymentMethodNoncesUpdated(List<PaymentMethodNonce> paymentMethodNonces) {
                DropInResult.resetListeners(fragment, listenerHolder, previousListeners);
                if (paymentMethodNonces.size() > 0) {
                    PaymentMethodNonce paymentMethod = paymentMethodNonces.get(0);
                    listener.onResult(new DropInResult().paymentMethodNonce(paymentMethod));
                } else {
                    listener.onResult(new DropInResult());
                }
            }
        };
        listenerHolder.listeners.add((BraintreeListener)paymentMethodsListener);
        fragment.addListener((BraintreeListener)errorListener);
        fragment.addListener((BraintreeListener)paymentMethodsListener);
        final PaymentMethodType lastUsedPaymentMethodType = PaymentMethodType.forType(BraintreeSharedPreferences.getSharedPreferences((Context)activity).getString(LAST_USED_PAYMENT_METHOD_TYPE, null));
        if (lastUsedPaymentMethodType == PaymentMethodType.ANDROID_PAY || lastUsedPaymentMethodType == PaymentMethodType.GOOGLE_PAYMENT) {
            BraintreeResponseListener<Boolean> isReadyToPayCallback = new BraintreeResponseListener<Boolean>(){

                public void onResponse(Boolean isReadyToPay) {
                    if (isReadyToPay.booleanValue()) {
                        DropInResult.resetListeners(fragment, listenerHolder, previousListeners);
                        DropInResult result = new DropInResult();
                        result.mPaymentMethodType = lastUsedPaymentMethodType;
                        listener.onResult(result);
                    } else {
                        PaymentMethod.getPaymentMethodNonces((BraintreeFragment)fragment);
                    }
                }
            };
            switch (lastUsedPaymentMethodType) {
                case ANDROID_PAY: {
                    AndroidPay.isReadyToPay((BraintreeFragment)fragment, (BraintreeResponseListener)isReadyToPayCallback);
                    break;
                }
                case GOOGLE_PAYMENT: {
                    GooglePayment.isReadyToPay((BraintreeFragment)fragment, (BraintreeResponseListener)isReadyToPayCallback);
                }
            }
        } else {
            PaymentMethod.getPaymentMethodNonces((BraintreeFragment)fragment);
        }
    }

    static void setLastUsedPaymentMethodType(Context context, PaymentMethodNonce paymentMethodNonce) {
        BraintreeSharedPreferences.getSharedPreferences((Context)context).edit().putString(LAST_USED_PAYMENT_METHOD_TYPE, PaymentMethodType.forType(paymentMethodNonce).getCanonicalName()).apply();
    }

    private static void resetListeners(BraintreeFragment fragment, ListenerHolder listenerHolder, List<BraintreeListener> listeners) {
        for (BraintreeListener listener : listenerHolder.listeners) {
            fragment.removeListener(listener);
        }
        for (BraintreeListener previousListener : listeners) {
            fragment.addListener(previousListener);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mPaymentMethodType == null ? -1 : this.mPaymentMethodType.ordinal());
        dest.writeParcelable((Parcelable)this.mPaymentMethodNonce, flags);
        dest.writeString(this.mDeviceData);
    }

    protected DropInResult(Parcel in) {
        int paymentMethodType = in.readInt();
        this.mPaymentMethodType = paymentMethodType == -1 ? null : PaymentMethodType.values()[paymentMethodType];
        this.mPaymentMethodNonce = (PaymentMethodNonce)in.readParcelable(PaymentMethodNonce.class.getClassLoader());
        this.mDeviceData = in.readString();
    }

    private static class ListenerHolder {
        public List<BraintreeListener> listeners = new ArrayList<BraintreeListener>();

        private ListenerHolder() {
        }
    }

    public static interface DropInResultListener {
        public void onError(Exception var1);

        public void onResult(DropInResult var1);
    }
}

