/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.dropin;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.braintreepayments.api.dropin.DropInActivity;
import com.braintreepayments.api.models.GooglePaymentRequest;
import com.braintreepayments.api.models.PayPalRequest;
import com.google.android.gms.identity.intents.model.CountrySpecification;
import com.google.android.gms.wallet.Cart;
import java.util.ArrayList;
import java.util.List;

public class DropInRequest
implements Parcelable {
    public static final String EXTRA_CHECKOUT_REQUEST = "com.braintreepayments.api.EXTRA_CHECKOUT_REQUEST";
    private String mAuthorization;
    private String mAmount;
    private boolean mCollectDeviceData;
    private boolean mRequestThreeDSecureVerification;
    private Cart mAndroidPayCart;
    private GooglePaymentRequest mGooglePaymentRequest;
    private PayPalRequest mPayPalRequest;
    private boolean mAndroidPayShippingAddressRequired;
    private boolean mAndroidPayPhoneNumberRequired;
    private boolean mAndroidPayEnabled = true;
    private boolean mGooglePaymentEnabled = true;
    private boolean mMaskCardNumber = false;
    private boolean mMaskSecurityCode = false;
    private boolean mVaultManagerEnabled = false;
    private ArrayList<CountrySpecification> mAndroidAllowedCountriesForShipping = new ArrayList();
    private List<String> mPayPalAdditionalScopes;
    private boolean mPayPalEnabled = true;
    private boolean mVenmoEnabled = true;
    private int mCardholderNameStatus = 0;
    public static final Parcelable.Creator<DropInRequest> CREATOR = new Parcelable.Creator<DropInRequest>(){

        public DropInRequest createFromParcel(Parcel source) {
            return new DropInRequest(source);
        }

        public DropInRequest[] newArray(int size) {
            return new DropInRequest[size];
        }
    };

    public DropInRequest() {
    }

    public DropInRequest clientToken(String clientToken) {
        this.mAuthorization = clientToken;
        return this;
    }

    public DropInRequest tokenizationKey(String tokenizationKey) {
        this.mAuthorization = tokenizationKey;
        return this;
    }

    public DropInRequest amount(String amount) {
        this.mAmount = amount;
        return this;
    }

    public DropInRequest collectDeviceData(boolean collectDeviceData) {
        this.mCollectDeviceData = collectDeviceData;
        return this;
    }

    public DropInRequest googlePaymentRequest(GooglePaymentRequest request) {
        this.mGooglePaymentRequest = request;
        return this;
    }

    public DropInRequest paypalRequest(PayPalRequest request) {
        this.mPayPalRequest = request;
        return this;
    }

    @Deprecated
    public DropInRequest androidPayCart(Cart cart) {
        this.mAndroidPayCart = cart;
        return this;
    }

    @Deprecated
    public DropInRequest androidPayShippingAddressRequired(boolean shippingAddressRequired) {
        this.mAndroidPayShippingAddressRequired = shippingAddressRequired;
        return this;
    }

    @Deprecated
    public DropInRequest androidPayPhoneNumberRequired(boolean phoneNumberRequired) {
        this.mAndroidPayPhoneNumberRequired = phoneNumberRequired;
        return this;
    }

    @Deprecated
    public DropInRequest androidPayAllowedCountriesForShipping(String ... countryCodes) {
        this.mAndroidAllowedCountriesForShipping.clear();
        for (String countryCode : countryCodes) {
            this.mAndroidAllowedCountriesForShipping.add(new CountrySpecification(countryCode));
        }
        return this;
    }

    public DropInRequest disableAndroidPay() {
        this.mAndroidPayEnabled = false;
        return this;
    }

    public DropInRequest disableGooglePayment() {
        this.mGooglePaymentEnabled = false;
        return this;
    }

    public DropInRequest paypalAdditionalScopes(List<String> additionalScopes) {
        this.mPayPalAdditionalScopes = additionalScopes;
        return this;
    }

    public DropInRequest disablePayPal() {
        this.mPayPalEnabled = false;
        return this;
    }

    public DropInRequest disableVenmo() {
        this.mVenmoEnabled = false;
        return this;
    }

    public DropInRequest requestThreeDSecureVerification(boolean requestThreeDSecure) {
        this.mRequestThreeDSecureVerification = requestThreeDSecure;
        return this;
    }

    public DropInRequest maskCardNumber(boolean maskCardNumber) {
        this.mMaskCardNumber = maskCardNumber;
        return this;
    }

    public DropInRequest maskSecurityCode(boolean maskSecurityCode) {
        this.mMaskSecurityCode = maskSecurityCode;
        return this;
    }

    public DropInRequest vaultManager(boolean vaultManager) {
        this.mVaultManagerEnabled = vaultManager;
        return this;
    }

    public DropInRequest cardholderNameStatus(int fieldStatus) {
        this.mCardholderNameStatus = fieldStatus;
        return this;
    }

    public Intent getIntent(Context context) {
        return new Intent(context, DropInActivity.class).putExtra(EXTRA_CHECKOUT_REQUEST, (Parcelable)this);
    }

    String getAuthorization() {
        return this.mAuthorization;
    }

    String getAmount() {
        return this.mAmount;
    }

    boolean shouldCollectDeviceData() {
        return this.mCollectDeviceData;
    }

    Cart getAndroidPayCart() throws NoClassDefFoundError {
        return this.mAndroidPayCart;
    }

    boolean isAndroidPayShippingAddressRequired() {
        return this.mAndroidPayShippingAddressRequired;
    }

    boolean isAndroidPayPhoneNumberRequired() {
        return this.mAndroidPayPhoneNumberRequired;
    }

    public boolean isAndroidPayEnabled() {
        return this.mAndroidPayEnabled;
    }

    ArrayList<CountrySpecification> getAndroidPayAllowedCountriesForShipping() {
        return this.mAndroidAllowedCountriesForShipping;
    }

    List<String> getPayPalAdditionalScopes() {
        return this.mPayPalAdditionalScopes;
    }

    public boolean isPayPalEnabled() {
        return this.mPayPalEnabled;
    }

    public PayPalRequest getPayPalRequest() {
        return this.mPayPalRequest;
    }

    public boolean isVenmoEnabled() {
        return this.mVenmoEnabled;
    }

    public GooglePaymentRequest getGooglePaymentRequest() {
        return this.mGooglePaymentRequest;
    }

    public boolean isGooglePaymentEnabled() {
        return this.mGooglePaymentEnabled;
    }

    boolean shouldRequestThreeDSecureVerification() {
        return this.mRequestThreeDSecureVerification;
    }

    boolean shouldMaskCardNumber() {
        return this.mMaskCardNumber;
    }

    boolean shouldMaskSecurityCode() {
        return this.mMaskSecurityCode;
    }

    boolean isVaultManagerEnabled() {
        return this.mVaultManagerEnabled;
    }

    public int getCardholderNameStatus() {
        return this.mCardholderNameStatus;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mAuthorization);
        dest.writeString(this.mAmount);
        dest.writeByte(this.mCollectDeviceData ? (byte)1 : 0);
        try {
            Cart.class.getClassLoader();
            dest.writeParcelable((Parcelable)this.mAndroidPayCart, 0);
            dest.writeByte(this.mAndroidPayShippingAddressRequired ? (byte)1 : 0);
            dest.writeByte(this.mAndroidPayPhoneNumberRequired ? (byte)1 : 0);
            dest.writeTypedList(this.mAndroidAllowedCountriesForShipping);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        dest.writeParcelable((Parcelable)this.mGooglePaymentRequest, 0);
        dest.writeByte(this.mGooglePaymentEnabled ? (byte)1 : 0);
        dest.writeByte(this.mAndroidPayEnabled ? (byte)1 : 0);
        dest.writeParcelable((Parcelable)this.mPayPalRequest, 0);
        dest.writeStringList(this.mPayPalAdditionalScopes);
        dest.writeByte(this.mPayPalEnabled ? (byte)1 : 0);
        dest.writeByte(this.mVenmoEnabled ? (byte)1 : 0);
        dest.writeByte(this.mRequestThreeDSecureVerification ? (byte)1 : 0);
        dest.writeByte(this.mMaskCardNumber ? (byte)1 : 0);
        dest.writeByte(this.mMaskSecurityCode ? (byte)1 : 0);
        dest.writeByte(this.mVaultManagerEnabled ? (byte)1 : 0);
        dest.writeInt(this.mCardholderNameStatus);
    }

    protected DropInRequest(Parcel in) {
        this.mAuthorization = in.readString();
        this.mAmount = in.readString();
        this.mCollectDeviceData = in.readByte() != 0;
        try {
            this.mAndroidPayCart = (Cart)in.readParcelable(Cart.class.getClassLoader());
            this.mAndroidPayShippingAddressRequired = in.readByte() != 0;
            this.mAndroidPayPhoneNumberRequired = in.readByte() != 0;
            in.readTypedList(this.mAndroidAllowedCountriesForShipping, CountrySpecification.CREATOR);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.mGooglePaymentRequest = (GooglePaymentRequest)in.readParcelable(GooglePaymentRequest.class.getClassLoader());
        this.mGooglePaymentEnabled = in.readByte() != 0;
        this.mAndroidPayEnabled = in.readByte() != 0;
        this.mPayPalRequest = (PayPalRequest)in.readParcelable(PayPalRequest.class.getClassLoader());
        this.mPayPalAdditionalScopes = in.createStringArrayList();
        this.mPayPalEnabled = in.readByte() != 0;
        this.mVenmoEnabled = in.readByte() != 0;
        this.mRequestThreeDSecureVerification = in.readByte() != 0;
        this.mMaskCardNumber = in.readByte() != 0;
        this.mMaskSecurityCode = in.readByte() != 0;
        this.mVaultManagerEnabled = in.readByte() != 0;
        this.mCardholderNameStatus = in.readInt();
    }
}

