/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.dropin;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.LinearSnapHelper;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.ViewSwitcher;
import com.braintreepayments.api.AndroidPay;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.DataCollector;
import com.braintreepayments.api.GooglePayment;
import com.braintreepayments.api.PayPal;
import com.braintreepayments.api.PaymentMethod;
import com.braintreepayments.api.ThreeDSecure;
import com.braintreepayments.api.Venmo;
import com.braintreepayments.api.dropin.AddCardActivity;
import com.braintreepayments.api.dropin.BaseActivity;
import com.braintreepayments.api.dropin.DropInResult;
import com.braintreepayments.api.dropin.R;
import com.braintreepayments.api.dropin.VaultManagerActivity;
import com.braintreepayments.api.dropin.adapters.SupportedPaymentMethodsAdapter;
import com.braintreepayments.api.dropin.adapters.VaultedPaymentMethodsAdapter;
import com.braintreepayments.api.dropin.interfaces.AnimationFinishedListener;
import com.braintreepayments.api.dropin.utils.PaymentMethodType;
import com.braintreepayments.api.exceptions.AuthenticationException;
import com.braintreepayments.api.exceptions.AuthorizationException;
import com.braintreepayments.api.exceptions.ConfigurationException;
import com.braintreepayments.api.exceptions.DownForMaintenanceException;
import com.braintreepayments.api.exceptions.GoogleApiClientException;
import com.braintreepayments.api.exceptions.InvalidArgumentException;
import com.braintreepayments.api.exceptions.ServerException;
import com.braintreepayments.api.exceptions.UnexpectedException;
import com.braintreepayments.api.exceptions.UpgradeRequiredException;
import com.braintreepayments.api.interfaces.BraintreeCancelListener;
import com.braintreepayments.api.interfaces.BraintreeErrorListener;
import com.braintreepayments.api.interfaces.BraintreeResponseListener;
import com.braintreepayments.api.interfaces.ConfigurationListener;
import com.braintreepayments.api.interfaces.PaymentMethodNonceCreatedListener;
import com.braintreepayments.api.interfaces.PaymentMethodNoncesUpdatedListener;
import com.braintreepayments.api.models.CardNonce;
import com.braintreepayments.api.models.Configuration;
import com.braintreepayments.api.models.GooglePaymentRequest;
import com.braintreepayments.api.models.PayPalRequest;
import com.braintreepayments.api.models.PaymentMethodNonce;
import com.google.android.gms.wallet.Cart;
import java.util.ArrayList;
import java.util.List;

public class DropInActivity
extends BaseActivity
implements ConfigurationListener,
BraintreeCancelListener,
BraintreeErrorListener,
SupportedPaymentMethodsAdapter.PaymentMethodSelectedListener,
PaymentMethodNoncesUpdatedListener,
PaymentMethodNonceCreatedListener {
    public static final String EXTRA_ERROR = "com.braintreepayments.api.dropin.EXTRA_ERROR";
    private static final int ADD_CARD_REQUEST_CODE = 1;
    private static final int DELETE_PAYMENT_METHOD_NONCE_CODE = 2;
    private static final String EXTRA_SHEET_SLIDE_UP_PERFORMED = "com.braintreepayments.api.EXTRA_SHEET_SLIDE_UP_PERFORMED";
    private static final String EXTRA_DEVICE_DATA = "com.braintreepayments.api.EXTRA_DEVICE_DATA";
    static final String EXTRA_PAYMENT_METHOD_NONCES = "com.braintreepayments.api.EXTRA_PAYMENT_METHOD_NONCES";
    private String mDeviceData;
    private View mBottomSheet;
    private ViewSwitcher mLoadingViewSwitcher;
    private TextView mSupportedPaymentMethodsHeader;
    @VisibleForTesting
    protected ListView mSupportedPaymentMethodListView;
    private View mVaultedPaymentMethodsContainer;
    private RecyclerView mVaultedPaymentMethodsView;
    private Button mVaultManagerButton;
    private boolean mSheetSlideUpPerformed;
    private boolean mSheetSlideDownPerformed;
    private boolean mRequestedThreeDSecure;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.bt_drop_in_activity);
        this.mBottomSheet = this.findViewById(R.id.bt_dropin_bottom_sheet);
        this.mLoadingViewSwitcher = (ViewSwitcher)this.findViewById(R.id.bt_loading_view_switcher);
        this.mSupportedPaymentMethodsHeader = (TextView)this.findViewById(R.id.bt_supported_payment_methods_header);
        this.mSupportedPaymentMethodListView = (ListView)this.findViewById(R.id.bt_supported_payment_methods);
        this.mVaultedPaymentMethodsContainer = this.findViewById(R.id.bt_vaulted_payment_methods_wrapper);
        this.mVaultedPaymentMethodsView = (RecyclerView)this.findViewById(R.id.bt_vaulted_payment_methods);
        this.mVaultManagerButton = (Button)this.findViewById(R.id.bt_vault_edit_button);
        this.mVaultedPaymentMethodsView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        new LinearSnapHelper().attachToRecyclerView(this.mVaultedPaymentMethodsView);
        try {
            this.mBraintreeFragment = this.getBraintreeFragment();
        }
        catch (InvalidArgumentException e) {
            this.finish((Exception)((Object)e));
            return;
        }
        if (savedInstanceState != null) {
            this.mSheetSlideUpPerformed = savedInstanceState.getBoolean(EXTRA_SHEET_SLIDE_UP_PERFORMED, false);
            this.mDeviceData = savedInstanceState.getString(EXTRA_DEVICE_DATA);
        }
        this.slideUp();
    }

    public void onConfigurationFetched(Configuration configuration) {
        this.mConfiguration = configuration;
        if (this.mDropInRequest.shouldCollectDeviceData() && TextUtils.isEmpty((CharSequence)this.mDeviceData)) {
            DataCollector.collectDeviceData((BraintreeFragment)this.mBraintreeFragment, (BraintreeResponseListener)new BraintreeResponseListener<String>(){

                public void onResponse(String deviceData) {
                    DropInActivity.this.mDeviceData = deviceData;
                }
            });
        }
        if (this.mDropInRequest.isGooglePaymentEnabled()) {
            GooglePayment.isReadyToPay((BraintreeFragment)this.mBraintreeFragment, (BraintreeResponseListener)new BraintreeResponseListener<Boolean>(){

                public void onResponse(Boolean isReadyToPay) {
                    DropInActivity.this.showSupportedPaymentMethods(isReadyToPay);
                }
            });
        } else if (this.mDropInRequest.isAndroidPayEnabled()) {
            AndroidPay.isReadyToPay((BraintreeFragment)this.mBraintreeFragment, (BraintreeResponseListener)new BraintreeResponseListener<Boolean>(){

                public void onResponse(Boolean isReadyToPay) {
                    DropInActivity.this.showSupportedPaymentMethods(isReadyToPay);
                }
            });
        } else {
            this.showSupportedPaymentMethods(false);
        }
    }

    private void showSupportedPaymentMethods(boolean androidPayOrPayWithGoogleEnabled) {
        SupportedPaymentMethodsAdapter adapter = new SupportedPaymentMethodsAdapter((Context)this, this);
        adapter.setup(this.mConfiguration, this.mDropInRequest, androidPayOrPayWithGoogleEnabled, this.mClientTokenPresent);
        this.mSupportedPaymentMethodListView.setAdapter((ListAdapter)adapter);
        this.mLoadingViewSwitcher.setDisplayedChild(1);
        this.fetchPaymentMethodNonces(false);
    }

    private void handleThreeDSecureFailure() {
        if (this.mRequestedThreeDSecure) {
            this.mRequestedThreeDSecure = false;
            this.fetchPaymentMethodNonces(true);
        }
    }

    public void onCancel(int requestCode) {
        this.handleThreeDSecureFailure();
        this.mLoadingViewSwitcher.setDisplayedChild(1);
    }

    public void onError(final Exception error) {
        this.handleThreeDSecureFailure();
        if (error instanceof GoogleApiClientException) {
            this.showSupportedPaymentMethods(false);
            return;
        }
        this.slideDown(new AnimationFinishedListener(){

            @Override
            public void onAnimationFinished() {
                if (error instanceof AuthenticationException || error instanceof AuthorizationException || error instanceof UpgradeRequiredException) {
                    DropInActivity.this.mBraintreeFragment.sendAnalyticsEvent("sdk.exit.developer-error");
                } else if (error instanceof ConfigurationException) {
                    DropInActivity.this.mBraintreeFragment.sendAnalyticsEvent("sdk.exit.configuration-exception");
                } else if (error instanceof ServerException || error instanceof UnexpectedException) {
                    DropInActivity.this.mBraintreeFragment.sendAnalyticsEvent("sdk.exit.server-error");
                } else if (error instanceof DownForMaintenanceException) {
                    DropInActivity.this.mBraintreeFragment.sendAnalyticsEvent("sdk.exit.server-unavailable");
                } else {
                    DropInActivity.this.mBraintreeFragment.sendAnalyticsEvent("sdk.exit.sdk-error");
                }
                DropInActivity.this.finish(error);
            }
        });
    }

    public void onPaymentMethodNonceCreated(final PaymentMethodNonce paymentMethodNonce) {
        if (!this.mRequestedThreeDSecure && paymentMethodNonce instanceof CardNonce && this.shouldRequestThreeDSecureVerification()) {
            this.mRequestedThreeDSecure = true;
            this.mLoadingViewSwitcher.setDisplayedChild(0);
            ThreeDSecure.performVerification((BraintreeFragment)this.mBraintreeFragment, (String)paymentMethodNonce.getNonce(), (String)this.mDropInRequest.getAmount());
            return;
        }
        this.slideDown(new AnimationFinishedListener(){

            @Override
            public void onAnimationFinished() {
                DropInActivity.this.mBraintreeFragment.sendAnalyticsEvent("sdk.exit.success");
                DropInResult.setLastUsedPaymentMethodType((Context)DropInActivity.this, paymentMethodNonce);
                DropInActivity.this.finish(paymentMethodNonce, DropInActivity.this.mDeviceData);
            }
        });
    }

    @Override
    public void onPaymentMethodSelected(PaymentMethodType type) {
        this.mLoadingViewSwitcher.setDisplayedChild(0);
        switch (type) {
            case PAYPAL: {
                PayPalRequest paypalRequest = this.mDropInRequest.getPayPalRequest();
                if (paypalRequest == null) {
                    paypalRequest = new PayPalRequest();
                }
                if (paypalRequest.getAmount() != null) {
                    PayPal.requestOneTimePayment((BraintreeFragment)this.mBraintreeFragment, (PayPalRequest)paypalRequest);
                    break;
                }
                PayPal.requestBillingAgreement((BraintreeFragment)this.mBraintreeFragment, (PayPalRequest)paypalRequest);
                break;
            }
            case ANDROID_PAY: {
                AndroidPay.requestAndroidPay((BraintreeFragment)this.mBraintreeFragment, (Cart)this.mDropInRequest.getAndroidPayCart(), (boolean)this.mDropInRequest.isAndroidPayShippingAddressRequired(), (boolean)this.mDropInRequest.isAndroidPayPhoneNumberRequired(), this.mDropInRequest.getAndroidPayAllowedCountriesForShipping());
                break;
            }
            case GOOGLE_PAYMENT: {
                GooglePayment.requestPayment((BraintreeFragment)this.mBraintreeFragment, (GooglePaymentRequest)this.mDropInRequest.getGooglePaymentRequest());
                break;
            }
            case PAY_WITH_VENMO: {
                Venmo.authorizeAccount((BraintreeFragment)this.mBraintreeFragment);
                break;
            }
            case UNKNOWN: {
                Intent intent = new Intent((Context)this, AddCardActivity.class).putExtra("com.braintreepayments.api.EXTRA_CHECKOUT_REQUEST", (Parcelable)this.mDropInRequest);
                this.startActivityForResult(intent, 1);
            }
        }
    }

    private void fetchPaymentMethodNonces(final boolean refetch) {
        if (this.mClientTokenPresent) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!DropInActivity.this.isFinishing()) {
                        if (DropInActivity.this.mBraintreeFragment.hasFetchedPaymentMethodNonces() && !refetch) {
                            DropInActivity.this.onPaymentMethodNoncesUpdated(DropInActivity.this.mBraintreeFragment.getCachedPaymentMethodNonces());
                        } else {
                            PaymentMethod.getPaymentMethodNonces((BraintreeFragment)DropInActivity.this.mBraintreeFragment, (boolean)true);
                        }
                    }
                }
            }, (long)this.getResources().getInteger(0x10E0000));
        }
    }

    public void onPaymentMethodNoncesUpdated(List<PaymentMethodNonce> paymentMethodNonces) {
        if (paymentMethodNonces.size() > 0) {
            this.mSupportedPaymentMethodsHeader.setText(R.string.bt_other);
            this.mVaultedPaymentMethodsContainer.setVisibility(0);
            this.mVaultedPaymentMethodsView.setAdapter((RecyclerView.Adapter)new VaultedPaymentMethodsAdapter(this, paymentMethodNonces));
            if (this.mDropInRequest.isVaultManagerEnabled()) {
                this.mVaultManagerButton.setVisibility(0);
            }
        } else {
            this.mSupportedPaymentMethodsHeader.setText(R.string.bt_select_payment_method);
            this.mVaultedPaymentMethodsContainer.setVisibility(8);
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(EXTRA_SHEET_SLIDE_UP_PERFORMED, this.mSheetSlideUpPerformed);
        outState.putString(EXTRA_DEVICE_DATA, this.mDeviceData);
    }

    protected void onActivityResult(int requestCode, final int resultCode, Intent data) {
        this.mLoadingViewSwitcher.setDisplayedChild(0);
        if (resultCode == 0) {
            if (requestCode == 1) {
                this.fetchPaymentMethodNonces(true);
            }
            this.mLoadingViewSwitcher.setDisplayedChild(1);
        } else if (requestCode == 1) {
            Intent response;
            if (resultCode == -1) {
                DropInResult result = (DropInResult)data.getParcelableExtra("com.braintreepayments.api.dropin.EXTRA_DROP_IN_RESULT");
                DropInResult.setLastUsedPaymentMethodType((Context)this, result.getPaymentMethodNonce());
                result.deviceData(this.mDeviceData);
                response = new Intent().putExtra("com.braintreepayments.api.dropin.EXTRA_DROP_IN_RESULT", (Parcelable)result);
            } else {
                response = data;
            }
            this.slideDown(new AnimationFinishedListener(){

                @Override
                public void onAnimationFinished() {
                    DropInActivity.this.setResult(resultCode, response);
                    DropInActivity.this.finish();
                }
            });
        } else if (requestCode == 2) {
            if (resultCode == -1) {
                ArrayList paymentMethodNonces;
                if (data != null && (paymentMethodNonces = data.getParcelableArrayListExtra(EXTRA_PAYMENT_METHOD_NONCES)) != null) {
                    this.onPaymentMethodNoncesUpdated(paymentMethodNonces);
                }
                this.fetchPaymentMethodNonces(true);
            }
            this.mLoadingViewSwitcher.setDisplayedChild(1);
        }
    }

    public void onBackgroundClicked(View v) {
        this.onBackPressed();
    }

    public void onBackPressed() {
        if (!this.mSheetSlideDownPerformed) {
            this.mSheetSlideDownPerformed = true;
            this.mBraintreeFragment.sendAnalyticsEvent("sdk.exit.canceled");
            this.slideDown(new AnimationFinishedListener(){

                @Override
                public void onAnimationFinished() {
                    DropInActivity.this.finish();
                }
            });
        }
    }

    private void slideUp() {
        if (!this.mSheetSlideUpPerformed) {
            this.mBraintreeFragment.sendAnalyticsEvent("appeared");
            this.mSheetSlideUpPerformed = true;
            this.mBottomSheet.startAnimation(AnimationUtils.loadAnimation((Context)this, (int)R.anim.bt_slide_in_up));
        }
    }

    private void slideDown(final AnimationFinishedListener listener) {
        Animation slideOutAnimation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.bt_slide_out_down);
        slideOutAnimation.setFillAfter(true);
        if (listener != null) {
            slideOutAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    listener.onAnimationFinished();
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        }
        this.mBottomSheet.startAnimation(slideOutAnimation);
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0x10A0000, 0x10A0001);
    }

    public void onVaultEditButtonClick(View view) {
        ArrayList parcelableArrayList = new ArrayList(this.mBraintreeFragment.getCachedPaymentMethodNonces());
        Intent intent = new Intent((Context)this, VaultManagerActivity.class).putExtra("com.braintreepayments.api.EXTRA_CHECKOUT_REQUEST", (Parcelable)this.mDropInRequest).putParcelableArrayListExtra(EXTRA_PAYMENT_METHOD_NONCES, parcelableArrayList);
        this.startActivityForResult(intent, 2);
        this.mBraintreeFragment.sendAnalyticsEvent("manager.appeared");
    }
}

