/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.dropin;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.dropin.DropInRequest;
import com.braintreepayments.api.dropin.DropInResult;
import com.braintreepayments.api.exceptions.InvalidArgumentException;
import com.braintreepayments.api.models.Authorization;
import com.braintreepayments.api.models.ClientToken;
import com.braintreepayments.api.models.Configuration;
import com.braintreepayments.api.models.PaymentMethodNonce;
import java.io.Serializable;
import org.json.JSONException;

public class BaseActivity
extends AppCompatActivity {
    static final String EXTRA_CONFIGURATION_DATA = "com.braintreepayments.api.EXTRA_CONFIGURATION_DATA";
    protected DropInRequest mDropInRequest;
    protected BraintreeFragment mBraintreeFragment;
    protected Configuration mConfiguration;
    protected boolean mClientTokenPresent;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            try {
                this.mConfiguration = Configuration.fromJson((String)savedInstanceState.getString(EXTRA_CONFIGURATION_DATA));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        this.mDropInRequest = (DropInRequest)this.getIntent().getParcelableExtra("com.braintreepayments.api.EXTRA_CHECKOUT_REQUEST");
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mConfiguration != null) {
            outState.putString(EXTRA_CONFIGURATION_DATA, this.mConfiguration.toJson());
        }
    }

    protected BraintreeFragment getBraintreeFragment() throws InvalidArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.mDropInRequest.getAuthorization())) {
            throw new InvalidArgumentException("A client token or tokenization key must be specified in the " + DropInRequest.class.getSimpleName());
        }
        try {
            this.mClientTokenPresent = Authorization.fromString((String)this.mDropInRequest.getAuthorization()) instanceof ClientToken;
        }
        catch (InvalidArgumentException e) {
            this.mClientTokenPresent = false;
        }
        return BraintreeFragment.newInstance((Activity)this, (String)this.mDropInRequest.getAuthorization());
    }

    protected boolean shouldRequestThreeDSecureVerification() {
        return this.mDropInRequest.shouldRequestThreeDSecureVerification() && !TextUtils.isEmpty((CharSequence)this.mDropInRequest.getAmount()) && this.mConfiguration.isThreeDSecureEnabled();
    }

    protected void finish(PaymentMethodNonce paymentMethod, String deviceData) {
        DropInResult result = new DropInResult().paymentMethodNonce(paymentMethod).deviceData(deviceData);
        this.setResult(-1, new Intent().putExtra("com.braintreepayments.api.dropin.EXTRA_DROP_IN_RESULT", (Parcelable)result));
        this.finish();
    }

    protected void finish(Exception e) {
        this.setResult(1, new Intent().putExtra("com.braintreepayments.api.dropin.EXTRA_ERROR", (Serializable)e));
        this.finish();
    }
}

