/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.dropin;

import android.app.Activity;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.widget.Toolbar;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ViewSwitcher;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.Card;
import com.braintreepayments.api.ThreeDSecure;
import com.braintreepayments.api.UnionPay;
import com.braintreepayments.api.dropin.BaseActivity;
import com.braintreepayments.api.dropin.R;
import com.braintreepayments.api.dropin.interfaces.AddPaymentUpdateListener;
import com.braintreepayments.api.dropin.view.AddCardView;
import com.braintreepayments.api.dropin.view.EditCardView;
import com.braintreepayments.api.dropin.view.EnrollmentCardView;
import com.braintreepayments.api.exceptions.AuthenticationException;
import com.braintreepayments.api.exceptions.AuthorizationException;
import com.braintreepayments.api.exceptions.ConfigurationException;
import com.braintreepayments.api.exceptions.DownForMaintenanceException;
import com.braintreepayments.api.exceptions.ErrorWithResponse;
import com.braintreepayments.api.exceptions.InvalidArgumentException;
import com.braintreepayments.api.exceptions.ServerException;
import com.braintreepayments.api.exceptions.UnexpectedException;
import com.braintreepayments.api.exceptions.UpgradeRequiredException;
import com.braintreepayments.api.interfaces.BraintreeCancelListener;
import com.braintreepayments.api.interfaces.BraintreeErrorListener;
import com.braintreepayments.api.interfaces.ConfigurationListener;
import com.braintreepayments.api.interfaces.PaymentMethodNonceCreatedListener;
import com.braintreepayments.api.interfaces.UnionPayListener;
import com.braintreepayments.api.models.CardBuilder;
import com.braintreepayments.api.models.Configuration;
import com.braintreepayments.api.models.PaymentMethodNonce;
import com.braintreepayments.api.models.UnionPayCapabilities;
import com.braintreepayments.api.models.UnionPayCardBuilder;
import com.braintreepayments.cardform.view.CardForm;

public class AddCardActivity
extends BaseActivity
implements ConfigurationListener,
AddPaymentUpdateListener,
PaymentMethodNonceCreatedListener,
BraintreeErrorListener,
BraintreeCancelListener,
UnionPayListener {
    private static final String EXTRA_STATE = "com.braintreepayments.api.EXTRA_STATE";
    private static final String EXTRA_ENROLLMENT_ID = "com.braintreepayments.api.EXTRA_ENROLLMENT_ID";
    private static final int LOADING = 1;
    private static final int CARD_ENTRY = 2;
    private static final int DETAILS_ENTRY = 3;
    private static final int ENROLLMENT_ENTRY = 4;
    private ActionBar mActionBar;
    private ViewSwitcher mViewSwitcher;
    private AddCardView mAddCardView;
    private EditCardView mEditCardView;
    private EnrollmentCardView mEnrollmentCardView;
    private boolean mUnionPayCard;
    private boolean mUnionPayDebitCard;
    private String mEnrollmentId;
    private int mState = 2;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.bt_add_card_activity);
        this.mViewSwitcher = (ViewSwitcher)this.findViewById(R.id.bt_loading_view_switcher);
        this.mAddCardView = (AddCardView)this.findViewById(R.id.bt_add_card_view);
        this.mEditCardView = (EditCardView)this.findViewById(R.id.bt_edit_card_view);
        this.mEnrollmentCardView = (EnrollmentCardView)this.findViewById(R.id.bt_enrollment_card_view);
        this.mEnrollmentCardView.setup((Activity)this);
        this.setSupportActionBar((Toolbar)this.findViewById(R.id.bt_toolbar));
        this.mActionBar = this.getSupportActionBar();
        this.mActionBar.setDisplayHomeAsUpEnabled(true);
        this.mAddCardView.setAddPaymentUpdatedListener(this);
        this.mEditCardView.setAddPaymentUpdatedListener(this);
        this.mEnrollmentCardView.setAddPaymentUpdatedListener(this);
        if (savedInstanceState != null) {
            int state;
            this.mState = state = savedInstanceState.getInt(EXTRA_STATE);
            this.mEnrollmentId = savedInstanceState.getString(EXTRA_ENROLLMENT_ID);
        } else {
            this.mState = 2;
        }
        this.mAddCardView.getCardForm().maskCardNumber(this.mDropInRequest.shouldMaskCardNumber());
        this.mEditCardView.getCardForm().maskCardNumber(this.mDropInRequest.shouldMaskCardNumber());
        this.mEditCardView.getCardForm().maskCvv(this.mDropInRequest.shouldMaskSecurityCode());
        this.enterState(1);
        try {
            this.mBraintreeFragment = this.getBraintreeFragment();
        }
        catch (InvalidArgumentException e) {
            this.finish((Exception)((Object)e));
            return;
        }
        this.mBraintreeFragment.sendAnalyticsEvent("card.selected");
    }

    public void onConfigurationFetched(Configuration configuration) {
        this.mConfiguration = configuration;
        this.mAddCardView.setup((Activity)this, configuration, this.mClientTokenPresent);
        this.mEditCardView.setup((Activity)this, configuration, this.mDropInRequest);
        this.setState(1, this.mState);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(EXTRA_STATE, this.mState);
        outState.putString(EXTRA_ENROLLMENT_ID, this.mEnrollmentId);
    }

    @Override
    public void onPaymentUpdated(View v) {
        this.setState(this.mState, this.determineNextState(v));
    }

    private void setState(int currentState, int nextState) {
        if (currentState == nextState) {
            return;
        }
        this.leaveState(currentState);
        this.enterState(nextState);
        this.mState = nextState;
    }

    private void leaveState(int state) {
        switch (state) {
            case 1: {
                this.mViewSwitcher.setDisplayedChild(1);
                break;
            }
            case 2: {
                this.mAddCardView.setVisibility(8);
                break;
            }
            case 3: {
                this.mEditCardView.setVisibility(8);
                break;
            }
            case 4: {
                this.mEnrollmentCardView.setVisibility(8);
            }
        }
    }

    private void enterState(int state) {
        switch (state) {
            case 1: {
                this.mActionBar.setTitle(R.string.bt_card_details);
                this.mViewSwitcher.setDisplayedChild(0);
                break;
            }
            case 2: {
                this.mActionBar.setTitle(R.string.bt_card_details);
                this.mAddCardView.setVisibility(0);
                break;
            }
            case 3: {
                this.mActionBar.setTitle(R.string.bt_card_details);
                this.mEditCardView.setCardNumber(this.mAddCardView.getCardForm().getCardNumber());
                this.mEditCardView.useUnionPay((Activity)this, this.mUnionPayCard, this.mUnionPayDebitCard);
                this.mEditCardView.setVisibility(0);
                break;
            }
            case 4: {
                this.mActionBar.setTitle(R.string.bt_confirm_enrollment);
                this.mEnrollmentCardView.setPhoneNumber(PhoneNumberUtils.formatNumber((String)(this.mEditCardView.getCardForm().getCountryCode() + this.mEditCardView.getCardForm().getMobileNumber())));
                this.mEnrollmentCardView.setVisibility(0);
            }
        }
    }

    @Override
    public void onBackRequested(View v) {
        if (v.getId() == this.mEditCardView.getId()) {
            this.setState(3, 2);
        } else if (v.getId() == this.mEnrollmentCardView.getId()) {
            this.setState(4, 3);
        }
    }

    private int determineNextState(View v) {
        int nextState = this.mState;
        if (v.getId() == this.mAddCardView.getId() && !TextUtils.isEmpty((CharSequence)this.mAddCardView.getCardForm().getCardNumber())) {
            if (!this.mConfiguration.getUnionPay().isEnabled() || !this.mClientTokenPresent) {
                this.mEditCardView.useUnionPay((Activity)this, false, false);
                nextState = 3;
            } else {
                UnionPay.fetchCapabilities((BraintreeFragment)this.mBraintreeFragment, (String)this.mAddCardView.getCardForm().getCardNumber());
            }
        } else if (v.getId() == this.mEditCardView.getId()) {
            if (this.mUnionPayCard) {
                if (TextUtils.isEmpty((CharSequence)this.mEnrollmentId)) {
                    this.enrollUnionPayCard();
                } else {
                    nextState = 4;
                }
            } else {
                nextState = this.mState;
                this.createCard();
            }
        } else if (v.getId() == this.mEnrollmentCardView.getId()) {
            nextState = this.mState;
            if (this.mEnrollmentCardView.hasFailedEnrollment()) {
                this.enrollUnionPayCard();
            } else {
                this.createCard();
            }
        }
        return nextState;
    }

    private void enrollUnionPayCard() {
        UnionPayCardBuilder unionPayCardBuilder = ((UnionPayCardBuilder)((UnionPayCardBuilder)((UnionPayCardBuilder)((UnionPayCardBuilder)((UnionPayCardBuilder)new UnionPayCardBuilder().cardNumber(this.mEditCardView.getCardForm().getCardNumber())).expirationMonth(this.mEditCardView.getCardForm().getExpirationMonth())).expirationYear(this.mEditCardView.getCardForm().getExpirationYear())).cvv(this.mEditCardView.getCardForm().getCvv())).postalCode(this.mEditCardView.getCardForm().getPostalCode())).mobileCountryCode(this.mEditCardView.getCardForm().getCountryCode()).mobilePhoneNumber(this.mEditCardView.getCardForm().getMobileNumber());
        UnionPay.enroll((BraintreeFragment)this.mBraintreeFragment, (UnionPayCardBuilder)unionPayCardBuilder);
    }

    protected void createCard() {
        CardForm cardForm = this.mEditCardView.getCardForm();
        if (this.mUnionPayCard) {
            UnionPayCardBuilder unionPayCardBuilder = ((UnionPayCardBuilder)((UnionPayCardBuilder)((UnionPayCardBuilder)((UnionPayCardBuilder)((UnionPayCardBuilder)((UnionPayCardBuilder)new UnionPayCardBuilder().cardholderName(cardForm.getCardholderName())).cardNumber(cardForm.getCardNumber())).expirationMonth(cardForm.getExpirationMonth())).expirationYear(cardForm.getExpirationYear())).cvv(cardForm.getCvv())).postalCode(cardForm.getPostalCode())).mobileCountryCode(cardForm.getCountryCode()).mobilePhoneNumber(cardForm.getMobileNumber()).enrollmentId(this.mEnrollmentId).smsCode(this.mEnrollmentCardView.getSmsCode());
            UnionPay.tokenize((BraintreeFragment)this.mBraintreeFragment, (UnionPayCardBuilder)unionPayCardBuilder);
        } else {
            CardBuilder cardBuilder = (CardBuilder)((CardBuilder)((CardBuilder)((CardBuilder)((CardBuilder)((CardBuilder)((CardBuilder)new CardBuilder().cardholderName(cardForm.getCardholderName())).cardNumber(cardForm.getCardNumber())).expirationMonth(cardForm.getExpirationMonth())).expirationYear(cardForm.getExpirationYear())).cvv(cardForm.getCvv())).postalCode(cardForm.getPostalCode())).validate(this.mClientTokenPresent);
            if (this.shouldRequestThreeDSecureVerification()) {
                ThreeDSecure.performVerification((BraintreeFragment)this.mBraintreeFragment, (CardBuilder)cardBuilder, (String)this.mDropInRequest.getAmount());
            } else {
                Card.tokenize((BraintreeFragment)this.mBraintreeFragment, (CardBuilder)cardBuilder);
            }
        }
    }

    public void onPaymentMethodNonceCreated(PaymentMethodNonce paymentMethod) {
        this.mBraintreeFragment.sendAnalyticsEvent("sdk.exit.success");
        this.finish(paymentMethod, null);
    }

    public void onCapabilitiesFetched(UnionPayCapabilities capabilities) {
        this.mUnionPayCard = capabilities.isUnionPay();
        this.mUnionPayDebitCard = capabilities.isDebit();
        if (this.mUnionPayCard && !capabilities.isSupported()) {
            this.mAddCardView.showCardNotSupportedError();
        } else {
            this.setState(this.mState, 3);
        }
    }

    public void onSmsCodeSent(String enrollmentId, boolean smsRequired) {
        this.mEnrollmentId = enrollmentId;
        if (smsRequired && this.mState != 4) {
            this.onPaymentUpdated((View)this.mEditCardView);
        } else {
            this.createCard();
        }
    }

    public void onCancel(int requestCode) {
        if (requestCode == 13487) {
            this.mEditCardView.setVisibility(0);
        }
    }

    public void onError(Exception error) {
        if (error instanceof ErrorWithResponse) {
            ErrorWithResponse errorResponse = (ErrorWithResponse)error;
            if (this.mEnrollmentCardView.isEnrollmentError(errorResponse)) {
                this.setState(this.mState, 4);
                this.mEnrollmentCardView.setErrors((ErrorWithResponse)error);
            } else {
                this.mEditCardView.setErrors((ErrorWithResponse)error);
                if (this.mAddCardView.isCardNumberError(errorResponse)) {
                    this.mAddCardView.setErrors((ErrorWithResponse)error);
                    this.setState(this.mState, 2);
                } else {
                    this.setState(this.mState, 3);
                }
            }
        } else {
            if (error instanceof AuthenticationException || error instanceof AuthorizationException || error instanceof UpgradeRequiredException) {
                this.mBraintreeFragment.sendAnalyticsEvent("sdk.exit.developer-error");
            } else if (error instanceof ConfigurationException) {
                this.mBraintreeFragment.sendAnalyticsEvent("sdk.exit.configuration-exception");
            } else if (error instanceof ServerException || error instanceof UnexpectedException) {
                this.mBraintreeFragment.sendAnalyticsEvent("sdk.exit.server-error");
            } else if (error instanceof DownForMaintenanceException) {
                this.mBraintreeFragment.sendAnalyticsEvent("sdk.exit.server-unavailable");
            }
            this.finish(error);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        super.onCreateOptionsMenu(menu2);
        if (this.mAddCardView.getCardForm().isCardScanningAvailable()) {
            this.getMenuInflater().inflate(R.menu.bt_card_io, menu2);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.bt_card_io_button) {
            this.mAddCardView.getCardForm().scanCard((Activity)this);
            return true;
        }
        if (item.getItemId() == 16908332) {
            this.setResult(0);
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}

