/*
 * Decompiled with CFR 0.152.
 */
package com.bol.reflection;

import com.bol.reflection.Node;
import com.bol.secure.Encrypted;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ReflectionCache {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionCache.class);
    private static Map<Class, List<Node>> cyclicClassReference = new HashMap<Class, List<Node>>();

    public static List<Node> processDocument(Class objectClass) {
        List<Node> result = cyclicClassReference.get(objectClass);
        if (result != null) {
            LOG.trace("cyclic reference found; {} is already mapped", (Object)objectClass.getName());
            return result;
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        cyclicClassReference.put(objectClass, nodes);
        ReflectionUtils.doWithFields((Class)objectClass, field -> {
            String fieldName = field.getName();
            try {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) {
                    return;
                }
                if (field.isAnnotationPresent(Encrypted.class)) {
                    nodes.add(new Node(fieldName, Collections.emptyList(), Node.Type.DIRECT));
                } else {
                    Class<?> fieldType = field.getType();
                    Type fieldGenericType = field.getGenericType();
                    if (Collection.class.isAssignableFrom(fieldType)) {
                        List<Node> children = ReflectionCache.processParameterizedTypes(fieldGenericType);
                        if (!children.isEmpty()) {
                            nodes.add(new Node(fieldName, ReflectionCache.unwrap(children), Node.Type.LIST));
                        }
                    } else if (Map.class.isAssignableFrom(fieldType)) {
                        List<Node> children = ReflectionCache.processParameterizedTypes(fieldGenericType);
                        if (!children.isEmpty()) {
                            nodes.add(new Node(fieldName, ReflectionCache.unwrap(children), Node.Type.MAP));
                        }
                    } else {
                        List<Node> children = ReflectionCache.processDocument(fieldType);
                        if (!children.isEmpty()) {
                            nodes.add(new Node(fieldName, children, Node.Type.DOCUMENT));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(objectClass.getName() + "." + fieldName, e);
            }
        });
        return nodes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static List<Node> processParameterizedTypes(Type type) {
        if (type instanceof Class) {
            List<Node> children = ReflectionCache.processDocument((Class)type);
            if (children.isEmpty()) return Collections.emptyList();
            return Collections.singletonList(new Node(null, children, Node.Type.DOCUMENT));
        }
        if (!(type instanceof ParameterizedType)) throw new IllegalArgumentException("Unknown reflective type class " + type.getClass());
        ParameterizedType subType = (ParameterizedType)type;
        Class rawType = (Class)subType.getRawType();
        if (Collection.class.isAssignableFrom(rawType)) {
            List<Node> children = ReflectionCache.processParameterizedTypes(subType.getActualTypeArguments()[0]);
            if (children.isEmpty()) return Collections.emptyList();
            return Collections.singletonList(new Node(null, children, Node.Type.LIST));
        }
        if (!Map.class.isAssignableFrom(rawType)) throw new IllegalArgumentException("Unknown reflective raw type class " + rawType.getClass());
        List<Node> children = ReflectionCache.processParameterizedTypes(subType.getActualTypeArguments()[1]);
        if (children.isEmpty()) return Collections.emptyList();
        return Collections.singletonList(new Node(null, children, Node.Type.MAP));
    }

    static List<Node> unwrap(List<Node> result) {
        if (result.size() != 1) {
            return result;
        }
        Node node = result.get(0);
        if (node.fieldName != null) {
            return result;
        }
        return node.children;
    }
}

