/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.repository;

import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.spi.type.BasicDirtyTracker;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import javax.persistence.EntityManager;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;

public class EntityViewReplacingMethodInterceptor
implements MethodInterceptor,
RepositoryProxyPostProcessor {
    private final EntityManager em;
    private final EntityViewManager evm;

    public EntityViewReplacingMethodInterceptor(EntityManager em, EntityViewManager evm) {
        this.em = em;
        this.evm = evm;
    }

    public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
        factory.addAdvice((Advice)this);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object o = invocation.proceed();
        if (invocation.getMethod().getName().startsWith("save")) {
            Object[] arguments = invocation.getArguments();
            if (arguments.length == 1) {
                arguments[0] = this.convertToEntity(arguments[0]);
            } else {
                return this.convertToEntity(o);
            }
        }
        return o;
    }

    private Object convertToEntity(Object entityOrView) {
        if (entityOrView instanceof BasicDirtyTracker) {
            EntityViewProxy view = (EntityViewProxy)entityOrView;
            return this.evm.getEntityReference(this.em, (Object)view);
        }
        return entityOrView;
    }
}

