/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.base.query;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.From;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.PaginatedTypedQuery;
import com.blazebit.persistence.criteria.BlazeCriteria;
import com.blazebit.persistence.criteria.BlazeCriteriaBuilder;
import com.blazebit.persistence.criteria.BlazeCriteriaQuery;
import com.blazebit.persistence.spring.data.base.EntityViewSortUtil;
import com.blazebit.persistence.spring.data.base.query.EntityViewAwareJpaQueryMethod;
import com.blazebit.persistence.spring.data.base.query.JpaParameters;
import com.blazebit.persistence.spring.data.base.query.ParameterBinder;
import com.blazebit.persistence.spring.data.base.query.ParameterMetadataProvider;
import com.blazebit.persistence.spring.data.repository.BlazeSpecification;
import com.blazebit.persistence.spring.data.repository.EntityViewSettingProcessor;
import com.blazebit.persistence.spring.data.repository.KeysetPageable;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.EntityViewSetting;
import com.blazebit.persistence.view.Sorter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.FixedJpaCountQueryCreator;
import org.springframework.data.jpa.repository.query.FixedJpaQueryCreator;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.PartTree;

public abstract class AbstractPartTreeBlazePersistenceQuery
extends AbstractJpaQuery {
    private static final String QUERY_PATTERN = "find|read|get|query|stream";
    private static final String COUNT_PATTERN = "count";
    private static final String EXISTS_PATTERN = "exists";
    private static final String DELETE_PATTERN = "delete|remove";
    private static final Pattern PREFIX_TEMPLATE = Pattern.compile("^(find|read|get|query|stream|count|exists|delete|remove)((\\p{Lu}.*?))??By");
    private final EntityViewAwareJpaQueryMethod method;
    private final Class<?> domainClass;
    private final Class<?> entityViewClass;
    private final PartTree tree;
    private final JpaParameters parameters;
    private final QueryPreparer query;
    private final CriteriaBuilderFactory cbf;
    private final Object escape;
    protected final EntityViewManager evm;

    public AbstractPartTreeBlazePersistenceQuery(EntityViewAwareJpaQueryMethod method, EntityManager em, PersistenceProvider persistenceProvider, Object escape, CriteriaBuilderFactory cbf, EntityViewManager evm) {
        super((JpaQueryMethod)method, em);
        this.method = method;
        this.escape = escape;
        this.cbf = cbf;
        this.evm = evm;
        this.entityViewClass = method.getEntityViewClass();
        this.domainClass = method.getEntityInformation().getJavaType();
        this.parameters = method.getJpaParameters();
        String methodName = method.getName();
        boolean skipMethodNamePredicateMatching = !PREFIX_TEMPLATE.matcher(methodName).find();
        String source = skipMethodNamePredicateMatching ? "" : methodName;
        this.tree = new PartTree(source, this.domainClass);
        boolean hasEntityViewSettingProcessorParameter = this.parameters.hasEntityViewSettingProcessorParameter();
        boolean hasSpecificationParameter = this.parameters.hasSpecificationParameter();
        boolean hasCriteriaBuilderProcessorParameter = this.parameters.hasBlazeSpecificationParameter();
        boolean recreateQueries = this.parameters.hasDynamicProjection() || this.parameters.potentiallySortsDynamically() || this.entityViewClass != null || skipMethodNamePredicateMatching || hasEntityViewSettingProcessorParameter || hasSpecificationParameter || hasCriteriaBuilderProcessorParameter;
        this.query = this.isCountProjection(this.tree) ? new CountQueryPreparer(persistenceProvider, recreateQueries) : new QueryPreparer(persistenceProvider, recreateQueries);
    }

    protected abstract ParameterMetadataProvider createParameterMetadataProvider(javax.persistence.criteria.CriteriaBuilder var1, ParametersParameterAccessor var2, PersistenceProvider var3, Object var4);

    protected abstract ParameterMetadataProvider createParameterMetadataProvider(javax.persistence.criteria.CriteriaBuilder var1, JpaParameters var2, PersistenceProvider var3, Object var4);

    protected abstract boolean isCountProjection(PartTree var1);

    protected boolean isDelete() {
        return this.isDelete(this.tree);
    }

    protected boolean isExists() {
        return this.isExists(this.tree);
    }

    protected abstract boolean isDelete(PartTree var1);

    protected abstract boolean isExists(PartTree var1);

    protected abstract int getOffset(Pageable var1);

    protected abstract int getLimit(Pageable var1);

    protected abstract ParameterBinder createCriteriaQueryParameterBinder(JpaParameters var1, Object[] var2, List<ParameterMetadataProvider.ParameterMetadata<?>> var3);

    protected abstract Map<String, Object> tryGetFetchGraphHints(JpaEntityGraph var1, Class<?> var2);

    public Query doCreateQuery(Object[] values) {
        return this.query.createQuery(values);
    }

    public Query createPaginatedQuery(Object[] values, boolean withCount) {
        Map<String, Object> hints;
        JpaEntityGraph entityGraph;
        Query paginatedQuery = this.query.createPaginatedQuery(values, withCount);
        if (this.method.getLockModeType() != null) {
            paginatedQuery.setLockMode(this.method.getLockModeType());
        }
        if ((entityGraph = this.method.getEntityGraph()) != null) {
            hints = this.tryGetFetchGraphHints(this.method.getEntityGraph(), this.getQueryMethod().getEntityInformation().getJavaType());
            for (Map.Entry<String, Object> entry : hints.entrySet()) {
                paginatedQuery.setHint(entry.getKey(), entry.getValue());
            }
        }
        if (!(hints = this.method.getHints()).isEmpty()) {
            for (Map.Entry<String, Object> entry : hints.entrySet()) {
                paginatedQuery.setHint(entry.getKey(), entry.getValue());
            }
        }
        return paginatedQuery;
    }

    public TypedQuery<Long> doCreateCountQuery(Object[] values) {
        throw new UnsupportedOperationException();
    }

    private class CountQueryPreparer
    extends QueryPreparer {
        public CountQueryPreparer(PersistenceProvider persistenceProvider, boolean recreateQueries) {
            super(persistenceProvider, recreateQueries);
        }

        @Override
        protected FixedJpaQueryCreator createCreator(ParametersParameterAccessor accessor, PersistenceProvider persistenceProvider) {
            EntityManager entityManager = AbstractPartTreeBlazePersistenceQuery.this.getEntityManager();
            javax.persistence.criteria.CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            ParameterMetadataProvider provider = accessor == null ? AbstractPartTreeBlazePersistenceQuery.this.createParameterMetadataProvider(builder, AbstractPartTreeBlazePersistenceQuery.this.parameters, persistenceProvider, AbstractPartTreeBlazePersistenceQuery.this.escape) : AbstractPartTreeBlazePersistenceQuery.this.createParameterMetadataProvider(builder, accessor, persistenceProvider, AbstractPartTreeBlazePersistenceQuery.this.escape);
            return new FixedJpaCountQueryCreator(AbstractPartTreeBlazePersistenceQuery.this.tree, AbstractPartTreeBlazePersistenceQuery.this.domainClass, builder, provider);
        }

        @Override
        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query) {
            return binder.bind(query);
        }

        @Override
        protected TypedQuery<?> createQuery0(CriteriaQuery<?> criteriaQuery, Object[] values) {
            return AbstractPartTreeBlazePersistenceQuery.this.getEntityManager().createQuery(criteriaQuery);
        }

        @Override
        protected CriteriaQuery<?> invokeQueryCreator(FixedJpaQueryCreator creator, Sort sort) {
            return (CriteriaQuery)creator.createQuery();
        }
    }

    private class QueryPreparer {
        private final CriteriaQuery<?> cachedCriteriaQuery;
        private final List<ParameterMetadataProvider.ParameterMetadata<?>> expressions;
        private final PersistenceProvider persistenceProvider;

        public QueryPreparer(PersistenceProvider persistenceProvider, boolean recreateQueries) {
            this.persistenceProvider = persistenceProvider;
            FixedJpaQueryCreator creator = this.createCreator(null, persistenceProvider);
            this.cachedCriteriaQuery = recreateQueries ? null : this.invokeQueryCreator(creator, null);
            this.expressions = recreateQueries ? null : creator.getParameterExpressions();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TypedQuery<?> createQuery(CriteriaQuery<?> criteriaQuery, Object[] values) {
            if (this.cachedCriteriaQuery != null) {
                CriteriaQuery<?> criteriaQuery2 = this.cachedCriteriaQuery;
                synchronized (criteriaQuery2) {
                    return this.createQuery0(criteriaQuery, values);
                }
            }
            return this.createQuery0(criteriaQuery, values);
        }

        protected TypedQuery<?> createQuery0(CriteriaQuery<?> criteriaQuery, Object[] values) {
            this.processSpecification(criteriaQuery, values);
            CriteriaBuilder cb = ((BlazeCriteriaQuery)criteriaQuery).createCriteriaBuilder(AbstractPartTreeBlazePersistenceQuery.this.getEntityManager());
            this.processBlazeSpecification(cb, values);
            Class entityViewClass = AbstractPartTreeBlazePersistenceQuery.this.entityViewClass;
            if (AbstractPartTreeBlazePersistenceQuery.this.parameters.hasDynamicProjection()) {
                entityViewClass = (Class)values[AbstractPartTreeBlazePersistenceQuery.this.parameters.getDynamicProjectionIndex()];
                if (AbstractPartTreeBlazePersistenceQuery.this.evm.getMetamodel().managedView(entityViewClass) == null) {
                    entityViewClass = null;
                } else {
                    values[((AbstractPartTreeBlazePersistenceQuery)AbstractPartTreeBlazePersistenceQuery.this).parameters.getDynamicProjectionIndex()] = null;
                }
            }
            if (entityViewClass == null) {
                return cb.getQuery();
            }
            EntityViewSetting setting = EntityViewSetting.create((Class)entityViewClass);
            setting = this.processSetting(setting, values);
            HashMap<String, Sorter> settingProcessorAttributeSorters = new HashMap<String, Sorter>(setting.getAttributeSorters());
            setting.getAttributeSorters().clear();
            FullQueryBuilder fqb = AbstractPartTreeBlazePersistenceQuery.this.evm.applySetting(setting, cb);
            this.processSort(fqb, values, entityViewClass, settingProcessorAttributeSorters);
            return fqb.getQuery();
        }

        Query createPaginatedQuery(Object[] values, boolean withCount) {
            PaginatedTypedQuery jpaQuery;
            CriteriaQuery<?> criteriaQuery = this.cachedCriteriaQuery;
            List<ParameterMetadataProvider.ParameterMetadata<?>> expressions = this.expressions;
            ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)AbstractPartTreeBlazePersistenceQuery.this.parameters, values);
            if (this.cachedCriteriaQuery == null || accessor.hasBindableNullValue()) {
                FixedJpaQueryCreator creator = this.createCreator(accessor, this.persistenceProvider);
                criteriaQuery = this.invokeQueryCreator(creator, this.appliesSortThroughAttributeSorters() ? null : this.getDynamicSort(values));
                expressions = creator.getParameterExpressions();
            }
            this.processSpecification(criteriaQuery, values);
            CriteriaBuilder cb = ((BlazeCriteriaQuery)criteriaQuery).createCriteriaBuilder(AbstractPartTreeBlazePersistenceQuery.this.getEntityManager());
            this.processBlazeSpecification(cb, values);
            ParameterBinder binder = this.getBinder(values, expressions);
            int firstResult = AbstractPartTreeBlazePersistenceQuery.this.getOffset(binder.getPageable());
            int maxResults = AbstractPartTreeBlazePersistenceQuery.this.getLimit(binder.getPageable());
            Class entityViewClass = AbstractPartTreeBlazePersistenceQuery.this.entityViewClass;
            if (AbstractPartTreeBlazePersistenceQuery.this.parameters.hasDynamicProjection()) {
                entityViewClass = (Class)values[AbstractPartTreeBlazePersistenceQuery.this.parameters.getDynamicProjectionIndex()];
                if (AbstractPartTreeBlazePersistenceQuery.this.evm.getMetamodel().managedView(entityViewClass) == null) {
                    entityViewClass = null;
                } else {
                    values[((AbstractPartTreeBlazePersistenceQuery)AbstractPartTreeBlazePersistenceQuery.this).parameters.getDynamicProjectionIndex()] = null;
                }
            }
            boolean withKeysetExtraction = false;
            boolean withExtractAllKeysets = false;
            Pageable pageable = binder.getPageable();
            if (!withCount) {
                ++maxResults;
            }
            if (entityViewClass == null) {
                PaginatedCriteriaBuilder paginatedCriteriaBuilder;
                if (pageable instanceof KeysetPageable) {
                    KeysetPageable keysetPageable = (KeysetPageable)pageable;
                    paginatedCriteriaBuilder = cb.page(keysetPageable.getKeysetPage(), firstResult, maxResults);
                    withKeysetExtraction = true;
                    withExtractAllKeysets = keysetPageable.isWithExtractAllKeysets();
                } else {
                    paginatedCriteriaBuilder = cb.page(firstResult, maxResults);
                }
                if (withKeysetExtraction) {
                    paginatedCriteriaBuilder.withKeysetExtraction(true);
                    paginatedCriteriaBuilder.withExtractAllKeysets(withExtractAllKeysets);
                }
                if (withCount) {
                    paginatedCriteriaBuilder.withCountQuery(true);
                } else {
                    paginatedCriteriaBuilder.withHighestKeysetOffset(1).withCountQuery(false);
                }
                jpaQuery = paginatedCriteriaBuilder.getQuery();
            } else {
                EntityViewSetting setting = EntityViewSetting.create((Class)entityViewClass, (int)firstResult, (int)maxResults);
                if (pageable instanceof KeysetPageable) {
                    KeysetPageable keysetPageable = (KeysetPageable)pageable;
                    withKeysetExtraction = true;
                    withExtractAllKeysets = keysetPageable.isWithExtractAllKeysets();
                    setting.withKeysetPage(keysetPageable.getKeysetPage());
                }
                setting = this.processSetting(setting, values);
                HashMap<String, Sorter> settingProcessorAttributeSorters = new HashMap<String, Sorter>(setting.getAttributeSorters());
                setting.getAttributeSorters().clear();
                PaginatedCriteriaBuilder paginatedCriteriaBuilder = (PaginatedCriteriaBuilder)AbstractPartTreeBlazePersistenceQuery.this.evm.applySetting(setting, cb);
                this.processSort((FullQueryBuilder<?, ?>)paginatedCriteriaBuilder, values, entityViewClass, (Map<String, Sorter>)settingProcessorAttributeSorters);
                if (withCount) {
                    paginatedCriteriaBuilder.withCountQuery(true);
                } else {
                    paginatedCriteriaBuilder.withHighestKeysetOffset(1).withCountQuery(false);
                }
                if (withKeysetExtraction) {
                    paginatedCriteriaBuilder.withKeysetExtraction(true);
                    paginatedCriteriaBuilder.withExtractAllKeysets(withExtractAllKeysets);
                }
                jpaQuery = paginatedCriteriaBuilder.getQuery();
            }
            return binder.bind(jpaQuery);
        }

        protected <T> EntityViewSetting<? extends T, ?> processSetting(EntityViewSetting<T, ?> setting, Object[] values) {
            EntityViewSettingProcessor processor;
            EntityViewSetting<T, ?> processedSetting = setting;
            int entityViewSettingProcessorIndex = AbstractPartTreeBlazePersistenceQuery.this.parameters.getEntityViewSettingProcessorIndex();
            if (entityViewSettingProcessorIndex >= 0 && (processor = (EntityViewSettingProcessor)values[entityViewSettingProcessorIndex]) != null) {
                processedSetting = processor.acceptEntityViewSetting(setting);
            }
            Iterator iterator = AbstractPartTreeBlazePersistenceQuery.this.parameters.getOptionalParameters().iterator();
            while (iterator.hasNext()) {
                JpaParameters.JpaParameter parameter = (JpaParameters.JpaParameter)((Object)iterator.next());
                String parameterName = parameter.getParameterName();
                Object parameterValue = values[parameter.getIndex()];
                processedSetting.addOptionalParameter(parameterName, parameterValue);
            }
            return processedSetting;
        }

        protected void processSort(FullQueryBuilder<?, ?> cb, Object[] values, Class<?> entityViewClass, Map<String, Sorter> evsAttributeSorter) {
            Sort sort;
            int sortIndex = AbstractPartTreeBlazePersistenceQuery.this.parameters.getSortIndex();
            if (sortIndex >= 0 && (sort = (Sort)values[sortIndex]) != null) {
                EntityViewSortUtil.applySort(AbstractPartTreeBlazePersistenceQuery.this.evm, entityViewClass, cb, sort);
            } else {
                int pageableIndex = AbstractPartTreeBlazePersistenceQuery.this.parameters.getPageableIndex();
                if (pageableIndex >= 0 && (sort = ((Pageable)values[pageableIndex]).getSort()) != null) {
                    EntityViewSortUtil.applySort(AbstractPartTreeBlazePersistenceQuery.this.evm, entityViewClass, cb, sort);
                }
            }
            for (Map.Entry<String, Sorter> attributeSorterEntry : evsAttributeSorter.entrySet()) {
                attributeSorterEntry.getValue().apply(cb, attributeSorterEntry.getKey());
            }
        }

        protected void processSpecification(CriteriaQuery<?> criteriaQuery, Object[] values) {
            Specification specification;
            BlazeCriteriaQuery blazeCriteriaQuery = (BlazeCriteriaQuery)criteriaQuery;
            int specificationIndex = AbstractPartTreeBlazePersistenceQuery.this.parameters.getSpecificationIndex();
            if (specificationIndex >= 0 && (specification = (Specification)values[specificationIndex]) != null) {
                Root root = (Root)criteriaQuery.getRoots().iterator().next();
                BlazeCriteriaBuilder criteriaBuilder = blazeCriteriaQuery.getCriteriaBuilder();
                Predicate predicate = specification.toPredicate(root, criteriaQuery, (javax.persistence.criteria.CriteriaBuilder)criteriaBuilder);
                criteriaQuery.where((Expression)predicate);
            }
        }

        protected void processBlazeSpecification(CriteriaBuilder<?> criteriaBuilder, Object[] values) {
            int criteriaBuilderProcessorIndex = AbstractPartTreeBlazePersistenceQuery.this.parameters.getBlazeSpecificationIndex();
            if (criteriaBuilderProcessorIndex >= 0) {
                String rootAlias = ((From)criteriaBuilder.getRoots().iterator().next()).getAlias();
                BlazeSpecification blazeSpecification = (BlazeSpecification)values[criteriaBuilderProcessorIndex];
                if (blazeSpecification != null) {
                    blazeSpecification.applySpecification(rootAlias, criteriaBuilder);
                }
            }
        }

        protected FixedJpaQueryCreator createCreator(ParametersParameterAccessor accessor, PersistenceProvider persistenceProvider) {
            BlazeCriteriaQuery cq = BlazeCriteria.get((CriteriaBuilderFactory)AbstractPartTreeBlazePersistenceQuery.this.cbf, Long.class);
            BlazeCriteriaBuilder builder = cq.getCriteriaBuilder();
            ParameterMetadataProvider provider = accessor == null ? AbstractPartTreeBlazePersistenceQuery.this.createParameterMetadataProvider((javax.persistence.criteria.CriteriaBuilder)builder, AbstractPartTreeBlazePersistenceQuery.this.parameters, persistenceProvider, AbstractPartTreeBlazePersistenceQuery.this.escape) : AbstractPartTreeBlazePersistenceQuery.this.createParameterMetadataProvider((javax.persistence.criteria.CriteriaBuilder)builder, accessor, persistenceProvider, AbstractPartTreeBlazePersistenceQuery.this.escape);
            return new FixedJpaQueryCreator(AbstractPartTreeBlazePersistenceQuery.this.tree, AbstractPartTreeBlazePersistenceQuery.this.domainClass, (javax.persistence.criteria.CriteriaBuilder)builder, provider);
        }

        public Query createQuery(Object[] values) {
            CriteriaQuery<?> criteriaQuery = this.cachedCriteriaQuery;
            List<ParameterMetadataProvider.ParameterMetadata<?>> expressions = this.expressions;
            ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)AbstractPartTreeBlazePersistenceQuery.this.parameters, values);
            if (this.cachedCriteriaQuery == null || accessor.hasBindableNullValue()) {
                FixedJpaQueryCreator creator = this.createCreator(accessor, this.persistenceProvider);
                criteriaQuery = this.invokeQueryCreator(creator, this.appliesSortThroughAttributeSorters() ? null : this.getDynamicSort(values));
                expressions = creator.getParameterExpressions();
            }
            TypedQuery<?> jpaQuery = this.createQuery(criteriaQuery, values);
            return this.restrictMaxResultsIfNecessary(this.invokeBinding(this.getBinder(values, expressions), jpaQuery));
        }

        private boolean appliesSortThroughAttributeSorters() {
            return AbstractPartTreeBlazePersistenceQuery.this.entityViewClass != null || AbstractPartTreeBlazePersistenceQuery.this.parameters.hasDynamicProjection();
        }

        protected CriteriaQuery<?> invokeQueryCreator(FixedJpaQueryCreator creator, Sort sort) {
            if (sort == null) {
                return ((CriteriaQuery)creator.createQuery()).select(null);
            }
            return ((CriteriaQuery)creator.createQuery(sort)).select(null);
        }

        private Query restrictMaxResultsIfNecessary(Query query) {
            if (AbstractPartTreeBlazePersistenceQuery.this.tree.isLimiting()) {
                if (query.getMaxResults() != Integer.MAX_VALUE && query.getMaxResults() > AbstractPartTreeBlazePersistenceQuery.this.tree.getMaxResults() && query.getFirstResult() > 0) {
                    query.setFirstResult(query.getFirstResult() - (query.getMaxResults() - AbstractPartTreeBlazePersistenceQuery.this.tree.getMaxResults()));
                }
                query.setMaxResults(AbstractPartTreeBlazePersistenceQuery.this.tree.getMaxResults().intValue());
            }
            return query;
        }

        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query) {
            return binder.bindAndPrepare((Query)query);
        }

        private ParameterBinder getBinder(Object[] values, List<ParameterMetadataProvider.ParameterMetadata<?>> expressions) {
            return AbstractPartTreeBlazePersistenceQuery.this.createCriteriaQueryParameterBinder(AbstractPartTreeBlazePersistenceQuery.this.parameters, values, expressions);
        }

        private Sort getDynamicSort(Object[] values) {
            return AbstractPartTreeBlazePersistenceQuery.this.parameters.potentiallySortsDynamically() ? new ParametersParameterAccessor((Parameters)AbstractPartTreeBlazePersistenceQuery.this.parameters, values).getSort() : null;
        }
    }
}

