/*
 * Decompiled with CFR 0.152.
 */
package com.bitmovin.api.resource;

import com.bitmovin.api.RestClient;
import com.bitmovin.api.encoding.manifest.dash.AdaptationSet;
import com.bitmovin.api.encoding.manifest.dash.AudioAdaptationSet;
import com.bitmovin.api.encoding.manifest.dash.ContentProtection;
import com.bitmovin.api.encoding.manifest.dash.DashDRMRepresentation;
import com.bitmovin.api.encoding.manifest.dash.DashFmp4Representation;
import com.bitmovin.api.encoding.manifest.dash.DashMP4Representation;
import com.bitmovin.api.encoding.manifest.dash.DashManifest;
import com.bitmovin.api.encoding.manifest.dash.DashSegmentedRepresentation;
import com.bitmovin.api.encoding.manifest.dash.DashVttRepresentation;
import com.bitmovin.api.encoding.manifest.dash.DashWebmRepresentation;
import com.bitmovin.api.encoding.manifest.dash.Period;
import com.bitmovin.api.encoding.manifest.dash.SubtitleAdaptationSet;
import com.bitmovin.api.encoding.manifest.dash.VideoAdaptationSet;
import com.bitmovin.api.exceptions.BitmovinApiException;
import com.bitmovin.api.http.RestException;
import com.bitmovin.api.resource.ManifestResource;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;

public class ManifestDashResource
extends ManifestResource<DashManifest> {
    public ManifestDashResource(Map<String, String> headers, String url, Class<DashManifest> type, String status, String start) {
        super(headers, url, type, status, start);
    }

    public Period createPeriod(DashManifest manifestDash, Period period) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/manifests/dash/{manifestId}/periods".replace("{manifestId}", manifestDash.getId());
        return RestClient.postDetail(newUrl, this.headers, period, Period.class);
    }

    public VideoAdaptationSet addVideoAdaptationSetToPeriod(DashManifest manifestDash, Period period, VideoAdaptationSet adaptationSet) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/manifests/dash/{manifestId}/periods/{periodId}/adaptationsets/video".replace("{manifestId}", manifestDash.getId());
        newUrl = newUrl.replace("{periodId}", period.getId());
        return RestClient.postDetail(newUrl, this.headers, adaptationSet, VideoAdaptationSet.class);
    }

    public AudioAdaptationSet addAudioAdaptationSetToPeriod(DashManifest manifestDash, Period period, AudioAdaptationSet adaptationSet) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/manifests/dash/{manifestId}/periods/{periodId}/adaptationsets/audio".replace("{manifestId}", manifestDash.getId());
        newUrl = newUrl.replace("{periodId}", period.getId());
        return RestClient.postDetail(newUrl, this.headers, adaptationSet, AudioAdaptationSet.class);
    }

    public SubtitleAdaptationSet addSubtitleAdaptationSetToPeriod(DashManifest manifestDash, Period period, SubtitleAdaptationSet adaptationSet) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/manifests/dash/{manifestId}/periods/{periodId}/adaptationsets/subtitle".replace("{manifestId}", manifestDash.getId());
        newUrl = newUrl.replace("{periodId}", period.getId());
        return RestClient.postDetail(newUrl, this.headers, adaptationSet, SubtitleAdaptationSet.class);
    }

    public DashSegmentedRepresentation addRepresentationToAdaptationSet(DashManifest manifestDash, Period period, AdaptationSet adaptationSet, DashSegmentedRepresentation dashRepresentation) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = null;
        if (dashRepresentation instanceof DashFmp4Representation) {
            newUrl = "encoding/manifests/dash/{manifestId}/periods/{periodId}/adaptationsets/{adaptionsetId}/representations/fmp4";
        }
        if (dashRepresentation instanceof DashWebmRepresentation) {
            newUrl = "encoding/manifests/dash/{manifestId}/periods/{periodId}/adaptationsets/{adaptionsetId}/representations/webm";
        }
        if (newUrl == null) {
            throw new BitmovinApiException(String.format("No route available for class %s.", dashRepresentation.getClass().getSimpleName()));
        }
        newUrl = newUrl.replace("{manifestId}", manifestDash.getId());
        newUrl = newUrl.replace("{periodId}", period.getId());
        newUrl = newUrl.replace("{adaptionsetId}", adaptationSet.getId());
        return (DashSegmentedRepresentation)RestClient.postDetail(newUrl, this.headers, dashRepresentation, dashRepresentation.getClass());
    }

    public DashMP4Representation addRepresentationToAdaptationSet(DashManifest manifestDash, Period period, AdaptationSet adaptationSet, DashMP4Representation dashRepresentation) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/manifests/dash/{manifestId}/periods/{periodId}/adaptationsets/{adaptionsetId}/representations/mp4";
        newUrl = newUrl.replace("{manifestId}", manifestDash.getId());
        newUrl = newUrl.replace("{periodId}", period.getId());
        newUrl = newUrl.replace("{adaptionsetId}", adaptationSet.getId());
        return (DashMP4Representation)RestClient.postDetail(newUrl, this.headers, dashRepresentation, dashRepresentation.getClass());
    }

    public DashDRMRepresentation addDrmRepresentationToAdaptationSet(DashManifest manifestDash, Period period, AdaptationSet adaptationSet, DashDRMRepresentation muxing) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/manifests/dash/{manifestId}/periods/{periodId}/adaptationsets/{adaptionsetId}/representations/fmp4".replace("{manifestId}", manifestDash.getId()) + "/drm";
        newUrl = newUrl.replace("{periodId}", period.getId());
        newUrl = newUrl.replace("{adaptionsetId}", adaptationSet.getId());
        return RestClient.postDetail(newUrl, this.headers, muxing, DashDRMRepresentation.class);
    }

    public DashVttRepresentation addVttRepresentationToAdaptationSet(DashManifest manifestDash, Period period, AdaptationSet adaptationSet, DashVttRepresentation vttRepresentation) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/manifests/dash/{manifestId}/periods/{periodId}/adaptationsets/{adaptionsetId}/representations/vtt".replace("{manifestId}", manifestDash.getId());
        newUrl = newUrl.replace("{periodId}", period.getId());
        newUrl = newUrl.replace("{adaptionsetId}", adaptationSet.getId());
        return RestClient.postDetail(newUrl, this.headers, vttRepresentation, DashVttRepresentation.class);
    }

    public ContentProtection addContentProtectionToAdaptationSet(DashManifest manifestDash, Period period, AdaptationSet adaptationSet, ContentProtection contentProtection) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/manifests/dash/{manifestId}/periods/{periodId}/adaptationsets/{adaptionsetId}/contentprotection".replace("{manifestId}", manifestDash.getId());
        newUrl = newUrl.replace("{periodId}", period.getId());
        newUrl = newUrl.replace("{adaptionsetId}", adaptationSet.getId());
        return RestClient.postDetail(newUrl, this.headers, contentProtection, ContentProtection.class);
    }

    public ContentProtection addContentProtectionTofMP4Representation(DashManifest manifestDash, Period period, AdaptationSet adaptationSet, DashFmp4Representation representation, ContentProtection contentProtection) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/manifests/dash/{manifestId}/periods/{periodId}/adaptationsets/{adaptionsetId}/representations/fmp4/{representationId}/contentprotection".replace("{manifestId}", manifestDash.getId());
        newUrl = newUrl.replace("{periodId}", period.getId());
        newUrl = newUrl.replace("{adaptionsetId}", adaptationSet.getId());
        newUrl = newUrl.replace("{representationId}", representation.getId());
        return RestClient.postDetail(newUrl, this.headers, contentProtection, ContentProtection.class);
    }

    public ContentProtection addContentProtectionToDRMfMP4Representation(DashManifest manifestDash, Period period, AdaptationSet adaptationSet, DashFmp4Representation representation, ContentProtection contentProtection) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/manifests/dash/{manifestId}/periods/{periodId}/adaptationsets/{adaptionsetId}/representations/fmp4/drm/{representationId}/contentprotection".replace("{manifestId}", manifestDash.getId());
        newUrl = newUrl.replace("{periodId}", period.getId());
        newUrl = newUrl.replace("{adaptionsetId}", adaptationSet.getId());
        newUrl = newUrl.replace("{representationId}", representation.getId());
        return RestClient.postDetail(newUrl, this.headers, contentProtection, ContentProtection.class);
    }
}

