/*
 * Decompiled with CFR 0.152.
 */
package com.bitmovin.api.resource;

import com.bitmovin.api.RestClient;
import com.bitmovin.api.encoding.statistics.SummaryEncodingStatistics;
import com.bitmovin.api.exceptions.BitmovinApiException;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class EncodingSummaryStatisticsResource<T extends SummaryEncodingStatistics> {
    protected Map<String, String> headers;
    protected String url;
    protected Class<T> type;

    public EncodingSummaryStatisticsResource(Map<String, String> headers, String url, Class<T> type) {
        this.headers = headers;
        this.url = url;
        this.type = type;
    }

    public List<T> getStatistics() throws BitmovinApiException, UnirestException, IOException, URISyntaxException {
        return RestClient.getItems(this.url, this.headers, this.type);
    }

    private String fromTo(Date from, Date to) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return this.url + "/" + dateFormat.format(from) + "/" + dateFormat.format(to);
    }

    public List<T> getStatistics(Date from, Date to) throws BitmovinApiException, UnirestException, IOException, URISyntaxException {
        return RestClient.getItems(this.fromTo(from, to), this.headers, this.type);
    }

    public List<T> getStatistics(Date from, Date to, int offset, int limit) throws BitmovinApiException, UnirestException, IOException, URISyntaxException {
        String limitUrl = this.fromTo(from, to) + "?offset=" + String.valueOf(offset) + "&limit=" + String.valueOf(limit);
        return RestClient.getItems(limitUrl, this.headers, this.type);
    }
}

