/*
 * Decompiled with CFR 0.152.
 */
package com.bitmovin.api.container;

import com.bitmovin.api.RestClient;
import com.bitmovin.api.encoding.analysis.AnalysisDetails;
import com.bitmovin.api.encoding.analysis.AnalysisStartRequest;
import com.bitmovin.api.encoding.inputs.AkamaiNetstorageInput;
import com.bitmovin.api.encoding.inputs.AsperaInput;
import com.bitmovin.api.encoding.inputs.AzureInput;
import com.bitmovin.api.encoding.inputs.FtpInput;
import com.bitmovin.api.encoding.inputs.GcsInput;
import com.bitmovin.api.encoding.inputs.GenericS3Input;
import com.bitmovin.api.encoding.inputs.HttpInput;
import com.bitmovin.api.encoding.inputs.HttpsInput;
import com.bitmovin.api.encoding.inputs.Input;
import com.bitmovin.api.encoding.inputs.InputType;
import com.bitmovin.api.encoding.inputs.LocalInput;
import com.bitmovin.api.encoding.inputs.RtmpInput;
import com.bitmovin.api.encoding.inputs.S3Input;
import com.bitmovin.api.encoding.inputs.S3RoleBasedInput;
import com.bitmovin.api.encoding.inputs.SftpInput;
import com.bitmovin.api.encoding.inputs.ZixiInput;
import com.bitmovin.api.encoding.status.Task;
import com.bitmovin.api.exceptions.BitmovinApiException;
import com.bitmovin.api.http.RestException;
import com.bitmovin.api.resource.InputResource;
import com.bitmovin.api.rest.ResponseEnvelope;
import com.bitmovin.api.rest.status.ServiceTaskStatus;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.json.JSONObject;

public class InputContainer {
    public InputResource<AsperaInput> aspera;
    public InputResource<AzureInput> azure;
    public InputResource<FtpInput> ftp;
    public InputResource<GcsInput> gcs;
    public InputResource<HttpInput> http;
    public InputResource<HttpsInput> https;
    public InputResource<SftpInput> sftp;
    public InputResource<S3Input> s3;
    public InputResource<RtmpInput> rtmp;
    public InputResource<GenericS3Input> genericS3;
    public InputResource<LocalInput> local;
    public InputResource<AkamaiNetstorageInput> akamaiNetstorage;
    public InputResource<ZixiInput> zixi;
    public InputResource<S3RoleBasedInput> s3RoleBased;
    public InputResource<Input> all;
    private Map<String, String> headers;

    public InputContainer(Map<String, String> headers) {
        this.headers = headers;
        this.aspera = new InputResource<AsperaInput>(headers, "encoding/inputs/aspera", AsperaInput.class);
        this.azure = new InputResource<AzureInput>(headers, "encoding/inputs/azure", AzureInput.class);
        this.ftp = new InputResource<FtpInput>(headers, "encoding/inputs/ftp", FtpInput.class);
        this.gcs = new InputResource<GcsInput>(headers, "encoding/inputs/gcs", GcsInput.class);
        this.http = new InputResource<HttpInput>(headers, "encoding/inputs/http", HttpInput.class);
        this.https = new InputResource<HttpsInput>(headers, "encoding/inputs/https", HttpsInput.class);
        this.sftp = new InputResource<SftpInput>(headers, "encoding/inputs/sftp", SftpInput.class);
        this.s3 = new InputResource<S3Input>(headers, "encoding/inputs/s3", S3Input.class);
        this.rtmp = new InputResource<RtmpInput>(headers, "encoding/inputs/rtmp", RtmpInput.class);
        this.local = new InputResource<LocalInput>(headers, "encoding/inputs/local", LocalInput.class);
        this.all = new InputResource<Input>(headers, "encoding/inputs", Input.class);
        this.genericS3 = new InputResource<GenericS3Input>(headers, "encoding/inputs/generic-s3", GenericS3Input.class);
        this.akamaiNetstorage = new InputResource<AkamaiNetstorageInput>(headers, "encoding/inputs/akamai-netstorage", AkamaiNetstorageInput.class);
        this.zixi = new InputResource<ZixiInput>(headers, "encoding/inputs/zixi", ZixiInput.class);
        this.s3RoleBased = new InputResource<S3RoleBasedInput>(headers, "encoding/inputs/s3-role-based", S3RoleBasedInput.class);
    }

    public InputType getType(String inputId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        ResponseEnvelope responseEnvelope = RestClient.getRaw("encoding/inputs/" + inputId + "/type", this.headers, ResponseEnvelope.class);
        JSONObject responseObject = RestClient.convertToJsonObject(responseEnvelope);
        String type = responseObject.getJSONObject("data").getJSONObject("result").getString("type");
        return InputType.valueOf(type);
    }

    public Task getStatusOfInputAnalysis(Input input, String analysisId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/inputs/{inputType}/{inputId}/analysis/{analysisId}/status".replace("{inputType}", input.getType().toString().toLowerCase()).replace("{inputId}", input.getId()).replace("{analysisId}", analysisId);
        ResponseEnvelope responseEnvelope = RestClient.getRaw(newUrl, this.headers, ResponseEnvelope.class);
        return RestClient.getAnalysisTaskFromResponse(responseEnvelope);
    }

    public AnalysisDetails getDetailsOfInputAnalysis(Input input, String analysisId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/inputs/{inputType}/{inputId}/analysis/{analysisId}".replace("{inputType}", input.getType().toString().toLowerCase()).replace("{inputId}", input.getId()).replace("{analysisId}", analysisId);
        ResponseEnvelope responseEnvelope = RestClient.getRaw(newUrl, this.headers, ResponseEnvelope.class);
        return RestClient.getAnalysisDetailsFromResponse(responseEnvelope);
    }

    public String startInputAnalysis(Input input, AnalysisStartRequest analysisStartRequest) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String newUrl = "encoding/inputs/{inputType}/{inputId}/analysis".replace("{inputType}", input.getType().toString().toLowerCase()).replace("{inputId}", input.getId());
        ResponseEnvelope responseEnvelope = RestClient.postRaw(newUrl, this.headers, analysisStartRequest, ResponseEnvelope.class);
        return RestClient.getIdFromResponse(responseEnvelope);
    }

    public ServiceTaskStatus getInputAnalysisStatus(Input input, String analysisId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        String url = "encoding/inputs/{inputType}/{inputId}/analysis/{analysisId}/status".replace("{inputType}", input.getType().toString().toLowerCase()).replace("{inputId}", input.getId()).replace("{analysisId}", analysisId);
        return RestClient.get(url, this.headers, ServiceTaskStatus.class);
    }
}

