/*
 * Decompiled with CFR 0.152.
 */
package com.bitmovin.api.container;

import com.bitmovin.api.RestClient;
import com.bitmovin.api.encoding.filters.AudioMixFilter;
import com.bitmovin.api.encoding.filters.CropFilter;
import com.bitmovin.api.encoding.filters.DeinterlaceFilter;
import com.bitmovin.api.encoding.filters.Filter;
import com.bitmovin.api.encoding.filters.InterlaceFilter;
import com.bitmovin.api.encoding.filters.RotateFilter;
import com.bitmovin.api.encoding.filters.ScaleFilter;
import com.bitmovin.api.encoding.filters.TextFilter;
import com.bitmovin.api.encoding.filters.UnsharpFilter;
import com.bitmovin.api.encoding.filters.WatermarkFilter;
import com.bitmovin.api.exceptions.BitmovinApiException;
import com.bitmovin.api.http.RestException;
import com.bitmovin.api.resource.FilterResource;
import com.bitmovin.api.rest.ResponseEnvelope;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.json.JSONObject;

public class FilterContainer {
    public FilterResource<CropFilter> crop;
    public FilterResource<RotateFilter> rotate;
    public FilterResource<WatermarkFilter> watermark;
    public FilterResource<DeinterlaceFilter> deinterlace;
    public FilterResource<AudioMixFilter> audioMix;
    public FilterResource<TextFilter> text;
    public FilterResource<InterlaceFilter> interlace;
    public FilterResource<UnsharpFilter> unsharp;
    public FilterResource<ScaleFilter> scale;
    public FilterResource<Filter> all;
    private Map<String, String> headers;

    public FilterContainer(Map<String, String> headers) {
        this.headers = headers;
        this.crop = new FilterResource<CropFilter>(headers, "encoding/filters/crop", CropFilter.class);
        this.rotate = new FilterResource<RotateFilter>(headers, "encoding/filters/rotate", RotateFilter.class);
        this.watermark = new FilterResource<WatermarkFilter>(headers, "encoding/filters/watermark", WatermarkFilter.class);
        this.deinterlace = new FilterResource<DeinterlaceFilter>(headers, "encoding/filters/deinterlace", DeinterlaceFilter.class);
        this.audioMix = new FilterResource<AudioMixFilter>(headers, "encoding/filters/audio-mix", AudioMixFilter.class);
        this.text = new FilterResource<TextFilter>(headers, "encoding/filters/text", TextFilter.class);
        this.interlace = new FilterResource<InterlaceFilter>(headers, "encoding/filters/interlace", InterlaceFilter.class);
        this.unsharp = new FilterResource<UnsharpFilter>(headers, "encoding/filters/unsharp", UnsharpFilter.class);
        this.scale = new FilterResource<ScaleFilter>(headers, "encoding/filters/scale", ScaleFilter.class);
        this.all = new FilterResource<Filter>(headers, "encoding/filters", Filter.class);
    }

    public int getTotalFiltersCount() throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        ResponseEnvelope responseEnvelope = RestClient.getRaw("encoding/filters", this.headers, ResponseEnvelope.class);
        JSONObject responseObject = RestClient.convertToJsonObject(responseEnvelope);
        return responseObject.getJSONObject("data").getJSONObject("result").getInt("totalCount");
    }
}

