/*
 * Decompiled with CFR 0.152.
 */
package com.bitmovin.api.container;

import com.bitmovin.api.RestClient;
import com.bitmovin.api.encoding.codecConfigurations.AACAudioConfig;
import com.bitmovin.api.encoding.codecConfigurations.AC3AudioConfig;
import com.bitmovin.api.encoding.codecConfigurations.AV1VideoConfiguration;
import com.bitmovin.api.encoding.codecConfigurations.CodecConfig;
import com.bitmovin.api.encoding.codecConfigurations.EAC3AudioConfig;
import com.bitmovin.api.encoding.codecConfigurations.H264VideoConfiguration;
import com.bitmovin.api.encoding.codecConfigurations.H265VideoConfiguration;
import com.bitmovin.api.encoding.codecConfigurations.HeAACv1AudioConfig;
import com.bitmovin.api.encoding.codecConfigurations.HeAACv2AudioConfig;
import com.bitmovin.api.encoding.codecConfigurations.MJPEGCodecConfiguration;
import com.bitmovin.api.encoding.codecConfigurations.MP2AudioConfig;
import com.bitmovin.api.encoding.codecConfigurations.MP3AudioConfig;
import com.bitmovin.api.encoding.codecConfigurations.OpusAudioConfig;
import com.bitmovin.api.encoding.codecConfigurations.VP8VideoConfiguration;
import com.bitmovin.api.encoding.codecConfigurations.VP9VideoConfiguration;
import com.bitmovin.api.encoding.codecConfigurations.VorbisAudioConfig;
import com.bitmovin.api.encoding.codecConfigurations.WebVttConfiguration;
import com.bitmovin.api.encoding.codecConfigurations.enums.ConfigType;
import com.bitmovin.api.exceptions.BitmovinApiException;
import com.bitmovin.api.http.RestException;
import com.bitmovin.api.resource.ConfigurationResource;
import com.bitmovin.api.rest.ResponseEnvelope;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.json.JSONObject;

public class ConfigurationContainer {
    public ConfigurationResource<AACAudioConfig> audioAAC;
    public ConfigurationResource<HeAACv1AudioConfig> heAACv1;
    public ConfigurationResource<HeAACv2AudioConfig> heAACv2;
    public ConfigurationResource<H264VideoConfiguration> videoH264;
    public ConfigurationResource<H265VideoConfiguration> videoH265;
    public ConfigurationResource<AV1VideoConfiguration> videoAV1;
    public ConfigurationResource<VP9VideoConfiguration> videoVP9;
    public ConfigurationResource<VP8VideoConfiguration> videoVP8;
    public ConfigurationResource<MJPEGCodecConfiguration> mjpeg;
    public ConfigurationResource<AC3AudioConfig> audioAC3;
    public ConfigurationResource<EAC3AudioConfig> audioEAC3;
    public ConfigurationResource<MP2AudioConfig> audioMP2;
    public ConfigurationResource<MP3AudioConfig> audioMP3;
    public ConfigurationResource<OpusAudioConfig> audioOpus;
    public ConfigurationResource<VorbisAudioConfig> audioVorbis;
    public ConfigurationResource<WebVttConfiguration> webVtt;
    public ConfigurationResource<CodecConfig> all;
    private Map<String, String> headers;

    public ConfigurationContainer(Map<String, String> headers) {
        this.headers = headers;
        this.videoH264 = new ConfigurationResource<H264VideoConfiguration>(headers, "encoding/configurations/video/h264", H264VideoConfiguration.class);
        this.videoH265 = new ConfigurationResource<H265VideoConfiguration>(headers, "encoding/configurations/video/h265", H265VideoConfiguration.class);
        this.videoAV1 = new ConfigurationResource<AV1VideoConfiguration>(headers, "encoding/configurations/video/av1", AV1VideoConfiguration.class);
        this.videoVP9 = new ConfigurationResource<VP9VideoConfiguration>(headers, "encoding/configurations/video/vp9", VP9VideoConfiguration.class);
        this.videoVP8 = new ConfigurationResource<VP8VideoConfiguration>(headers, "encoding/configurations/video/vp8", VP8VideoConfiguration.class);
        this.mjpeg = new ConfigurationResource<MJPEGCodecConfiguration>(headers, "encoding/configurations/video/mjpeg", MJPEGCodecConfiguration.class);
        this.audioAAC = new ConfigurationResource<AACAudioConfig>(headers, "encoding/configurations/audio/aac", AACAudioConfig.class);
        this.heAACv1 = new ConfigurationResource<HeAACv1AudioConfig>(headers, "encoding/configurations/audio/he-aac-v1", HeAACv1AudioConfig.class);
        this.heAACv2 = new ConfigurationResource<HeAACv2AudioConfig>(headers, "encoding/configurations/audio/he-aac-v2", HeAACv2AudioConfig.class);
        this.audioAC3 = new ConfigurationResource<AC3AudioConfig>(headers, "encoding/configurations/audio/ac3", AC3AudioConfig.class);
        this.audioEAC3 = new ConfigurationResource<EAC3AudioConfig>(headers, "encoding/configurations/audio/eac3", EAC3AudioConfig.class);
        this.audioMP2 = new ConfigurationResource<MP2AudioConfig>(headers, "encoding/configurations/audio/mp2", MP2AudioConfig.class);
        this.audioMP3 = new ConfigurationResource<MP3AudioConfig>(headers, "encoding/configurations/audio/mp3", MP3AudioConfig.class);
        this.audioOpus = new ConfigurationResource<OpusAudioConfig>(headers, "encoding/configurations/audio/opus", OpusAudioConfig.class);
        this.audioVorbis = new ConfigurationResource<VorbisAudioConfig>(headers, "encoding/configurations/audio/vorbis", VorbisAudioConfig.class);
        this.webVtt = new ConfigurationResource<WebVttConfiguration>(headers, "encoding/configurations/subtitles/webvtt", WebVttConfiguration.class);
        this.all = new ConfigurationResource<CodecConfig>(headers, "encoding/configurations", CodecConfig.class);
    }

    public ConfigType getType(String codecConfigurationId) throws BitmovinApiException, IOException, RestException, URISyntaxException, UnirestException {
        ResponseEnvelope responseEnvelope = RestClient.getRaw("encoding/configurations/" + codecConfigurationId + "/type", this.headers, ResponseEnvelope.class);
        JSONObject responseObject = RestClient.convertToJsonObject(responseEnvelope);
        return ConfigType.valueOf(responseObject.getJSONObject("data").getJSONObject("result").getString("type"));
    }
}

