/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.emodb.plugin.util;

import com.bazaarvoice.emodb.common.json.JsonHelper;
import com.bazaarvoice.emodb.plugin.Plugin;
import com.bazaarvoice.emodb.plugin.PluginServerMetadata;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.dropwizard.setup.Environment;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

public class PluginInstanceGenerator {
    private PluginInstanceGenerator() {
    }

    public static <T extends Plugin> T generateInstance(String className, Class<T> instanceType, Map<String, Object> config, Environment environment, PluginServerMetadata metadata) {
        try {
            Preconditions.checkNotNull((Object)className, (Object)"className");
            Preconditions.checkNotNull(instanceType, (Object)"instanceType");
            Class<?> clazz = Class.forName(className);
            Preconditions.checkArgument((boolean)instanceType.isAssignableFrom(clazz), (String)"Class {} does not implement or extend {}", (Object[])new Object[]{clazz, instanceType});
            Class configClass = null;
            Class<?> c = clazz;
            do {
                for (final Type type : c.getGenericInterfaces()) {
                    Type[] actualTypes;
                    if (!(type instanceof ParameterizedType) || !((ParameterizedType)type).getRawType().equals(instanceType) || (actualTypes = ((ParameterizedType)type).getActualTypeArguments()).length != 1) continue;
                    Type actualType = actualTypes[0];
                    configClass = actualType instanceof ParameterizedType ? (Class)((ParameterizedType)actualType).getRawType() : (Class)actualType;
                }
                c = c.getSuperclass();
            } while (configClass == null);
            Plugin instance = (Plugin)clazz.newInstance();
            Method init = clazz.getMethod("init", Environment.class, PluginServerMetadata.class, configClass);
            Object configImpl = null;
            if (!configClass.equals(Void.class)) {
                Type type;
                type = init.getGenericParameterTypes()[2];
                configImpl = JsonHelper.convert(config, (TypeReference)new TypeReference<Object>(){

                    public Type getType() {
                        return type;
                    }
                });
            }
            instance.init(environment, metadata, configImpl);
            return (T)instance;
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }
}

