/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions.query;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class QueryWrapper<T>
extends AbstractWrapper<T, String, QueryWrapper<T>> {
    private String sqlSelect;

    public QueryWrapper() {
        this(null);
    }

    public QueryWrapper(T entity) {
        this.setEntity(entity);
        this.initNeed();
    }

    public QueryWrapper(T entity, String ... columns) {
        this.setEntity(entity);
        this.select(columns);
        this.initNeed();
    }

    private QueryWrapper(T entity, Class<T> entityClass, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments) {
        this.setEntity(entity);
        this.entityClass = entityClass;
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
    }

    public QueryWrapper<T> select(String ... columns) {
        if (ArrayUtils.isNotEmpty(columns)) {
            this.sqlSelect = String.join((CharSequence)",", columns);
        }
        return (QueryWrapper)this.typedThis;
    }

    public QueryWrapper<T> select(Predicate<TableFieldInfo> predicate) {
        return this.select(this.entityClass, predicate);
    }

    public QueryWrapper<T> select(Class<T> entityClass, Predicate<TableFieldInfo> predicate) {
        this.entityClass = entityClass;
        this.sqlSelect = TableInfoHelper.getTableInfo(this.getCheckEntityClass()).chooseSelect(predicate);
        return (QueryWrapper)this.typedThis;
    }

    public LambdaQueryWrapper<T> lambda() {
        return new LambdaQueryWrapper<Object>(this.entity, this.entityClass, this.sqlSelect, this.paramNameSeq, this.paramNameValuePairs, this.expression);
    }

    @Override
    public String getSqlSelect() {
        return this.sqlSelect;
    }

    @Override
    protected String columnToString(String column) {
        return column;
    }

    @Override
    protected QueryWrapper<T> instance(AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs) {
        return new QueryWrapper<Object>(this.entity, this.entityClass, paramNameSeq, paramNameValuePairs, new MergeSegments());
    }
}

