/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.servicebus.implementation.core.config;

import com.azure.messaging.servicebus.ServiceBusErrorContext;
import com.azure.spring.cloud.service.servicebus.consumer.ServiceBusErrorHandler;
import com.azure.spring.messaging.implementation.config.AbstractAzureListenerEndpoint;
import com.azure.spring.messaging.implementation.config.AzureListenerEndpoint;
import com.azure.spring.messaging.implementation.config.AzureMessageListenerContainerFactoryAdapter;
import com.azure.spring.messaging.servicebus.core.ServiceBusProcessorFactory;
import com.azure.spring.messaging.servicebus.core.listener.ServiceBusMessageListenerContainer;
import com.azure.spring.messaging.servicebus.core.properties.ServiceBusContainerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBusMessageListenerContainerFactory
extends AzureMessageListenerContainerFactoryAdapter<ServiceBusMessageListenerContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBusMessageListenerContainerFactory.class);
    private final ServiceBusProcessorFactory processorFactory;
    private ServiceBusErrorHandler errorHandler = new LoggingErrorHandler();

    public ServiceBusMessageListenerContainerFactory(ServiceBusProcessorFactory processorFactory) {
        this.processorFactory = processorFactory;
    }

    protected ServiceBusMessageListenerContainer createContainerInstance(AzureListenerEndpoint endpoint) {
        ServiceBusContainerProperties containerProperties = new ServiceBusContainerProperties();
        containerProperties.setEntityName(endpoint.getDestination());
        containerProperties.setSubscriptionName(endpoint.getGroup());
        containerProperties.setErrorHandler(this.errorHandler);
        if (endpoint instanceof AbstractAzureListenerEndpoint) {
            String concurrency = ((AbstractAzureListenerEndpoint)endpoint).getConcurrency();
            try {
                containerProperties.setMaxConcurrentCalls(Integer.parseInt(concurrency));
            }
            catch (NumberFormatException e) {
                LOGGER.debug("The set concurrency {} must be an integer!", (Object)concurrency);
            }
        }
        return new ServiceBusMessageListenerContainer(this.processorFactory, containerProperties);
    }

    public void setErrorHandler(ServiceBusErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    static class LoggingErrorHandler
    implements ServiceBusErrorHandler {
        LoggingErrorHandler() {
        }

        public void accept(ServiceBusErrorContext errorContext) {
            LOGGER.error("Error occurred on entity {}. Error: {}", (Object)errorContext.getEntityPath(), (Object)errorContext.getException());
        }
    }
}

