/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.servicebus.core;

import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import com.azure.spring.cloud.service.servicebus.properties.ServiceBusEntityType;
import com.azure.spring.messaging.converter.AzureMessageConverter;
import com.azure.spring.messaging.core.SendOperation;
import com.azure.spring.messaging.servicebus.core.ServiceBusProducerFactory;
import com.azure.spring.messaging.servicebus.implementation.support.converter.ServiceBusMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ServiceBusTemplate
implements SendOperation {
    private static final ServiceBusMessageConverter DEFAULT_CONVERTER = new ServiceBusMessageConverter();
    private final ServiceBusProducerFactory producerFactory;
    private AzureMessageConverter<ServiceBusReceivedMessage, ServiceBusMessage> messageConverter = DEFAULT_CONVERTER;
    private ServiceBusEntityType defaultEntityType;

    public ServiceBusTemplate(@NonNull ServiceBusProducerFactory producerFactory) {
        this.producerFactory = producerFactory;
    }

    public <U> Mono<Void> sendAsync(String destination, Message<U> message) {
        Assert.hasText((String)destination, (String)"destination can't be null or empty");
        ServiceBusSenderAsyncClient senderAsyncClient = this.producerFactory.createProducer(destination, this.defaultEntityType);
        ServiceBusMessage serviceBusMessage = (ServiceBusMessage)this.messageConverter.fromMessage(message, ServiceBusMessage.class);
        return senderAsyncClient.sendMessage(serviceBusMessage);
    }

    public void setMessageConverter(AzureMessageConverter<ServiceBusReceivedMessage, ServiceBusMessage> messageConverter) {
        this.messageConverter = messageConverter;
    }

    public AzureMessageConverter<ServiceBusReceivedMessage, ServiceBusMessage> getMessageConverter() {
        return this.messageConverter;
    }

    public void setDefaultEntityType(ServiceBusEntityType entityType) {
        this.defaultEntityType = entityType;
    }
}

