/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.eventhubs.implementation.properties.merger;

import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.implementation.util.AzurePropertiesUtils;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.eventhubs.properties.EventBatchProperties;
import com.azure.spring.cloud.service.eventhubs.properties.LoadBalancingProperties;
import com.azure.spring.cloud.service.eventhubs.properties.StartPositionProperties;
import com.azure.spring.cloud.service.implementation.core.PropertiesMerger;
import com.azure.spring.messaging.eventhubs.core.properties.ProcessorProperties;
import java.util.Map;

public class ProcessorPropertiesMerger
implements PropertiesMerger<ProcessorProperties, ProcessorProperties> {
    public ProcessorProperties merge(ProcessorProperties first, ProcessorProperties second) {
        ProcessorProperties properties = new ProcessorProperties();
        if (first == null && second == null) {
            return properties;
        }
        if (first == null) {
            first = new ProcessorProperties();
        }
        if (second == null) {
            second = new ProcessorProperties();
        }
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)second, (AzureProperties)first, (AzureProperties)properties);
        ProcessorPropertiesMerger.copyProcessorPropertiesIfNotNull(second, properties);
        ProcessorPropertiesMerger.copyProcessorPropertiesIfNotNull(first, properties);
        return properties;
    }

    public static void copyProcessorPropertiesIfNotNull(ProcessorProperties source, ProcessorProperties target) {
        PropertyMapper propertyMapper = new PropertyMapper();
        propertyMapper.from((Object)source.getDomainName()).to(target::setDomainName);
        propertyMapper.from((Object)source.getNamespace()).to(target::setNamespace);
        propertyMapper.from((Object)source.getEventHubName()).to(target::setEventHubName);
        propertyMapper.from((Object)source.getConnectionString()).to(target::setConnectionString);
        propertyMapper.from((Object)source.getCustomEndpointAddress()).to(target::setCustomEndpointAddress);
        propertyMapper.from((Object)source.getPrefetchCount()).to(target::setPrefetchCount);
        propertyMapper.from((Object)source.getConsumerGroup()).to(target::setConsumerGroup);
        propertyMapper.from((Object)source.getTrackLastEnqueuedEventProperties()).to(target::setTrackLastEnqueuedEventProperties);
        propertyMapper.from(source.getInitialPartitionEventPosition()).to(m -> target.getInitialPartitionEventPosition().putAll((Map<String, StartPositionProperties>)m));
        propertyMapper.from((Object)source.getBatch().getMaxSize()).to(arg_0 -> ((EventBatchProperties)target.getBatch()).setMaxSize(arg_0));
        propertyMapper.from((Object)source.getBatch().getMaxWaitTime()).to(arg_0 -> ((EventBatchProperties)target.getBatch()).setMaxWaitTime(arg_0));
        propertyMapper.from((Object)source.getLoadBalancing().getPartitionOwnershipExpirationInterval()).to(arg_0 -> ((LoadBalancingProperties)target.getLoadBalancing()).setPartitionOwnershipExpirationInterval(arg_0));
        propertyMapper.from((Object)source.getLoadBalancing().getStrategy()).to(arg_0 -> ((LoadBalancingProperties)target.getLoadBalancing()).setStrategy(arg_0));
        propertyMapper.from((Object)source.getLoadBalancing().getUpdateInterval()).to(arg_0 -> ((LoadBalancingProperties)target.getLoadBalancing()).setUpdateInterval(arg_0));
    }
}

