/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.integration.core.implementation.instrumentation;

import com.azure.spring.integration.core.instrumentation.Instrumentation;
import com.azure.spring.integration.core.instrumentation.InstrumentationManager;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class InstrumentationSendCallback
implements ListenableFutureCallback<Void> {
    private final InstrumentationManager instrumentationManager;
    private final String instrumentationId;

    public InstrumentationSendCallback(String instrumentationId, InstrumentationManager instrumentationManager) {
        this.instrumentationId = instrumentationId;
        this.instrumentationManager = instrumentationManager;
    }

    public void onFailure(Throwable ex) {
        this.instrumentationManager.getHealthInstrumentation(this.instrumentationId).setStatus(Instrumentation.Status.DOWN, ex);
    }

    public void onSuccess(Void result) {
        this.instrumentationManager.getHealthInstrumentation(this.instrumentationId).setStatus(Instrumentation.Status.UP);
    }
}

