/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.cosmos;

import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.ThrottlingRetryOptions;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.authentication.KeyProvider;
import java.time.Duration;
import java.util.List;

public interface CosmosClientProperties
extends AzureProperties,
KeyProvider {
    public String getEndpoint();

    public String getResourceToken();

    public Boolean getClientTelemetryEnabled();

    public Boolean getEndpointDiscoveryEnabled();

    public Boolean getConnectionSharingAcrossClientsEnabled();

    public Boolean getContentResponseOnWriteEnabled();

    public Boolean getMultipleWriteRegionsEnabled();

    public Boolean getSessionCapturingOverrideEnabled();

    public Boolean getReadRequestsFallbackEnabled();

    public List<String> getPreferredRegions();

    public GatewayConnectionProperties getGatewayConnection();

    public DirectConnectionProperties getDirectConnection();

    public ConsistencyLevel getConsistencyLevel();

    public String getDatabase();

    public ConnectionMode getConnectionMode();

    public ThrottlingRetryOptions getThrottlingRetryOptions();

    public static interface DirectConnectionProperties {
        public Boolean getConnectionEndpointRediscoveryEnabled();

        public Duration getConnectTimeout();

        public Duration getIdleConnectionTimeout();

        public Duration getIdleEndpointTimeout();

        public Duration getNetworkRequestTimeout();

        public Integer getMaxConnectionsPerEndpoint();

        public Integer getMaxRequestsPerConnection();
    }

    public static interface GatewayConnectionProperties {
        public Integer getMaxConnectionPoolSize();

        public Duration getIdleConnectionTimeout();
    }
}

