/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.resourcemanager.implementation.crud;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.eventhubs.models.EventHub;
import com.azure.resourcemanager.eventhubs.models.EventHubNamespace;
import com.azure.spring.cloud.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.cloud.resourcemanager.implementation.crud.AbstractResourceCrud;
import com.azure.spring.cloud.resourcemanager.implementation.crud.EventHubNamespaceCrud;
import reactor.util.function.Tuple2;

public class EventHubsCrud
extends AbstractResourceCrud<EventHub, Tuple2<String, String>> {
    public EventHubsCrud(AzureResourceManager azureResourceManager, AzureResourceMetadata azureResourceMetadata) {
        super(azureResourceManager, azureResourceMetadata);
    }

    @Override
    String getResourceName(Tuple2<String, String> key) {
        return (String)key.getT2();
    }

    @Override
    String getResourceType() {
        return EventHub.class.getSimpleName();
    }

    @Override
    public EventHub internalGet(Tuple2<String, String> namespaceAndName) {
        try {
            return this.resourceManager.eventHubs().getByName(this.resourceMetadata.getResourceGroup(), (String)namespaceAndName.getT1(), (String)namespaceAndName.getT2());
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public EventHub internalCreate(Tuple2<String, String> namespaceAndName) {
        return (EventHub)((EventHub.DefinitionStages.Blank)this.resourceManager.eventHubs().define((String)namespaceAndName.getT2())).withExistingNamespace((EventHubNamespace)new EventHubNamespaceCrud(this.resourceManager, this.resourceMetadata).getOrCreate((String)namespaceAndName.getT1())).create();
    }
}

