/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.keyvault.environment;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.core.util.paging.ContinuablePagedIterable;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class KeyVaultOperation {
    private final SecretClient secretClient;

    public KeyVaultOperation(SecretClient secretClient) {
        this.secretClient = secretClient;
    }

    List<KeyVaultSecret> listSecrets(List<String> secretKeys) {
        List<KeyVaultSecret> keyVaultSecrets = secretKeys == null || secretKeys.isEmpty() ? Optional.of(this.secretClient).map(SecretClient::listPropertiesOfSecrets).map(ContinuablePagedIterable::iterableByPage).map(i -> StreamSupport.stream(i.spliterator(), false)).orElseGet(Stream::empty).map(ContinuablePage::getElements).flatMap(i -> StreamSupport.stream(i.spliterator(), false)).filter(SecretProperties::isEnabled).map(p -> this.secretClient.getSecret(p.getName(), p.getVersion())).filter(Objects::nonNull).toList() : secretKeys.stream().map(arg_0 -> ((SecretClient)this.secretClient).getSecret(arg_0)).filter(Objects::nonNull).toList();
        return keyVaultSecrets;
    }
}

