/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.kafka;

import com.azure.spring.cloud.autoconfigure.implementation.context.properties.AzureGlobalProperties;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.jaas.Jaas;
import com.azure.spring.cloud.service.implementation.jaas.JaasResolver;
import com.azure.spring.cloud.service.implementation.kafka.AzureKafkaPropertiesUtils;
import com.azure.spring.cloud.service.implementation.kafka.KafkaOAuth2AuthenticateCallbackHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

abstract class AbstractKafkaPropertiesBeanPostProcessor<T>
implements BeanPostProcessor,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractKafkaPropertiesBeanPostProcessor.class);
    static final String SECURITY_PROTOCOL_CONFIG_SASL = SecurityProtocol.SASL_SSL.name();
    static final String SASL_MECHANISM_OAUTH = "OAUTHBEARER";
    static final String AZURE_CONFIGURED_JAAS_OPTIONS_KEY = "azure.configured";
    static final String AZURE_CONFIGURED_JAAS_OPTIONS_VALUE = "true";
    static final String SASL_LOGIN_CALLBACK_HANDLER_CLASS_OAUTH = KafkaOAuth2AuthenticateCallbackHandler.class.getName();
    protected ApplicationContext applicationContext;
    protected static final PropertyMapper PROPERTY_MAPPER = new PropertyMapper();
    private static final Map<String, String> KAFKA_OAUTH_CONFIGS = Map.of("security.protocol", SECURITY_PROTOCOL_CONFIG_SASL, "sasl.mechanism", "OAUTHBEARER", "sasl.login.callback.handler.class", SASL_LOGIN_CALLBACK_HANDLER_CLASS_OAUTH);
    private static final String LOG_OAUTH_DETAILED_PROPERTY_CONFIGURE = "OAUTHBEARER authentication property {} will be configured as {} to support Azure Identity credentials.";
    private static final String LOG_OAUTH_AUTOCONFIGURATION_CONFIGURE = "Spring Cloud Azure auto-configuration for Kafka OAUTHBEARER authentication will be loaded to configure your Kafka security and sasl properties to support Azure Identity credentials.";
    private static final String LOG_OAUTH_AUTOCONFIGURATION_RECOMMENDATION = "Currently {} authentication mechanism is used, recommend to use Spring Cloud Azure auto-configuration for Kafka OAUTHBEARER authentication which supports various Azure Identity credentials. To leverage the auto-configuration for OAuth2, you can just remove all your security, sasl and credential configurations of Kafka and Event Hubs. And configure Kafka bootstrap servers instead, which can be set as spring.kafka.boostrap-servers=EventHubsNamespacesFQDN:9093.";
    private AzureGlobalProperties azureGlobalProperties;

    AbstractKafkaPropertiesBeanPostProcessor() {
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.needsPostProcess(bean)) {
            ObjectProvider beanProvider = this.applicationContext.getBeanProvider(AzureGlobalProperties.class);
            this.azureGlobalProperties = (AzureGlobalProperties)beanProvider.getIfAvailable();
            if (this.azureGlobalProperties == null) {
                LOGGER.debug("Cannot find a bean of type AzureGlobalProperties, Spring Cloud Azure will skip performing JAAS enhancements on the {} bean.", (Object)beanName);
                return bean;
            }
            Object properties = bean;
            this.replaceAzurePropertiesWithJaas(this.getMergedProducerProperties(properties), this.getRawProducerProperties(properties));
            this.replaceAzurePropertiesWithJaas(this.getMergedConsumerProperties(properties), this.getRawConsumerProperties(properties));
            this.replaceAzurePropertiesWithJaas(this.getMergedAdminProperties(properties), this.getRawAdminProperties(properties));
            this.customizeProcess(properties);
        }
        return bean;
    }

    protected abstract Map<String, Object> getMergedProducerProperties(T var1);

    protected abstract Map<String, String> getRawProducerProperties(T var1);

    protected abstract Map<String, Object> getMergedConsumerProperties(T var1);

    protected abstract Map<String, String> getRawConsumerProperties(T var1);

    protected abstract Map<String, Object> getMergedAdminProperties(T var1);

    protected abstract Map<String, String> getRawAdminProperties(T var1);

    protected abstract boolean needsPostProcess(Object var1);

    protected abstract Logger getLogger();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected void customizeProcess(T properties) {
    }

    protected void clearAzureProperties(Map<String, String> properties) {
        AzureKafkaPropertiesUtils.AzureKafkaPasswordlessPropertiesMapping.getPropertyKeys().forEach(properties::remove);
    }

    protected Map<String, Object> invokeBuildKafkaProperties(KafkaProperties kafkaProperties, String buildMethodName) {
        try {
            try {
                Method buildPropertiesMethod = KafkaProperties.class.getDeclaredMethod(buildMethodName, Class.forName("org.springframework.boot.ssl.SslBundles"));
                return (Map)buildPropertiesMethod.invoke((Object)kafkaProperties, new Object[]{null});
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                try {
                    return (Map)KafkaProperties.class.getDeclaredMethod(buildMethodName, new Class[0]).invoke((Object)kafkaProperties, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        throw new IllegalStateException("Failed to call " + buildMethodName + " method of KafkaProperties.");
    }

    private void replaceAzurePropertiesWithJaas(Map<String, Object> mergedProperties, Map<String, String> rawPropertiesMap) {
        this.resolveJaasForAzure(mergedProperties).ifPresent(jaas -> {
            this.configJaasToKafkaRawProperties((Jaas)jaas, rawPropertiesMap);
            this.logConfigureOAuthProperties();
            AbstractKafkaPropertiesBeanPostProcessor.configureKafkaUserAgent();
        });
        this.clearAzureProperties(rawPropertiesMap);
    }

    private Optional<Jaas> resolveJaasForAzure(Map<String, Object> mergedProperties) {
        if (this.needConfigureSaslOAuth(mergedProperties)) {
            JaasResolver resolver = new JaasResolver();
            Jaas jaas = resolver.resolve((String)mergedProperties.get("sasl.jaas.config")).orElse(new Jaas(OAuthBearerLoginModule.class.getName()));
            this.setAzurePropertiesToJaasOptionsIfAbsent(this.azureGlobalProperties, jaas);
            this.setKafkaPropertiesToJaasOptions(mergedProperties, jaas);
            jaas.getOptions().put(AZURE_CONFIGURED_JAAS_OPTIONS_KEY, AZURE_CONFIGURED_JAAS_OPTIONS_VALUE);
            return Optional.of(jaas);
        }
        return Optional.empty();
    }

    private void configJaasToKafkaRawProperties(Jaas jaas, Map<String, String> rawPropertiesMap) {
        rawPropertiesMap.putAll(KAFKA_OAUTH_CONFIGS);
        rawPropertiesMap.put("sasl.jaas.config", jaas.toString());
    }

    private void logConfigureOAuthProperties() {
        this.getLogger().info(LOG_OAUTH_AUTOCONFIGURATION_CONFIGURE);
        this.getLogger().debug(LOG_OAUTH_DETAILED_PROPERTY_CONFIGURE, (Object)"security.protocol", (Object)SECURITY_PROTOCOL_CONFIG_SASL);
        this.getLogger().debug(LOG_OAUTH_DETAILED_PROPERTY_CONFIGURE, (Object)"sasl.mechanism", (Object)SASL_MECHANISM_OAUTH);
        this.getLogger().debug(LOG_OAUTH_DETAILED_PROPERTY_CONFIGURE, (Object)"sasl.jaas.config", (Object)"***the value involves credentials and will not be logged***");
        this.getLogger().debug(LOG_OAUTH_DETAILED_PROPERTY_CONFIGURE, (Object)"sasl.login.callback.handler.class", (Object)SASL_LOGIN_CALLBACK_HANDLER_CLASS_OAUTH);
    }

    private void setKafkaPropertiesToJaasOptions(Map<String, ?> properties, Jaas jaas) {
        AzureKafkaPropertiesUtils.AzureKafkaPasswordlessPropertiesMapping.getPropertyKeys().forEach(k -> PROPERTY_MAPPER.from(properties.get(k)).to(p -> jaas.getOptions().put(k, (String)p)));
    }

    private void setAzurePropertiesToJaasOptionsIfAbsent(AzureProperties azureProperties, Jaas jaas) {
        this.convertAzurePropertiesToMap(azureProperties).forEach((k, v) -> jaas.getOptions().putIfAbsent(k, v));
    }

    private Map<String, String> convertAzurePropertiesToMap(AzureProperties properties) {
        HashMap<String, String> configs = new HashMap<String, String>();
        for (AzureKafkaPropertiesUtils.AzureKafkaPasswordlessPropertiesMapping m : AzureKafkaPropertiesUtils.AzureKafkaPasswordlessPropertiesMapping.values()) {
            PROPERTY_MAPPER.from((Object)((String)m.getter().apply(properties))).to(p -> configs.put(m.propertyKey(), (String)p));
        }
        return configs;
    }

    static synchronized void configureKafkaUserAgent() {
        String clientSoftwareName;
        ApiVersionsRequestData apiVersionsRequestData = null;
        Field defaultDataField = ReflectionUtils.findField(ApiVersionsRequest.Builder.class, (String)"DEFAULT_DATA");
        if (defaultDataField != null) {
            ReflectionUtils.makeAccessible((Field)defaultDataField);
            apiVersionsRequestData = (ApiVersionsRequestData)ReflectionUtils.getField((Field)defaultDataField, null);
        } else {
            Method dataMethod = ReflectionUtils.findMethod(ApiVersionsRequest.class, (String)"data");
            if (dataMethod != null) {
                ApiVersionsRequest apiVersionsRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
                apiVersionsRequestData = (ApiVersionsRequestData)ReflectionUtils.invokeMethod((Method)dataMethod, (Object)apiVersionsRequest);
            }
        }
        if (apiVersionsRequestData != null && (clientSoftwareName = apiVersionsRequestData.clientSoftwareName()) != null && !clientSoftwareName.contains(".az-sp-kafka")) {
            apiVersionsRequestData.setClientSoftwareName(apiVersionsRequestData.clientSoftwareName() + ".az-sp-kafka");
            apiVersionsRequestData.setClientSoftwareVersion(AzureSpringIdentifier.VERSION);
        }
    }

    boolean needConfigureSaslOAuth(Map<String, Object> sourceProperties) {
        return this.meetAzureBootstrapServerConditions(sourceProperties) && this.meetSaslOAuthConditions(sourceProperties);
    }

    private boolean meetSaslOAuthConditions(Map<String, Object> sourceProperties) {
        String securityProtocol = (String)sourceProperties.get("security.protocol");
        String saslMechanism = (String)sourceProperties.get("sasl.mechanism");
        String jaasConfig = (String)sourceProperties.get("sasl.jaas.config");
        if (this.meetSaslProtocolConditions(securityProtocol) && this.meetSaslOAuth2MechanismConditions(saslMechanism) && this.meetJaasConditions(jaasConfig)) {
            return true;
        }
        this.getLogger().info(LOG_OAUTH_AUTOCONFIGURATION_RECOMMENDATION, (Object)saslMechanism);
        return false;
    }

    private boolean meetSaslProtocolConditions(String securityProtocol) {
        return securityProtocol == null || SECURITY_PROTOCOL_CONFIG_SASL.equalsIgnoreCase(securityProtocol);
    }

    private boolean meetSaslOAuth2MechanismConditions(String saslMechanism) {
        return saslMechanism == null || SASL_MECHANISM_OAUTH.equalsIgnoreCase(saslMechanism);
    }

    private boolean meetJaasConditions(String jaasConfig) {
        if (jaasConfig == null) {
            return true;
        }
        JaasResolver resolver = new JaasResolver();
        return resolver.resolve(jaasConfig).map(jaas -> AZURE_CONFIGURED_JAAS_OPTIONS_VALUE.equals(jaas.getOptions().get(AZURE_CONFIGURED_JAAS_OPTIONS_KEY))).orElse(false);
    }

    private boolean meetAzureBootstrapServerConditions(Map<String, Object> sourceProperties) {
        List<String> serverList;
        Object bootstrapServers = sourceProperties.get("bootstrap.servers");
        if (bootstrapServers instanceof String) {
            serverList = Arrays.asList(StringUtils.delimitedListToStringArray((String)((String)bootstrapServers), (String)","));
        } else if (bootstrapServers instanceof Iterable) {
            serverList = new ArrayList<String>();
            for (Object obj : (Iterable)bootstrapServers) {
                if (obj instanceof String) {
                    serverList.add((String)obj);
                    continue;
                }
                this.getLogger().debug("Kafka bootstrap server configuration doesn't meet passwordless requirements.");
                return false;
            }
        } else {
            this.getLogger().debug("Kafka bootstrap server configuration doesn't meet passwordless requirements.");
            return false;
        }
        return serverList.size() == 1 && serverList.get(0).endsWith(":9093");
    }
}

