/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.data.cosmos;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Documented
@Conditional(value={ConditionalDatabaseConfiguredCondition.class})
@interface ConditionalOnDatabaseConfigured {

    public static class ConditionalDatabaseConfiguredCondition
    extends AnyNestedCondition {
        ConditionalDatabaseConfiguredCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(type={"com.azure.spring.cloud.autoconfigure.implementation.cosmos.properties.AzureCosmosConnectionDetails"})
        static class ConnectionDetailBeanConfigured {
            ConnectionDetailBeanConfigured() {
            }
        }

        @ConditionalOnProperty(prefix="spring.cloud.azure.cosmos", name={"database"})
        static class DataBasePropertyConfigured {
            DataBasePropertyConfigured() {
            }
        }
    }
}

