/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.context;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.identity.UsernamePasswordCredentialBuilder;
import com.azure.spring.cloud.autoconfigure.implementation.AzureServiceConfigurationBase;
import com.azure.spring.cloud.autoconfigure.implementation.context.AzureServiceClientBuilderFactoryConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.context.properties.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.properties.core.AbstractAzureHttpConfigurationProperties;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.credential.resolver.AzureTokenCredentialResolver;
import com.azure.spring.cloud.core.implementation.factory.credential.ClientCertificateCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.factory.credential.ClientSecretCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.factory.credential.DefaultAzureCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.factory.credential.ManagedIdentityCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.factory.credential.UsernamePasswordCredentialBuilderFactory;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.authentication.TokenCredentialOptionsProvider;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={TaskExecutionAutoConfiguration.class})
@Import(value={AzureServiceClientBuilderFactoryConfiguration.class})
public class AzureTokenCredentialAutoConfiguration
extends AzureServiceConfigurationBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureTokenCredentialAutoConfiguration.class);
    private final GenericApplicationContext applicationContext;
    private final IdentityClientProperties identityClientProperties;

    AzureTokenCredentialAutoConfiguration(GenericApplicationContext applicationContext, AzureGlobalProperties azureGlobalProperties) {
        super(azureGlobalProperties);
        this.applicationContext = applicationContext;
        this.identityClientProperties = this.loadProperties(azureGlobalProperties, new IdentityClientProperties());
    }

    @ConditionalOnMissingBean(name={"springCloudAzureDefaultCredential"})
    @Bean(name={"springCloudAzureDefaultCredential"})
    @Order
    TokenCredential tokenCredential(DefaultAzureCredentialBuilderFactory factory, AzureTokenCredentialResolver resolver) {
        TokenCredential globalTokenCredential = resolver.resolve((AzureProperties)this.identityClientProperties);
        if (globalTokenCredential != null) {
            return globalTokenCredential;
        }
        LOGGER.debug("No global token credential found, constructing default credential.");
        return ((DefaultAzureCredentialBuilder)factory.build()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    DefaultAzureCredentialBuilderFactory azureCredentialBuilderFactory(ObjectProvider<AzureServiceClientBuilderCustomizer<DefaultAzureCredentialBuilder>> customizers, @Qualifier(value="springCloudAzureCredentialTaskExecutor") ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        DefaultAzureCredentialBuilderFactory factory = new DefaultAzureCredentialBuilderFactory((AzureProperties)this.identityClientProperties);
        factory.setExecutorService((ExecutorService)threadPoolTaskExecutor.getThreadPoolExecutor());
        customizers.orderedStream().forEach(arg_0 -> ((DefaultAzureCredentialBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    AzureTokenCredentialResolver azureTokenCredentialResolver(ClientSecretCredentialBuilderFactory clientSecretCredentialBuilderFactory, ClientCertificateCredentialBuilderFactory clientCertificateCredentialBuilderFactory, UsernamePasswordCredentialBuilderFactory usernamePasswordCredentialBuilderFactory, ManagedIdentityCredentialBuilderFactory managedIdentityCredentialBuilderFactory) {
        return new AzureTokenCredentialResolver(azureProperties -> {
            if (azureProperties.getCredential() == null) {
                return null;
            }
            String tokenCredentialBeanName = azureProperties.getCredential().getTokenCredentialBeanName();
            if (StringUtils.hasText((String)tokenCredentialBeanName)) {
                return (TokenCredential)this.applicationContext.getBean(tokenCredentialBeanName, TokenCredential.class);
            }
            TokenCredentialOptionsProvider.TokenCredentialOptions properties = azureProperties.getCredential();
            String tenantId = azureProperties.getProfile().getTenantId();
            String clientId = properties.getClientId();
            boolean isClientIdSet = StringUtils.hasText((String)clientId);
            String authorityHost = azureProperties.getProfile().getEnvironment().getActiveDirectoryEndpoint();
            if (StringUtils.hasText((String)tenantId)) {
                if (isClientIdSet && StringUtils.hasText((String)properties.getClientSecret())) {
                    return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)clientSecretCredentialBuilderFactory.build()).authorityHost(authorityHost)).clientId(clientId)).clientSecret(properties.getClientSecret()).tenantId(tenantId)).build();
                }
                String clientCertificatePath = properties.getClientCertificatePath();
                if (StringUtils.hasText((String)clientCertificatePath)) {
                    ClientCertificateCredentialBuilder builder = (ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)clientCertificateCredentialBuilderFactory.build()).authorityHost(authorityHost)).tenantId(tenantId)).clientId(clientId);
                    if (StringUtils.hasText((String)properties.getClientCertificatePassword())) {
                        builder.pfxCertificate(clientCertificatePath).clientCertificatePassword(properties.getClientCertificatePassword());
                    } else {
                        builder.pemCertificate(clientCertificatePath);
                    }
                    return builder.build();
                }
            }
            if (isClientIdSet && StringUtils.hasText((String)properties.getUsername()) && StringUtils.hasText((String)properties.getPassword())) {
                return ((UsernamePasswordCredentialBuilder)((UsernamePasswordCredentialBuilder)((UsernamePasswordCredentialBuilder)((UsernamePasswordCredentialBuilder)usernamePasswordCredentialBuilderFactory.build()).authorityHost(authorityHost)).username(properties.getUsername()).password(properties.getPassword()).clientId(clientId)).tenantId(tenantId)).build();
            }
            if (properties.isManagedIdentityEnabled()) {
                ManagedIdentityCredentialBuilder builder = (ManagedIdentityCredentialBuilder)managedIdentityCredentialBuilderFactory.build();
                if (isClientIdSet) {
                    builder.clientId(clientId);
                }
                return builder.build();
            }
            return null;
        });
    }

    @Bean
    @ConditionalOnMissingBean
    ClientSecretCredentialBuilderFactory clientSecretCredentialBuilderFactory(@Qualifier(value="springCloudAzureCredentialTaskExecutor") ThreadPoolTaskExecutor threadPoolTaskExecutor, ObjectProvider<AzureServiceClientBuilderCustomizer<ClientSecretCredentialBuilder>> customizers) {
        ClientSecretCredentialBuilderFactory factory = new ClientSecretCredentialBuilderFactory((AzureProperties)this.identityClientProperties);
        factory.setExecutorService((ExecutorService)threadPoolTaskExecutor.getThreadPoolExecutor());
        customizers.orderedStream().forEach(arg_0 -> ((ClientSecretCredentialBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    ClientCertificateCredentialBuilderFactory clientCertificateCredentialBuilderFactory(@Qualifier(value="springCloudAzureCredentialTaskExecutor") ThreadPoolTaskExecutor threadPoolTaskExecutor, ObjectProvider<AzureServiceClientBuilderCustomizer<ClientCertificateCredentialBuilder>> customizers) {
        ClientCertificateCredentialBuilderFactory factory = new ClientCertificateCredentialBuilderFactory((AzureProperties)this.identityClientProperties);
        factory.setExecutorService((ExecutorService)threadPoolTaskExecutor.getThreadPoolExecutor());
        customizers.orderedStream().forEach(arg_0 -> ((ClientCertificateCredentialBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    ManagedIdentityCredentialBuilderFactory managedIdentityCredentialBuilderFactory(ObjectProvider<AzureServiceClientBuilderCustomizer<ManagedIdentityCredentialBuilder>> customizers) {
        ManagedIdentityCredentialBuilderFactory factory = new ManagedIdentityCredentialBuilderFactory((AzureProperties)this.identityClientProperties);
        customizers.orderedStream().forEach(arg_0 -> ((ManagedIdentityCredentialBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    UsernamePasswordCredentialBuilderFactory usernamePasswordCredentialBuilderFactory(ObjectProvider<AzureServiceClientBuilderCustomizer<UsernamePasswordCredentialBuilder>> customizers) {
        UsernamePasswordCredentialBuilderFactory factory = new UsernamePasswordCredentialBuilderFactory((AzureProperties)this.identityClientProperties);
        customizers.orderedStream().forEach(arg_0 -> ((UsernamePasswordCredentialBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean(name={"springCloudAzureCredentialTaskExecutor"})
    @ConditionalOnMissingBean(name={"springCloudAzureCredentialTaskExecutor"})
    ThreadPoolTaskExecutor credentialTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(8);
        executor.setAllowCoreThreadTimeOut(true);
        executor.setThreadNamePrefix("az-identity-");
        return executor;
    }

    IdentityClientProperties getIdentityClientProperties() {
        return this.identityClientProperties;
    }

    static class IdentityClientProperties
    extends AbstractAzureHttpConfigurationProperties {
        IdentityClientProperties() {
        }
    }
}

