/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class AadResourceServerProperties
implements InitializingBean {
    public static final String PREFIX = "spring.cloud.azure.active-directory.resource-server";
    public static final Map<String, String> DEFAULT_CLAIM_TO_AUTHORITY_PREFIX_MAP;
    private String principalClaimName;
    private Map<String, String> claimToAuthorityPrefixMap;

    public String getPrincipalClaimName() {
        return this.principalClaimName;
    }

    public void setPrincipalClaimName(String principalClaimName) {
        this.principalClaimName = principalClaimName;
    }

    public Map<String, String> getClaimToAuthorityPrefixMap() {
        return this.claimToAuthorityPrefixMap;
    }

    public void setClaimToAuthorityPrefixMap(Map<String, String> claimToAuthorityPrefixMap) {
        this.claimToAuthorityPrefixMap = claimToAuthorityPrefixMap;
    }

    public void afterPropertiesSet() {
        if (!StringUtils.hasText((String)this.principalClaimName)) {
            this.principalClaimName = "sub";
        }
        if (this.claimToAuthorityPrefixMap == null || this.claimToAuthorityPrefixMap.isEmpty()) {
            this.claimToAuthorityPrefixMap = DEFAULT_CLAIM_TO_AUTHORITY_PREFIX_MAP;
        }
    }

    static {
        HashMap<String, String> claimAuthorityMap = new HashMap<String, String>();
        claimAuthorityMap.put("scp", "SCOPE_");
        claimAuthorityMap.put("roles", "APPROLE_");
        DEFAULT_CLAIM_TO_AUTHORITY_PREFIX_MAP = Collections.unmodifiableMap(claimAuthorityMap);
    }
}

