/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation.http.policy;

import java.util.Arrays;
import java.util.List;

public class FeatureFlagTracing {
    private static final String CUSTOM_FILTER = "CSTM";
    private static final String PERCENTAGE_FILTER = "PRCNT";
    private static final String TIME_WINDOW_FILTER = "TIME";
    private static final String TARGETING_FILTER = "TRGT";
    private static final String FILTER_TYPE_DELIMITER = "+";
    private static final List<String> PERCENTAGE_FILTER_NAMES = Arrays.asList("Percentage", "Microsoft.Percentage", "PercentageFilter", "Microsoft.PercentageFilter");
    private static final List<String> TIME_WINDOW_FILTER_NAMES = Arrays.asList("TimeWindow", "Microsoft.TimeWindow", "TimeWindowFilter", "Microsoft.TimeWindowFilter");
    private static final List<String> TARGETING_FILTER_NAMES = Arrays.asList("Targeting", "Microsoft.Targeting", "TargetingFilter", "Microsoft.TargetingFilter");
    private Boolean usesCustomFilter = false;
    private Boolean usesPercentageFilter = false;
    private Boolean usesTimeWindowFilter = false;
    private Boolean usesTargetingFilter = false;

    public boolean usesAnyFilter() {
        return this.usesCustomFilter != false || this.usesPercentageFilter != false || this.usesTimeWindowFilter != false || this.usesTargetingFilter != false;
    }

    public void resetFeatureFilterTelemetry() {
        this.usesCustomFilter = false;
        this.usesPercentageFilter = false;
        this.usesTimeWindowFilter = false;
        this.usesTargetingFilter = false;
    }

    public void updateFeatureFilterTelemetry(String filterName) {
        if (PERCENTAGE_FILTER_NAMES.stream().anyMatch(name -> name.equalsIgnoreCase(filterName))) {
            this.usesPercentageFilter = true;
        } else if (TIME_WINDOW_FILTER_NAMES.stream().anyMatch(name -> name.equalsIgnoreCase(filterName))) {
            this.usesTimeWindowFilter = true;
        } else if (TARGETING_FILTER_NAMES.stream().anyMatch(name -> name.equalsIgnoreCase(filterName))) {
            this.usesTargetingFilter = true;
        } else {
            this.usesCustomFilter = true;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.usesCustomFilter.booleanValue()) {
            sb.append(CUSTOM_FILTER);
        }
        if (this.usesPercentageFilter.booleanValue()) {
            sb.append(sb.length() > 0 ? FILTER_TYPE_DELIMITER : "").append(PERCENTAGE_FILTER);
        }
        if (this.usesTimeWindowFilter.booleanValue()) {
            sb.append(sb.length() > 0 ? FILTER_TYPE_DELIMITER : "").append(TIME_WINDOW_FILTER);
        }
        if (this.usesTargetingFilter.booleanValue()) {
            sb.append(sb.length() > 0 ? FILTER_TYPE_DELIMITER : "").append(TARGETING_FILTER);
        }
        return sb.toString();
    }
}

