/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.b2c;

import com.azure.spring.aad.AADTrustedIssuerRepository;
import com.azure.spring.autoconfigure.b2c.AADB2CProperties;
import java.util.Locale;
import java.util.Map;
import org.springframework.util.Assert;

public class AADB2CTrustedIssuerRepository
extends AADTrustedIssuerRepository {
    private final String resolvedBaseUri;
    private final Map<String, String> userFlows;
    private final AADB2CProperties aadb2CProperties;

    public AADB2CTrustedIssuerRepository(AADB2CProperties aadb2CProperties) {
        super(aadb2CProperties.getTenantId());
        this.aadb2CProperties = aadb2CProperties;
        this.resolvedBaseUri = this.resolveBaseUri(aadb2CProperties.getBaseUri());
        this.userFlows = aadb2CProperties.getUserFlows();
        this.addB2CIssuer();
        this.addB2CUserFlowIssuers();
    }

    private void addB2CIssuer() {
        Assert.notNull((Object)this.aadb2CProperties, (String)"aadb2CProperties cannot be null.");
        Assert.notNull((Object)this.resolvedBaseUri, (String)"resolvedBaseUri cannot be null.");
        String b2cIss = String.format("%s/%s/v2.0/", this.resolvedBaseUri, this.tenantId);
        String oidcIssuerLocation = String.format("%s/%s/%s/v2.0/", this.resolvedBaseUri, this.tenantId, this.userFlows.get(this.aadb2CProperties.getLoginFlow()));
        this.addTrustedIssuer(b2cIss, oidcIssuerLocation);
    }

    private void addB2CUserFlowIssuers() {
        Assert.notNull((Object)this.resolvedBaseUri, (String)"resolvedBaseUri cannot be null.");
        Assert.notNull(this.userFlows, (String)"userFlows cannot be null.");
        this.userFlows.keySet().stream().map(uf -> String.format("%s/tfp/%s/%s/v2.0/", this.resolvedBaseUri, this.tenantId, uf.toLowerCase(Locale.ROOT))).forEach(xva$0 -> this.addTrustedIssuer((String)xva$0));
    }
}

