/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.storage;

import com.azure.core.http.policy.HttpLogOptions;
import com.azure.spring.autoconfigure.storage.StorageProperties;
import com.azure.spring.autoconfigure.storage.resource.AzureStorageProtocolResolver;
import com.azure.spring.utils.ApplicationId;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.share.ShareServiceClientBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={BlobServiceClientBuilder.class, ShareServiceClientBuilder.class})
@ConditionalOnResource(resources={"classpath:storage.enable.config"})
@EnableConfigurationProperties(value={StorageProperties.class})
public class StorageAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"azure.storage.blob-endpoint"})
    public BlobServiceClientBuilder blobServiceClientBuilder(StorageProperties storageProperties) {
        String accountName = storageProperties.getAccountName();
        String accountKey = storageProperties.getAccountKey();
        return new BlobServiceClientBuilder().endpoint(storageProperties.getBlobEndpoint()).credential(new StorageSharedKeyCredential(accountName, accountKey)).httpLogOptions(new HttpLogOptions().setApplicationId(ApplicationId.AZURE_SPRING_STORAGE_BLOB));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"azure.storage.file-endpoint"})
    public ShareServiceClientBuilder shareServiceClientBuilder(StorageProperties storageProperties) {
        String accountName = storageProperties.getAccountName();
        String accountKey = storageProperties.getAccountKey();
        return new ShareServiceClientBuilder().endpoint(storageProperties.getFileEndpoint()).credential(new StorageSharedKeyCredential(accountName, accountKey)).httpLogOptions(new HttpLogOptions().setApplicationId(ApplicationId.AZURE_SPRING_STORAGE_FILES));
    }

    @Configuration
    @ConditionalOnClass(value={AzureStorageProtocolResolver.class})
    @Import(value={AzureStorageProtocolResolver.class})
    static class StorageResourceConfiguration {
        StorageResourceConfiguration() {
        }
    }
}

