/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapi;

import com.azure.spring.aad.AADAuthorizationServerEndpoints;
import com.azure.spring.aad.webapi.AADResourceServerWebSecurityConfigurerAdapter;
import com.azure.spring.aad.webapi.validator.AADJwtAudienceValidator;
import com.azure.spring.aad.webapi.validator.AADJwtIssuerValidator;
import com.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import com.azure.spring.autoconfigure.condition.aad.ResourceServerCondition;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ResourceServerCondition.class})
public class AADResourceServerConfiguration {
    @Autowired
    private AADAuthenticationProperties aadAuthenticationProperties;

    @Bean
    @ConditionalOnMissingBean(value={JwtDecoder.class})
    public JwtDecoder jwtDecoder() {
        AADAuthorizationServerEndpoints identityEndpoints = new AADAuthorizationServerEndpoints(this.aadAuthenticationProperties.getBaseUri(), this.aadAuthenticationProperties.getTenantId());
        NimbusJwtDecoder nimbusJwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)identityEndpoints.jwkSetEndpoint()).build();
        List<OAuth2TokenValidator<Jwt>> validators = this.createDefaultValidator();
        nimbusJwtDecoder.setJwtValidator((OAuth2TokenValidator)new DelegatingOAuth2TokenValidator(validators));
        return nimbusJwtDecoder;
    }

    public List<OAuth2TokenValidator<Jwt>> createDefaultValidator() {
        ArrayList<OAuth2TokenValidator<Jwt>> validators = new ArrayList<OAuth2TokenValidator<Jwt>>();
        ArrayList<String> validAudiences = new ArrayList<String>();
        if (StringUtils.hasText((String)this.aadAuthenticationProperties.getAppIdUri())) {
            validAudiences.add(this.aadAuthenticationProperties.getAppIdUri());
        }
        if (StringUtils.hasText((String)this.aadAuthenticationProperties.getClientId())) {
            validAudiences.add(this.aadAuthenticationProperties.getClientId());
        }
        if (!validAudiences.isEmpty()) {
            validators.add(new AADJwtAudienceValidator(validAudiences));
        }
        validators.add(new AADJwtIssuerValidator());
        validators.add((OAuth2TokenValidator<Jwt>)new JwtTimestampValidator());
        return validators;
    }

    @Configuration
    @EnableWebSecurity
    @EnableGlobalMethodSecurity(prePostEnabled=true)
    @ConditionalOnMissingBean(value={WebSecurityConfigurerAdapter.class})
    @ConditionalOnExpression(value="!'${azure.activedirectory.application-type}'.equalsIgnoreCase('web_application_and_resource_server')")
    public static class DefaultAADResourceServerWebSecurityConfigurerAdapter
    extends AADResourceServerWebSecurityConfigurerAdapter {
        @Override
        protected void configure(HttpSecurity http) throws Exception {
            super.configure(http);
        }
    }
}

