/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.AccessPolicy;
import java.io.IOException;

public final class SignedIdentifier
implements JsonSerializable<SignedIdentifier> {
    private String id;
    private AccessPolicy accessPolicy;

    public String id() {
        return this.id;
    }

    public SignedIdentifier withId(String id) {
        this.id = id;
        return this;
    }

    public AccessPolicy accessPolicy() {
        return this.accessPolicy;
    }

    public SignedIdentifier withAccessPolicy(AccessPolicy accessPolicy) {
        this.accessPolicy = accessPolicy;
        return this;
    }

    public void validate() {
        if (this.accessPolicy() != null) {
            this.accessPolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("accessPolicy", (JsonSerializable)this.accessPolicy);
        return jsonWriter.writeEndObject();
    }

    public static SignedIdentifier fromJson(JsonReader jsonReader) throws IOException {
        return (SignedIdentifier)jsonReader.readObject(reader -> {
            SignedIdentifier deserializedSignedIdentifier = new SignedIdentifier();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSignedIdentifier.id = reader.getString();
                    continue;
                }
                if ("accessPolicy".equals(fieldName)) {
                    deserializedSignedIdentifier.accessPolicy = AccessPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSignedIdentifier;
        });
    }
}

