/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.LeaseContainerRequestAction;
import java.io.IOException;

public final class LeaseContainerRequest
implements JsonSerializable<LeaseContainerRequest> {
    private LeaseContainerRequestAction action;
    private String leaseId;
    private Integer breakPeriod;
    private Integer leaseDuration;
    private String proposedLeaseId;
    private static final ClientLogger LOGGER = new ClientLogger(LeaseContainerRequest.class);

    public LeaseContainerRequestAction action() {
        return this.action;
    }

    public LeaseContainerRequest withAction(LeaseContainerRequestAction action) {
        this.action = action;
        return this;
    }

    public String leaseId() {
        return this.leaseId;
    }

    public LeaseContainerRequest withLeaseId(String leaseId) {
        this.leaseId = leaseId;
        return this;
    }

    public Integer breakPeriod() {
        return this.breakPeriod;
    }

    public LeaseContainerRequest withBreakPeriod(Integer breakPeriod) {
        this.breakPeriod = breakPeriod;
        return this;
    }

    public Integer leaseDuration() {
        return this.leaseDuration;
    }

    public LeaseContainerRequest withLeaseDuration(Integer leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public String proposedLeaseId() {
        return this.proposedLeaseId;
    }

    public LeaseContainerRequest withProposedLeaseId(String proposedLeaseId) {
        this.proposedLeaseId = proposedLeaseId;
        return this;
    }

    public void validate() {
        if (this.action() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property action in model LeaseContainerRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        jsonWriter.writeStringField("leaseId", this.leaseId);
        jsonWriter.writeNumberField("breakPeriod", (Number)this.breakPeriod);
        jsonWriter.writeNumberField("leaseDuration", (Number)this.leaseDuration);
        jsonWriter.writeStringField("proposedLeaseId", this.proposedLeaseId);
        return jsonWriter.writeEndObject();
    }

    public static LeaseContainerRequest fromJson(JsonReader jsonReader) throws IOException {
        return (LeaseContainerRequest)jsonReader.readObject(reader -> {
            LeaseContainerRequest deserializedLeaseContainerRequest = new LeaseContainerRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("action".equals(fieldName)) {
                    deserializedLeaseContainerRequest.action = LeaseContainerRequestAction.fromString(reader.getString());
                    continue;
                }
                if ("leaseId".equals(fieldName)) {
                    deserializedLeaseContainerRequest.leaseId = reader.getString();
                    continue;
                }
                if ("breakPeriod".equals(fieldName)) {
                    deserializedLeaseContainerRequest.breakPeriod = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("leaseDuration".equals(fieldName)) {
                    deserializedLeaseContainerRequest.leaseDuration = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("proposedLeaseId".equals(fieldName)) {
                    deserializedLeaseContainerRequest.proposedLeaseId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLeaseContainerRequest;
        });
    }
}

